package com.tydic.dyc.ssc.service.project;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.project.ISscProjectModel;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.project.qrybo.*;
import com.tydic.dyc.ssc.model.project.sub.SscProjectChange;
import com.tydic.dyc.ssc.model.project.sub.SscProjectNotice;
import com.tydic.dyc.ssc.service.project.bo.SscProjectChangeBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryProjectNoticeDetailReqBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryProjectNoticeDetailRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscQryProjectNoticeDetailServiceImpl
 * @Author: the_xhl
 * @Date: 2022-12-28
 */
@HTServiceImpl
public class SscQryProjectNoticeDetailServiceImpl implements SscQryProjectNoticeDetailService {

    @Autowired
    private ISscProjectModel iSscProjectModel;


    @Override
    public SscQryProjectNoticeDetailRspBO qryProjectNoticeDetail(SscQryProjectNoticeDetailReqBO sscQryProjectNoticeDetailReqBO) {
        SscQryProjectNoticeDetailRspBO rspBO = SscRu.success(SscQryProjectNoticeDetailRspBO.class);
        // 参数校验
        check(sscQryProjectNoticeDetailReqBO);
        // 调用项目公告详情查询方法
        SscBidProjectDo sscBidProjectDo = iSscProjectModel.qryProjectNoticeDetail(JUtil.js(sscQryProjectNoticeDetailReqBO, SscBidProjectQryBo.class));
        List<SscProjectNotice> sscProjectNotice = sscBidProjectDo.getSscProjectNotice();
        if (CollectionUtil.isEmpty(sscProjectNotice)) {
            return rspBO;
        }
        BeanUtil.copyProperties(sscProjectNotice.get(0), rspBO);
        // 公告类型为 招标公告 或 邀请公告 或 变更公告时 调用项目变更信息查询方法
        Integer noticeType = rspBO.getNoticeType();
        if (SscCommConstant.NoticeTypeEnum.BID_NOTICE.getCode().equals(noticeType)
                || SscCommConstant.NoticeTypeEnum.INVITATION.getCode().equals(noticeType)
                || SscCommConstant.NoticeTypeEnum.CHANGE_NOTICE.getCode().equals(noticeType)) {
            SscBidProjectQryBo sscBidProjectQryBo = new SscBidProjectQryBo();
            sscBidProjectQryBo.setProjectId(rspBO.getProjectId());
            sscBidProjectQryBo.setNoticeId(rspBO.getNoticeId());
            SscBidProjectDo bidProjectDo = iSscProjectModel.qryProjectChangeList(sscBidProjectQryBo);
            List<SscProjectChange> sscProjectChangeList = bidProjectDo.getSscProjectChange();
            if (CollectionUtil.isNotEmpty(sscProjectChangeList)) {
                List<SscProjectChangeBO> sscProjectChangeBOList = sscProjectChangeList.stream().map(e -> {
                    SscProjectChangeBO sscProjectChangeBO = BeanUtil.toBean(e, SscProjectChangeBO.class);
                    // 评标方法翻译
                    sscProjectChangeBO.setBidEvalMethodStr(SscCommConstant.BidEvalMethodEnum.findDescByCode(sscProjectChangeBO.getBidEvalMethod()).getDesc());
                    return sscProjectChangeBO;
                }).collect(Collectors.toList());
                rspBO.setSscProjectChangeList(sscProjectChangeBOList);
            }
        }
        // 公告类型翻译
        rspBO.setNoticeTypeStr(SscCommConstant.NoticeTypeEnum.findDescByCode(rspBO.getNoticeType()).getDesc());
        // todo 公告状态翻译
        return rspBO;
    }

    private void check(SscQryProjectNoticeDetailReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
    }
}
