package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeAcceptRecord;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeEntrustRecord;
import com.tydic.dyc.ssc.service.scheme.bo.SscAcceptPurchaseSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAcceptPurchaseSchemeRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscImplementSchemeReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 类名：SscAcceptPurchaseSchemeServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/11
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscAcceptPurchaseSchemeServiceImpl implements SscAcceptPurchaseSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Override
    public SscAcceptPurchaseSchemeRspBO acceptPurchaseScheme(SscAcceptPurchaseSchemeReqBO sscAcceptPurchaseSchemeReqBO) {
        validData(sscAcceptPurchaseSchemeReqBO);
        //方案主体修改：修改执行人信息
        SscSchemeDo updateSscSchemeDo = new SscSchemeDo();
        updateSscSchemeDo.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        updateSscSchemeDo.setImplId(sscAcceptPurchaseSchemeReqBO.getAcceptUserId());
        updateSscSchemeDo.setImplName(sscAcceptPurchaseSchemeReqBO.getAcceptUserName());
        if (!sscAcceptPurchaseSchemeReqBO.getOperStatus()) {
            updateSscSchemeDo.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
            updateSscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.FORWARDING.getCode());
        }
        updateSscSchemeDo.setSchemeStatus(sscAcceptPurchaseSchemeReqBO.getOperStatus() ? SscCommConstant.SchemeStatus.FORWARDING.getCode() : SscCommConstant.SchemeStatus.BACK.getCode());
        updateSscSchemeDo.setOperTime(new Date());
        iSscSchemeModel.updateSchemeMain(updateSscSchemeDo);
        //	调用任务主体修改：改为已办
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(sscAcceptPurchaseSchemeReqBO.getUserId());
        uocOrderTaskInst.setDealOperName(sscAcceptPurchaseSchemeReqBO.getUsername());
        uocOrderTaskInst.setOrderId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setTaskInstId(sscAcceptPurchaseSchemeReqBO.getTaskId());
        uocOrderTaskInst.setObjId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setObjType(1);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        List<UocOrderTaskInst> taskList = new ArrayList<>();
        taskList.add(uocOrderTaskInst);
        sscProcInstDo.setSscUocOrderTaskInst(taskList);
        iSscProcInstModel.updateTask(sscProcInstDo);
        //调用受理记录新增方法
        List<SscSchemeAcceptRecord> sscSchemeAcceptRecords = new ArrayList<>();
        SscSchemeAcceptRecord sscSchemeAcceptRecord = new SscSchemeAcceptRecord();
        sscSchemeAcceptRecord.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        sscSchemeAcceptRecord.setAcceptUserId(sscAcceptPurchaseSchemeReqBO.getUserId());
        sscSchemeAcceptRecord.setAcceptUserName(sscAcceptPurchaseSchemeReqBO.getUsername());
        sscSchemeAcceptRecord.setRemark(sscAcceptPurchaseSchemeReqBO.getRemark());
        sscSchemeAcceptRecord.setCreateTime(new Date());
        if (sscAcceptPurchaseSchemeReqBO.getOperStatus()) {
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.ASSIGNED.getCode());
        } else {
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.NO_ACCEPT.getCode());
        }
        sscSchemeAcceptRecords.add(sscSchemeAcceptRecord);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeAcceptRecord(sscSchemeAcceptRecords);
        iSscSchemeModel.addSchemeAcceptRecord(sscSchemeDo);
        //	调用委托记录新增方法
        List<SscSchemeEntrustRecord> sscSchemeEntrustRecords = new ArrayList<>();
        SscSchemeEntrustRecord sscSchemeEntrustRecord = new SscSchemeEntrustRecord();
        sscSchemeEntrustRecord.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        sscSchemeEntrustRecord.setAgencyCode(sscAcceptPurchaseSchemeReqBO.getAgencyCode());
        sscSchemeEntrustRecord.setAgencyName(sscAcceptPurchaseSchemeReqBO.getAgencyName());
        sscSchemeEntrustRecord.setRemark(sscAcceptPurchaseSchemeReqBO.getRemark());
        sscSchemeEntrustRecord.setCreateTime(new Date());

        if (sscAcceptPurchaseSchemeReqBO.getOperStatus()) {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.FORWARDING.getCode()));
        } else {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.BACK.getCode()));
        }
        sscSchemeEntrustRecords.add(sscSchemeEntrustRecord);
        sscSchemeDo.setSscSchemeEntrustRecord(sscSchemeEntrustRecords);
        iSscSchemeModel.addSchemeEntrustRecord(sscSchemeDo);
        return new SscAcceptPurchaseSchemeRspBO();
    }

    private void validData(SscAcceptPurchaseSchemeReqBO reqBo) {
        if (!reqBo.getOperStatus() & reqBo.getRemark() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "拒绝时，原因必填");
        }
        if (reqBo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象为空");
        }
        if (reqBo.getOperStatus() && reqBo.getAcceptUserId() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参操作人id为空");
        }
        if (reqBo.getOperStatus() && reqBo.getAcceptUserName() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参执行人名称为空");
        }
    }
}
