package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBatchRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeReqBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: dmc
 * @Date: 2022/11/11 15:15
 * @Description: SSCS0005-方案明细批量删除服务
 */
@Slf4j
@HTServiceImpl
public class SscDeleteSchemeMatBatchServiceImpl implements SscDeleteSchemeMatBatchService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscDeleteSchemeMatBatchRspBO deleteSchemeMatBatch(SscDeleteSchemeMatBatchReqBO reqBO) {
        //1 入参校验
        this.validationParam(reqBO);
        SscDeleteSchemeMatBatchRspBO rspBO = SscRu.success(SscDeleteSchemeMatBatchRspBO.class);

        //2 入参封装
        SscSchemeDo reqBO1 = SscRu.js(reqBO, SscSchemeDo.class);
        reqBO1.setSscSchemeMat(SscRu.jsl(reqBO.getSscSchemeMat(), SscSchemeMat.class));

        //3 调用方案明细批量删除方法
        this.iSscSchemeModel.deleteSchemeMatBatch(reqBO1);

        // 删除扩展字段信息
        this.deleteExtInfo(reqBO);

        return rspBO;
    }

    /**
     * 入参校验
     *
     * @param reqBO reqBO
     */
    private void validationParam(SscDeleteSchemeMatBatchReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空！");
        }
        if (ObjectUtil.isEmpty(reqBO.getEnableDraft())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空！");
        }
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空！");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeMatBatchReqBO reqBO) {
        List<SscDeleteSchemeMatBO> sscSchemeMat = reqBO.getSscSchemeMat();
        Boolean enableDraft = reqBO.getEnableDraft();
        if (CollectionUtil.isNotEmpty(sscSchemeMat)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> matObjInfoList = sscSchemeMat.stream()
                    .map(x -> {
                        SscExtObjInfo objInfo = new SscExtObjInfo();
                        objInfo.setObjId(x.getSchemeMatId());
                        objInfo.setObjType(enableDraft ?  SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT);
                        objInfo.setExtInfo(SscRu.jsl(x.getExtFields(), SscExtInfo.class));
                        return objInfo;
                    }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(matObjInfoList);
            iSscCommonModel.deleteExtInfo(sscCommonDo);
        }
    }
}
