package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMatBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMatBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * SscUpdateSchemeMatBatchServiceImpl
 * 2022/11/14
 * Project:work
 * Creator:印昌盛
 * Create Time:2022/11/14-11-38
 * IDE: IntelliJ IDEA
 */
@HTServiceImpl
public class SscUpdateSchemeMatBatchServiceImpl implements SscUpdateSchemeMatBatchService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscUpdateSchemeMatBatchRspBO updateSchemeMatBatch(SscUpdateSchemeMatBatchReqBO sscUpdateSchemeMatBatchReqBO) {
        SscSchemeDo sscSchemeDo = JSON.parseObject(JSON.toJSONString(sscUpdateSchemeMatBatchReqBO), SscSchemeDo.class);
        iSscSchemeModel.updateSchemeMatBatch(sscSchemeDo);
        // 扩展字段修改
        this.updateExtInfo(sscUpdateSchemeMatBatchReqBO, sscSchemeDo);
        return SscRu.success(SscUpdateSchemeMatBatchRspBO.class);
    }

    private void updateExtInfo(SscUpdateSchemeMatBatchReqBO reqBO, SscSchemeDo sscSchemeDo) {
        Boolean enableDraft = reqBO.getEnableDraft();
        SscCommonDo sscCommonDo = new SscCommonDo();
        // 删除明细扩展
        List<SscUpdateSchemeMatBO> schemeMat = reqBO.getSscSchemeMat();
        SscCommonDo delCommonDo = new SscCommonDo();
        List<SscExtObjInfo> delObjInfoList = schemeMat.stream().map(e -> {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(e.getSchemeMatId());
            objInfo.setObjType(enableDraft ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT);
            return objInfo;
        }).collect(Collectors.toList());
        delCommonDo.setExtObjInfos(delObjInfoList);
        if (CollectionUtil.isNotEmpty(delObjInfoList)) {
            this.iSscCommonModel.deleteExtInfo(delCommonDo);
        }
        // 新增明细
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo.getSscSchemeMat();
        List<SscExtObjInfo> matObjInfoList = sscSchemeMat
                .stream()
                .filter(e -> CollectionUtil.isNotEmpty(e.getExtFields()))
                .map(e -> {
                    SscExtObjInfo objInfo = new SscExtObjInfo();
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setOrderId(reqBO.getSchemeId());
                    objInfo.setObjType(enableDraft ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT);
                    objInfo.setExtInfo(SscRu.jsl(e.getExtFields(), SscExtInfo.class));
                    return objInfo;
                }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(matObjInfoList)) {
            sscCommonDo.setExtObjInfos(matObjInfoList);
            iSscCommonModel.addExtInfo(sscCommonDo);
        }
    }
}
