/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeInviteSupBatchService;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeInviteSupBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeInviteSupBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeInviteSupBatchService"})
public class SscDeleteSchemeInviteSupBatchServiceImpl
implements SscDeleteSchemeInviteSupBatchService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"deleteSchemeInviteSupBatch"})
    public SscDeleteSchemeInviteSupBatchRspBO deleteSchemeInviteSupBatch(@RequestBody SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        SscDeleteSchemeInviteSupBatchRspBO rspBO = SscRu.success(SscDeleteSchemeInviteSupBatchRspBO.class);
        this.validationParam(reqBO);
        SscSchemeDo sscSchemeDo = SscRu.js(reqBO, SscSchemeDo.class);
        this.iSscSchemeModel.deleteSchemeInviteSupBatch(sscSchemeDo);
        this.deleteExtInfo(reqBO);
        return rspBO;
    }

    private void validationParam(SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscDeleteSchemeInviteSupBatchReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeInviteSupBatchReqBO reqBO) {
        List sscSchemeInviteSup = reqBO.getSscSchemeInviteSup();
        Boolean enableDraft = reqBO.getEnableDraft();
        if (CollectionUtil.isNotEmpty((Collection)sscSchemeInviteSup)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> matObjInfoList = sscSchemeInviteSup.stream().map(x -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(x.getSchemeInviteSupId());
                objInfo.setObjType(enableDraft != false ? "ssc_scheme_invite_sup_ext_draft" : "ssc_scheme_invite_sup_ext");
                return objInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(matObjInfoList);
            this.iSscCommonModel.deleteExtInfo(sscCommonDo);
        }
    }
}

