package com.tydic.dyc.ssc.service.project;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.project.ISscProjectModel;
import com.tydic.dyc.ssc.model.project.SscBidProjectDo;
import com.tydic.dyc.ssc.model.project.qrybo.SscBidProjectQryBo;
import com.tydic.dyc.ssc.model.project.sub.SscQuotationItemAdd;
import com.tydic.dyc.ssc.service.project.bo.SscQryQuotationItemAddLIstReqBO;
import com.tydic.dyc.ssc.service.project.bo.SscQryQuotationItemAddLIstRspBO;
import com.tydic.dyc.ssc.service.project.bo.SscQuotationItemAddBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscQryQuotationItemAddLIstServiceImpl
 * @Author: the_xhl
 * @Date: 2022-12-28
 */
@HTServiceImpl
public class SscQryQuotationItemAddLIstServiceImpl implements SscQryQuotationItemAddLIstService {


    @Autowired
    private ISscProjectModel iSscProjectModel;

    @Override
    public SscQryQuotationItemAddLIstRspBO qryQuotationItemAddLIst(SscQryQuotationItemAddLIstReqBO sscQryQuotationItemAddLIstReqBO) {
        SscQryQuotationItemAddLIstRspBO rspBO = SscRu.success(SscQryQuotationItemAddLIstRspBO.class);
        // 参数校验
        check(sscQryQuotationItemAddLIstReqBO);
        SscBidProjectDo sscBidProjectDo = iSscProjectModel.qryQuotationItemAddLIst(JUtil.js(sscQryQuotationItemAddLIstReqBO, SscBidProjectQryBo.class));
        List<SscQuotationItemAdd> sscQuotationItemAdd = sscBidProjectDo.getSscQuotationItemAdd();
        if (CollectionUtil.isEmpty(sscQuotationItemAdd)) {
            return rspBO;
        }
        List<SscQuotationItemAddBO> sscQuotationItemAddBOList = sscQuotationItemAdd.stream().map(e -> JUtil.js(e, SscQuotationItemAddBO.class)).collect(Collectors.toList());
        rspBO.setQuotationItemAddLIst(sscQuotationItemAddBOList);
        return rspBO;
    }

    private void check(SscQryQuotationItemAddLIstReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getProjectId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[projectId]不能为空");
        }
    }
}
