package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SchemeMatBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeMatListReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeMatListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: dmc
 * @Date: 2022/11/10 12:21
 * @Description: 方案明细分页查询服务
 */
@HTServiceImpl
public class SscQrySchemeMatListServiceImpl implements SscQrySchemeMatListService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemeMatListPageRspBO qrySchemeMatList(SscQrySchemeMatListPageReqBO reqBO) {
        //1 入参校验
        this.validationParam(reqBO);
        //2 组装入参
        SscQrySchemeMatListReqBO qrySchemeMatListReqBO = SscRu.js(reqBO, SscQrySchemeMatListReqBO.class);
        //3 方案明细分页查询方法
        SscQrySchemeMatListRspBO sscQrySchemeMatListRspBO = this.iSscSchemeModel.qrySchemeMatList(qrySchemeMatListReqBO);
        //4 返回出参
        SscQrySchemeMatListPageRspBO rspBO = SscRu.js(sscQrySchemeMatListRspBO, SscQrySchemeMatListPageRspBO.class);
        if (CollectionUtil.isNotEmpty(rspBO.getRows())) {
            rspBO.getRows().forEach(e -> {
                if (ObjectUtil.isNotEmpty(e.getCentralPurTag())) {
                    // 采集翻译
                    e.setCentralPurTagStr(SscCommConstant.YesOrNoEnum.findDescByCode(e.getCentralPurTag()).getDesc());
                }
                // 设置金额
                if (ObjectUtil.isNotNull(e.getNoTaxPrice())) {
                    if (ObjectUtil.isNotNull(e.getPurchaseNum())) {
                        e.setTotalNoTaxPrice(e.getNoTaxPrice().multiply(e.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                    }
                    if (ObjectUtil.isNotNull(e.getTaxRate())) {
                        e.setTaxPrice(e.getNoTaxPrice().multiply(new BigDecimal("1").add(e.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                        if (ObjectUtil.isNotNull(e.getPurchaseNum())) {
                            e.setTotalTaxPrice(e.getTaxPrice().multiply(e.getPurchaseNum().setScale(2, RoundingMode.HALF_UP)));
                        }
                    }
                }
            });
        }
        // 扩展字段信息
        this.setExtInfo(reqBO, rspBO);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void validationParam(SscQrySchemeMatListPageReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getEnableDraft())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPageNo())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[PageNo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPageSize())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[PageSize]不能为空");
        }
    }

    private void setExtInfo(SscQrySchemeMatListPageReqBO reqBO, SscQrySchemeMatListPageRspBO rspBO) {
        List<SscSchemeMatBO> rows = rspBO.getRows();
        if (CollectionUtil.isNotEmpty(rows)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            boolean hisFlag = ObjectUtil.isNotNull(reqBO.getSchemeHisId()) || ObjectUtil.isNotNull(reqBO.getPackHisId());
            Boolean enableDraft = reqBO.getEnableDraft();
            List<SscExtObjInfo> objInfoList = rows.stream().map(e -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                if (enableDraft) {
                    // 草稿
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT);
                } else if (hisFlag) {
                    // 历史
                    objInfo.setObjId(e.getSchemeMatHisId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_HIS_EXT);
                } else {
                    // 主表
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT);
                }
                return objInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(objInfoList);
            SscCommonDo qryExtInfo = this.iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> resultList = qryExtInfo.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(resultList)) {
                Map<Long, List<SscExtInfo>> objExtObjInfoMap = resultList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo));
                rows.forEach(e -> e.setExtFields(SscRu.jsl(objExtObjInfoMap.get((hisFlag ? e.getSchemeMatHisId() : e.getSchemeMatId())), BaseExtendFieldBo.class)));
            }
        }
    }
}
