package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeEntrustRecordQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeEntrustRecord;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：SscQrySchemeEntrustRecordListServiceImpl
 * 时间：2022/11/11
 * 说明：方案委托记录列表查询服务
 * @author hechenze
 */
@HTServiceImpl
public class SscQrySchemeEntrustRecordListServiceImpl implements SscQrySchemeEntrustRecordListService{
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Override
    public SscQrySchemeEntrustRecordListRspBO qrySchemeEntrustRecordList(SscQrySchemeEntrustRecordListReqBO sscQrySchemeEntrustRecordListReqBO) {
        SscQrySchemeEntrustRecordListRspBO rspBo = SscRu.success(SscQrySchemeEntrustRecordListRspBO.class);
        //入参必填校验
        validateArg(sscQrySchemeEntrustRecordListReqBO);
        //调用委托记录列表查询方法
        SscSchemeEntrustRecordQryBo qryBo = SscRu.js(sscQrySchemeEntrustRecordListReqBO, SscSchemeEntrustRecordQryBo.class);
        SscSchemeDo sscSchemeDo = iSscSchemeModel.qrySchemeEntrustRecordList(qryBo);
        if (sscSchemeDo == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ENTRUST_RECORD_ERROR, "委托记录列表查询为空");
        }
        List<SscSchemeEntrustRecord> list = sscSchemeDo.getSscSchemeEntrustRecord();
        List<SscQrySchemeEntrustRecordBO> recordBOList = new ArrayList<>();
        for (SscSchemeEntrustRecord sscSchemeEntrustRecord : list) {
            SscQrySchemeEntrustRecordBO detailBO = SscRu.js(sscSchemeEntrustRecord, SscQrySchemeEntrustRecordBO.class);
            if (sscSchemeEntrustRecord.getSchemeStatus()!=null){
                //schemeStatusStr字段翻译，创建枚举类做字典翻译
                detailBO.setSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance(sscSchemeEntrustRecord.getSchemeStatus()).getDesc());
            }
            recordBOList.add(detailBO);
        }
        rspBo.setRows(recordBOList);
        return rspBo;
    }

    private void validateArg(SscQrySchemeEntrustRecordListReqBO reqBO){
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscQrySchemeEntrustRecordListReqBO]不能为空");
        }
        if (reqBO.getSchemeId() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[方案ID]不能为空");
        }
    }
}
