package com.tydic.dyc.ssc.model.auditorder.impl;

import cn.hutool.core.util.ObjectUtil;

import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.repository.SscAuditOrderRepository;
import com.tydic.dyc.ssc.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class ISscAuditOrderModelImpl implements ISscAuditOrderModel {
    @Autowired
    SscAuditOrderRepository sscAuditOrderRepository;

    @Override
    public void createAuditOrder(SscAuditOrderDo sscAuditOrderDo) {
        //1 参数校验
        this.validateAuditOrder(sscAuditOrderDo);

        // 2 保存审批单数据
        this.sscAuditOrderRepository.saveAuditOrder(sscAuditOrderDo);

    }

    @Override
    public SscAuditOrderDo getAuditObj(SscAuditOrderQryBo sscAuditOrderQryBo) {
        return this.sscAuditOrderRepository.getAuditObj(sscAuditOrderQryBo);
    }

    @Override
    public void deleteAuditObj(SscAuditOrderDo param0) {
        this.sscAuditOrderRepository.deleteAuditObj(param0);
    }

    /**
     * 参数校验
     */
    private void validateAuditOrder(SscAuditOrderDo sscAuditOrderDo) {
        if (ObjectUtil.isEmpty(sscAuditOrderDo.getAuditOrderId())) {
            long sscId = IdUtil.nextId();
            sscAuditOrderDo.setAuditOrderId(sscId);
        }
        if (ObjectUtil.isEmpty(sscAuditOrderDo.getAuditOrderStatus())) {
            //设置默认的审批状态
            sscAuditOrderDo.setAuditOrderStatus(SscCommConstant.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        }
    }


}
