package com.tydic.dyc.ssc.service.procinst;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetTaskInstReqBo;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetTaskInstRspBo;
import com.tydic.dyc.ssc.service.procinst.bo.SscUocOrderTaskInstBo;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @desc:
 * @author: PingZi
 * @date: 2022/8/24 10:50
 */
@HTServiceImpl
public class SscGetTaskInstServiceImpl implements SscGetTaskInstService {

    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Override
    public SscGetTaskInstRspBo getTaskInstList(SscGetTaskInstReqBo reqBo) {
        validateParams(reqBo);
        SscTaskQryBo sscTaskQryBo = JSONObject.parseObject(JSON.toJSONString(reqBo), SscTaskQryBo.class);
        SscProcInstDo sscProcInstDo = iSscProcInstModel.getTaskList(sscTaskQryBo);
        SscGetTaskInstRspBo rspBo = SscRu.success(SscGetTaskInstRspBo.class);
        rspBo.setRows(SscRu.jsl(sscProcInstDo.getSscUocOrderTaskInst(), SscUocOrderTaskInstBo.class));
        return rspBo;
    }

    private void validateParams(SscGetTaskInstReqBo sscGetTaskInstReqBo) {
        if (ObjectUtil.isEmpty(sscGetTaskInstReqBo.getOrderId())) {
            throw new BaseBusinessException("", "入参对象属性[订单ID]不能为空");
        }
    }
}
