package com.tydic.dyc.ssc.service.procinst;


import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.procinst.bo.SscCandidatesBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskDealReqBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskDealRspBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskInfoBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:SscTaskDealServiceImpl
 * 说明:TODO
 * 时间:2022/9/2 15:30
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class SscTaskDealServiceImpl implements SscTaskDealService {
    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Autowired
    private ISscAuditOrderModel iSscAuditOrderModel;

    @Autowired
    private ISscSchemeModel sscSchemeModel;

    @Override
    public SscTaskDealRspBO dealTask(SscTaskDealReqBO reqBO) {
        SscTaskDealRspBO rspBO = new SscTaskDealRspBO();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            // 处理待办
            uocOrderTaskInst = this.dealToDo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            // 处理已办
            uocOrderTaskInst = this.dealDone(reqBO);
        }
        // 处理前加签
        if (StringUtils.isNotBlank(reqBO.getPreTaskId())) {
            uocOrderTaskInst = this.dealPreTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        // 处理回退
        if (StringUtils.isNotBlank(reqBO.getReturnTaskId())) {
            uocOrderTaskInst = this.dealReturnTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        // 处理转签
        if (reqBO.getUpdateTaskCandidate() != null && org.springframework.util.StringUtils.hasText(reqBO.getUpdateTaskCandidate().getTaskId())) {
            uocOrderTaskInst = this.dealTaskDealUpdate(reqBO.getUpdateTaskCandidate(), reqBO.getOrderId());
        }
        this.dealRsp(rspBO, uocOrderTaskInst);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc("任务处理成功");
        return rspBO;
    }

    /**
     * 处理出参
     */
    private void dealRsp(SscTaskDealRspBO rspBO, UocOrderTaskInst uocOrderTaskInst) {
        if (uocOrderTaskInst != null) {
            String pickerConfigNo = uocOrderTaskInst.getObjType().toString();
            rspBO.setMainObjId(uocOrderTaskInst.getObjId() + "");
            if (uocOrderTaskInst.getObjType().equals(SscCommConstant.ObjType.APPROVE)) {
                SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
                sscAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
                SscAuditOrderDo sscAuditOrderDo = iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
                pickerConfigNo = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
                rspBO.setMainObjId(sscAuditOrderDo.getUocApprovalObj().get(0).getObjId());
            }
            rspBO.setPickerConfigNo(pickerConfigNo + "_" + uocOrderTaskInst.getObjType());
            rspBO.setObjId(uocOrderTaskInst.getObjId());
            rspBO.setOrderId(uocOrderTaskInst.getOrderId());
        }

    }

    /**
     * 处理回退
     */
    private UocOrderTaskInst dealReturnTask(String taskId, Long orderId) {
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        //2 删除任务信息
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setTaskInstId(taskId);
        sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        this.deleteTask(sscTaskQryBo);
        return uocOrderTaskInst;
    }

    /**
     * 处理前加签
     */
    private UocOrderTaskInst dealPreTask(String taskId, Long orderId) {
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        //2 删除任务信息
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setTaskInstId(taskId);
        sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        this.deleteTask(sscTaskQryBo);
        return uocOrderTaskInst;
    }

    /**
     * 更新任务处理人
     */
    private UocOrderTaskInst dealTaskDealUpdate(SscTaskInfoBO completeTaskBo, Long orderId) {
        //1 校验任务是否是待办
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), orderId);
        // 2 修改任务处理人
        List<UocOrderTaskDeal> sscUocOrderTaskDeal = new ArrayList<>();
        UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
        uocOrderTaskDeal.setOrderId(orderId);
        uocOrderTaskDeal.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        uocOrderTaskDeal.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskDeal.setObjType(uocOrderTaskInst.getObjType());
        SscCandidatesBO uecCandidatesBO = completeTaskBo.getCandidates().get(0);
        uocOrderTaskDeal.setDealId(uecCandidatesBO.getCandidateId());
        uocOrderTaskDeal.setDealName(uecCandidatesBO.getCandidateName());
        sscUocOrderTaskDeal.add(uocOrderTaskDeal);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        sscProcInstDo.setSscUocOrderTaskDeal(sscUocOrderTaskDeal);
        iSscProcInstModel.updateTaskDeal(sscProcInstDo);

        // 3 修改任务信息
        SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
        List<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst1 = new UocOrderTaskInst();
        uocOrderTaskInst1.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskInst1.setOrderId(uocOrderTaskInst.getOrderId());
        uocOrderTaskInst1.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        String remarkOld = uocOrderTaskInst.getRemark();
        String objBusiType = remarkOld.split("_")[1];
        String remarkNew = uecCandidatesBO.getCandidateId() + "_" + objBusiType;
        uocOrderTaskInst1.setRemark(remarkNew);
        sscUocOrderTaskInst.add(uocOrderTaskInst1);
        sscProcInstDo1.setSscUocOrderTaskInst(sscUocOrderTaskInst);
        iSscProcInstModel.updateTask(sscProcInstDo1);
        return uocOrderTaskInst;
    }

    /**
     * 校验任务是否是待办
     */
    private UocOrderTaskInst checkTaskIsToDo(String taskId, Long orderId) {
        //判断当前状态，是否为未办理
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setTaskInstId(taskId);
        SscProcInstDo sscProcInstDo = iSscProcInstModel.getTaskList(sscTaskQryBo);
        //不存在，报错
        if (sscProcInstDo == null || CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "任务实例id(" + taskId + ")不存在");
        }
        //已办，报错
        if (SscCommConstant.PROC_TASK_FINISHED.FINISHED.equals(sscProcInstDo.getSscUocOrderTaskInst().get(0).getFinishTag())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "任务实例id(" + taskId + ")已完结");
        }

        return sscProcInstDo.getSscUocOrderTaskInst().get(0);
    }

    /**
     * 更新任务为已办
     */
    private void updateTaskDone(SscTaskInfoBO completeTaskBo, SscTaskDealReqBO reqBO) {
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        List<UocOrderTaskInst> sscUocOrderTaskInsts = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getUsername());
        uocOrderTaskInst.setDealName(reqBO.getName());
        uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
        uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
        uocOrderTaskInst.setObjId(completeTaskBo.getBusiObjId());
        uocOrderTaskInst.setObjType(completeTaskBo.getBusiObjType());

        // 审批任务设置
        if (uocOrderTaskInst.getObjType().equals(SscCommConstant.ObjType.APPROVE)) {
            SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
            sscAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
            SscAuditOrderDo sscAuditOrderDo = iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
            String objBusiType = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            String remark = reqBO.getUserId() + "_" + objBusiType + "_" + completeTaskBo.getDealResult();
            uocOrderTaskInst.setRemark(remark);
        }

        sscUocOrderTaskInsts.add(uocOrderTaskInst);
        sscProcInstDo.setSscUocOrderTaskInst(sscUocOrderTaskInsts);
        iSscProcInstModel.updateTask(sscProcInstDo);
    }

    /**
     * 处理已办
     */
    private UocOrderTaskInst dealDone(SscTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = null;
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            for (SscTaskInfoBO completeTaskBo : reqBO.getCompleteTaskInfos()) {
                //1 校验任务是否是待办
                uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), reqBO.getOrderId());
                // 取数据库的业务类型和业务单据ID
                completeTaskBo.setBusiObjType(uocOrderTaskInst.getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInst.getObjId());

                //2 设置为已办
                this.updateTaskDone(completeTaskBo, reqBO);

                //3 如果审批任务所在的环节编码已完成，则把环节下面未完成的任务移到日志表（实现会签功能）
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish()) {
                    SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
                    sscTaskQryBo.setOrderId(reqBO.getOrderId());
                    sscTaskQryBo.setProcState(uocOrderTaskInst.getProcState());
                    sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
                    this.deleteTask(sscTaskQryBo);
                }

                // 如果审批通过，更新流程实例完结标志和完成时间
                if (Boolean.TRUE.equals(completeTaskBo.getFinish())) {
                    this.updateProInst(completeTaskBo, reqBO.getOrderId());
                }
            }
        }
        return uocOrderTaskInst;
    }

    /**
     * 任务删除
     */
    private void deleteTask(SscTaskQryBo sscTaskQryBo) {
        SscProcInstDo sscProcInstDo = iSscProcInstModel.getTaskList(sscTaskQryBo);
        if (!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            List<String> taskInstIds = new ArrayList<>();
            sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                taskInstIds.add(uocOrderTaskInst.getTaskInstId());
            });
            SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
            List<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setObjId(sscTaskQryBo.getObjId());
            uocOrderTaskInst.setOrderId(sscTaskQryBo.getOrderId());
            uocOrderTaskInst.setTaskInstIds(taskInstIds);
            sscUocOrderTaskInst.add(uocOrderTaskInst);
            sscProcInstDo1.setSscUocOrderTaskInst(sscUocOrderTaskInst);
            this.iSscProcInstModel.deleteTask(sscProcInstDo1);
        }
    }

    /**
     * 处理流程实例信息
     */
    private void dealProInst(SscTaskInfoBO sscTaskInfoBO, Long orderId) {
        // 查询是否已存在流程实例
        SscProcInstDo sscProcInstDoReq = new SscProcInstDo();
        sscProcInstDoReq.setProcInstId(sscTaskInfoBO.getProcInstId());
        SscProcInstDo sscProcInstDoRsp = iSscProcInstModel.getProcInst(sscProcInstDoReq);
        // 不存在则新增
        if (sscProcInstDoRsp == null || StringUtils.isBlank(sscProcInstDoRsp.getProcInstId())) {
            SscProcInstDo sscProcInstDo = new SscProcInstDo();
            sscProcInstDo.setProcInstId(sscTaskInfoBO.getProcInstId());
            sscProcInstDo.setObjId(sscTaskInfoBO.getBusiObjId());
            sscProcInstDo.setObjType(sscTaskInfoBO.getBusiObjType());
            sscProcInstDo.setOrderId(orderId);
            sscProcInstDo.setProcDefId(sscTaskInfoBO.getProcDefId());
            iSscProcInstModel.saveProcInst(sscProcInstDo);
        }
    }

    /**
     * 任务数据转换
     */
    private UocOrderTaskInst dealTask(SscTaskInfoBO nextTaskInfo, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(orderId);
        uocOrderTaskInst.setTaskInstId(nextTaskInfo.getTaskId());
        uocOrderTaskInst.setObjId(nextTaskInfo.getBusiObjId());
        uocOrderTaskInst.setObjType(nextTaskInfo.getBusiObjType());
        uocOrderTaskInst.setProcState(nextTaskInfo.getStepId());
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInst.setFormUrl(nextTaskInfo.getFormUrl());
        uocOrderTaskInst.setProcDefId(nextTaskInfo.getProcDefId());
        uocOrderTaskInst.setProcInstId(nextTaskInfo.getProcInstId());
        uocOrderTaskInst.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        uocOrderTaskInst.setDealResult(SscCommConstant.TASK_DEAL_RESULT.APPROVING);
        if (uocOrderTaskInst.getTaskSignTag() == null) {
            // 默认为环节任务
            uocOrderTaskInst.setTaskSignTag(SscCommConstant.TASK_SING_TAG.TACHE_TASK);
        }
        // 审批任务设置
        if (nextTaskInfo.getBusiObjType().equals(SscCommConstant.ObjType.APPROVE)) {
            SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
            sscAuditOrderQryBo.setAuditOrderId(nextTaskInfo.getBusiObjId());
            SscAuditOrderDo sscAuditOrderDo = iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
            String objBusiType = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            if (!CollectionUtils.isEmpty(nextTaskInfo.getCandidates())) {
                String remark = nextTaskInfo.getCandidates().get(0).getCandidateId();
                if (objBusiType != null) {
                    remark = remark + "_" + objBusiType;
                }
                uocOrderTaskInst.setRemark(remark);
            }
        }

        return uocOrderTaskInst;
    }

    private List<UocOrderTaskDeal> dealTaskDeal(SscTaskInfoBO nextTaskInfo, Long orderId) {
        List<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<>();
        if (!CollectionUtils.isEmpty(nextTaskInfo.getCandidates())) {
            nextTaskInfo.getCandidates().forEach(sscCandidatesBO -> {
                UocOrderTaskDeal deal = new UocOrderTaskDeal();
                deal.setTaskInstId(nextTaskInfo.getTaskId());
                deal.setOrderId(orderId);
                deal.setObjId(nextTaskInfo.getBusiObjId());
                deal.setObjType(nextTaskInfo.getBusiObjType());
                deal.setDealId(sscCandidatesBO.getCandidateId());
                deal.setDealName(sscCandidatesBO.getCandidateName());
                //deal.setDealType(sscCandidatesBO.getCandidateType());
                deal.setDealClass(SscCommConstant.TASK_DEAL_CLASS.CANDIDATE);
                uocOrderTaskDeals.add(deal);
            });
        }
        return uocOrderTaskDeals;
    }

    /**
     * 处理待办
     */
    private UocOrderTaskInst dealToDo(SscTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            List<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<>();
            List<UocOrderTaskDeal> sscUocOrderTaskDeal = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(sscTaskInfoBO -> {
                // 如果不存在相应的流程实例，则新增一条流程实例
                dealProInst(sscTaskInfoBO, reqBO.getOrderId());
                // 任务转换
                sscUocOrderTaskInst.add(dealTask(sscTaskInfoBO, reqBO.getOrderId()));
                // 处理人转换
                sscUocOrderTaskDeal.addAll(dealTaskDeal(sscTaskInfoBO, reqBO.getOrderId()));
                // 修改状态
                updateStatus(sscTaskInfoBO, reqBO.getOrderId());
            });
            // 保存任务相关数据
            SscProcInstDo sscProcInstDo = new SscProcInstDo();
            sscProcInstDo.setSscUocOrderTaskInst(sscUocOrderTaskInst);
            sscProcInstDo.setSscUocOrderTaskDeal(sscUocOrderTaskDeal);
            iSscProcInstModel.saveTask(sscProcInstDo);
            uocOrderTaskInst = sscUocOrderTaskInst.get(0);
        }
        return uocOrderTaskInst;
    }

    private void updateStatus(SscTaskInfoBO sscTaskInfoBO, Long orderId) {
        if (SscCommConstant.ObjType.ORDER.equals(sscTaskInfoBO.getBusiObjType())) {
            SscSchemeDo sscSchemeDo = new SscSchemeDo();
            sscSchemeDo.setSchemeId(orderId);
            // 审批状态为审批通过, 方案状态为委托中
            if ("SSCS0002".equals(sscTaskInfoBO.getStepId())) {
                sscSchemeDo.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.APPROVE.getCode());
                sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.FORWARDING.getCode());
                if (StrUtil.isNotEmpty(sscSchemeDo.getSchemeStatus()) || StrUtil.isNotEmpty(sscSchemeDo.getSchemeAuditStatus())) {
                    this.sscSchemeModel.updateSchemeMain(sscSchemeDo);
                }
            }
        }
    }

    private void updateProInst(SscTaskInfoBO completeTaskBo, Long orderId) {
        // 根据任务实例id查询流程实例id
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setTaskInstId(completeTaskBo.getTaskId());
        sscTaskQryBo.setOrderId(orderId);
        SscProcInstDo task = this.iSscProcInstModel.getTaskList(sscTaskQryBo);
        // 更新流程实例
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        sscProcInstDo.setProcInstId(task.getSscUocOrderTaskInst().get(0).getProcInstId());
        sscProcInstDo.setFinishTag(SscCommConstant.YesOrNoEnum.YES.getCode());
        sscProcInstDo.setFinishTime(new Date());
        this.iSscProcInstModel.updateProcInst(sscProcInstDo);
    }
}
