package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemePackQryBo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: SscQrySchemePackListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-14
 */
@HTServiceImpl
public class SscQrySchemePackListServiceImpl implements SscQrySchemePackListService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemePackListRspBO qrySchemePackList(SscQrySchemePackListReqBO sscQrySchemePackListReqBO) {
        if (ObjectUtil.isNull(sscQrySchemePackListReqBO.getPageSize()) && ObjectUtil.isNull(sscQrySchemePackListReqBO.getPageNo())) {
            // 默认查询全部
            sscQrySchemePackListReqBO.setPageNo(-1);
            sscQrySchemePackListReqBO.setPageSize(-1);
        }
        SscQrySchemePackListRspBO rspBO = iSscSchemeModel.qrySchemePackList(SscRu.js(sscQrySchemePackListReqBO, SscSchemePackQryBo.class));
        // 扩展字段信息
        this.setExtInfo(sscQrySchemePackListReqBO, rspBO);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void setExtInfo(SscQrySchemePackListReqBO reqBO, SscQrySchemePackListRspBO rspBO) {
        List<SscSchemePackBO> packList = rspBO.getSscSchemePackList();
        if (CollectionUtil.isNotEmpty(packList)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            boolean hisFlag = ObjectUtil.isNotNull(reqBO.getSchemeHisId()) || ObjectUtil.isNotNull(reqBO.getPackHisId());
            List<SscExtObjInfo> extObjInfos = packList.stream().map(e -> {
                SscExtObjInfo packExtObjInfo = new SscExtObjInfo();
                packExtObjInfo.setObjId(hisFlag ? e.getPackHisId() : e.getPackId());
                packExtObjInfo.setObjType(hisFlag ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
                return packExtObjInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(extObjInfos);
            SscCommonDo qryExtInfo = iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> extInfoResultList = qryExtInfo.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(extInfoResultList)) {
                Map<Long, List<SscExtInfo>> objIdExtInfoMap = extInfoResultList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
                packList.forEach(e -> e.setExtFields(SscRu.jsl(objIdExtInfoMap.get(hisFlag ? e.getPackHisId() : e.getPackId()), BaseExtendFieldBo.class)));
            }
        }
    }
}
