package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListBatchRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: SscQrySchemeChangeListBatchServiceImpl
 * @Author: the_xhl
 * @Date: 2023-04-07
 */
@HTServiceImpl
public class SscQrySchemeChangeListBatchServiceImpl implements SscQrySchemeChangeListBatchService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscQrySchemeChangeListBatchRspBO qrySchemeChangeListBatch(SscQrySchemeChangeListBatchReqBO sscQrySchemeChangeListBatchReqBO) {
        check(sscQrySchemeChangeListBatchReqBO);
        SscQrySchemeChangeListBatchRspBO rspBO = SscRu.success(SscQrySchemeChangeListBatchRspBO.class);
        SscQrySchemeChangeListBatchRspBO changeListBatch = this.iSscSchemeModel.qrySchemeChangeListBatch(sscQrySchemeChangeListBatchReqBO);
        rspBO.setSscSchemeChange(SscRu.jsl(changeListBatch.getSscSchemeChange(), SscSchemeChangeBO.class));
        return rspBO;
    }

    private void check(SscQrySchemeChangeListBatchReqBO reqBO) {
        if (CollectionUtil.isEmpty(reqBO.getSchemeIds())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeIds]属性不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getOperType())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[operType]属性不能为空");
        }
    }
}
