/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeEntrustRecordQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeEntrustRecord;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeEntrustRecordListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeEntrustRecordBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeEntrustRecordListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeEntrustRecordListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeEntrustRecordListService"})
public class SscQrySchemeEntrustRecordListServiceImpl
implements SscQrySchemeEntrustRecordListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeEntrustRecordList"})
    public SscQrySchemeEntrustRecordListRspBO qrySchemeEntrustRecordList(@RequestBody SscQrySchemeEntrustRecordListReqBO sscQrySchemeEntrustRecordListReqBO) {
        SscQrySchemeEntrustRecordListRspBO rspBo = SscRu.success(SscQrySchemeEntrustRecordListRspBO.class);
        this.validateArg(sscQrySchemeEntrustRecordListReqBO);
        SscSchemeEntrustRecordQryBo qryBo = SscRu.js(sscQrySchemeEntrustRecordListReqBO, SscSchemeEntrustRecordQryBo.class);
        SscSchemeDo sscSchemeDo = this.iSscSchemeModel.qrySchemeEntrustRecordList(qryBo);
        if (sscSchemeDo == null) {
            throw new BaseBusinessException("291003", "\u59d4\u6258\u8bb0\u5f55\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a");
        }
        List<SscSchemeEntrustRecord> list = sscSchemeDo.getSscSchemeEntrustRecord();
        ArrayList<SscQrySchemeEntrustRecordBO> recordBOList = new ArrayList<SscQrySchemeEntrustRecordBO>();
        for (SscSchemeEntrustRecord sscSchemeEntrustRecord : list) {
            SscQrySchemeEntrustRecordBO detailBO = SscRu.js(sscSchemeEntrustRecord, SscQrySchemeEntrustRecordBO.class);
            if (sscSchemeEntrustRecord.getSchemeStatus() != null) {
                detailBO.setSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance((String)sscSchemeEntrustRecord.getSchemeStatus()).getDesc());
            }
            recordBOList.add(detailBO);
        }
        rspBo.setRows(recordBOList);
        return rspBo;
    }

    private void validateArg(SscQrySchemeEntrustRecordListReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscQrySchemeEntrustRecordListReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[\u65b9\u6848ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

