package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 类名：SscAddSchemeServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/10
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscAddSchemeServiceImpl implements SscAddSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscAddSchemeRspBO addScheme(SscAddSchemeReqBO sscAddSchemeReqBO0) {
        SscAddSchemeRspBO rspBO = SscRu.success(SscAddSchemeRspBO.class);
        //	调用方案主体新增
        SscSchemeDo sscSchemeDo = SscRu.js(sscAddSchemeReqBO0, SscSchemeDo.class);
        sscSchemeDo.setOperTime(new Date());
        iSscSchemeModel.addSchemeMain(sscSchemeDo);
        //调用方案草稿到主表复制方法
        SscSchemeDo copyDo = new SscSchemeDo();
        copyDo.setSchemeId(sscAddSchemeReqBO0.getSchemeId());
        iSscSchemeModel.copyScheme(copyDo);
        // 新增扩展字段
        this.addExtInfo(sscAddSchemeReqBO0);
        return rspBO;
    }

    public void addExtInfo(SscAddSchemeReqBO reqBO) {
        List<BaseExtendFieldBo> extFieldList = reqBO.getExtFields();
        List<SscExtObjInfo> extObjInfoList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(extFieldList)) {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setOrderId(reqBO.getSchemeId());
            objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            extObjInfoList.add(objInfo);
        }

        List<SscSchemePackBO> sscSchemePack = reqBO.getSscSchemePack();
        if (CollectionUtil.isNotEmpty(sscSchemePack)) {
            List<SscExtObjInfo> objInfoList = sscSchemePack.stream()
                    .filter(e -> CollectionUtil.isNotEmpty(e.getExtFields()))
                    .map(e -> {
                        List<BaseExtendFieldBo> extFields = e.getExtFields();
                        SscExtObjInfo objInfo = new SscExtObjInfo();
                        objInfo.setObjId(e.getPackId());
                        objInfo.setOrderId(reqBO.getSchemeId());
                        objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
                        objInfo.setExtInfo(SscRu.jsl(extFields, SscExtInfo.class));
                        return objInfo;
                    }).collect(Collectors.toList());
            extObjInfoList.addAll(objInfoList);
        }
        SscCommonDo sscCommonDo = new SscCommonDo();
        sscCommonDo.setExtObjInfos(extObjInfoList);
        iSscCommonModel.addExtInfo(sscCommonDo);
    }
}
