package com.tydic.dyc.ssc.service.scheme;



import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.service.scheme.bo.SscCreateCodeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscCreateCodeRspBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * SscCreateCodeServiceImpl
 * 2022/11/10
 * Project:pro
 * Creator:千雪
 * Create Time:2022/11/10-16-04
 * IDE: IntelliJ IDEA
 */
@Slf4j
@HTServiceImpl
public class SscCreateCodeServiceImpl implements SscCreateCodeService {

    @Autowired
    private CfcEncodedSerialGetService cfcRedisSerialService;

    @Override
    public SscCreateCodeRspBO createCode(SscCreateCodeReqBO sscCreateCodeReqBO) {
        SscCreateCodeRspBO sscCreateCodeRspBO = SscRu.success(SscCreateCodeRspBO.class);
        //参数校验
        this.validateParam(sscCreateCodeReqBO);
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcEncodedSerialGetServiceReqBO.setEncodedRuleCode(sscCreateCodeReqBO.getCode());
        cfcEncodedSerialGetServiceReqBO.setCenter(SscCommConstant.SSC);
        cfcEncodedSerialGetServiceReqBO.setOrgType(SscCommConstant.CODE_ORG_TYPE);
        if (StrUtil.isNotEmpty(sscCreateCodeReqBO.getUpperCode())) {
            // 装入上级编码code
            List<String> replaceValue = new ArrayList<>();
            replaceValue.add(sscCreateCodeReqBO.getUpperCode());
            cfcEncodedSerialGetServiceReqBO.setReplaceValue(replaceValue);
        }
        CfcEncodedSerialServiceRspBO cfcEncodedSerialGetServiceRspBO = cfcRedisSerialService.getSerial(cfcEncodedSerialGetServiceReqBO);
        List<String> serialNoList = cfcEncodedSerialGetServiceRspBO.getSerialNoList();
        String codeNo=serialNoList.get(0);
        long codeId = IdUtil.nextId();
        sscCreateCodeRspBO.setCodeId(codeId);
        sscCreateCodeRspBO.setCodeNo(codeNo);
        return sscCreateCodeRspBO;
    }

    /**
     * 参数校验
     * @param sscCreateCodeReqBO
     */
    private void validateParam(SscCreateCodeReqBO sscCreateCodeReqBO) {
        if (null == sscCreateCodeReqBO) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "SSCS0001-编号生成服务入参对象不能为空！");
        }
        if (null == sscCreateCodeReqBO.getCode()) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "SSCS0001-编号生成服务入参【code】不能为空！");
        }
    }
}
