package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtObjInfoBo;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：SscQrySchemeDetailServiceImpl
 * 时间：2022/11/10
 * 说明：方案详情查询服务
 * @author hechenze
 */
@HTServiceImpl
public class SscQrySchemeDetailServiceImpl implements SscQrySchemeDetailService{
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemeDetailRspBO qrySchemeDetail(SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO0) {
        SscQrySchemeDetailRspBO rspBo = SscRu.success(SscQrySchemeDetailRspBO.class);
        //入参非空校验
        validateArg(sscQrySchemeDetailReqBO0);
        //调用方案详情查询方法
        SscSchemeQryBo qryBo = new SscSchemeQryBo();
        qryBo.setSchemeId(sscQrySchemeDetailReqBO0.getSchemeId());
        qryBo.setEnableDraft(sscQrySchemeDetailReqBO0.getEnableDraft());
        qryBo.setSchemeHisId(sscQrySchemeDetailReqBO0.getSchemeHisId());
        SscSchemeDo sscSchemeDo = iSscSchemeModel.qrySchemeDetail(qryBo);
        if (sscSchemeDo == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_QUERY_SCHEME_ERROR, "方案详细查询为空");
        }
        SscQrySchemeDetailBO detailBO = SscRu.js(sscSchemeDo, SscQrySchemeDetailBO.class);
        //转译
        if (sscSchemeDo.getSchemeClass()!=null) {
            detailBO.setSchemeClassStr(Objects.requireNonNull(SscCommConstant.SchemeClass.getInstance(sscSchemeDo.getSchemeClass())).getDesc());
        }
        if (sscSchemeDo.getSchemeStatus()!= null){
            detailBO.setSchemeStatusStr(Objects.requireNonNull(SscCommConstant.SchemeStatus.getInstance(sscSchemeDo.getSchemeStatus())).getDesc());
        }
        if (sscSchemeDo.getPurchaseType()!= null){
            detailBO.setPurchaseTypeStr(Objects.requireNonNull(SscCommConstant.SchemePurchaseType.getInstance(sscSchemeDo.getPurchaseType())).getDesc());
        }
        if (sscSchemeDo.getCheckType()!= null){
            detailBO.setCheckTypeStr(Objects.requireNonNull(SscCommConstant.SchemeCheckType.getInstance(sscSchemeDo.getCheckType())).getDesc());
        }
        if (sscSchemeDo.getOfferType()!= null){
            detailBO.setOfferTypeStr(Objects.requireNonNull(SscCommConstant.SchemeOfferType.getInstance(sscSchemeDo.getOfferType())).getDesc());
        }
        if (sscSchemeDo.getBiddingFlag()!= null){
            detailBO.setBiddingFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBiddingFlag.getInstance(sscSchemeDo.getBiddingFlag())).getDesc());
        }
        if (sscSchemeDo.getSupplierNameDisplayFlag()!= null){
            detailBO.setSupplierNameDisplayFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSupplierNameDisplayFlag.getInstance(sscSchemeDo.getSupplierNameDisplayFlag())).getDesc());
        }
        if (sscSchemeDo.getOrganizationForm()!= null){
            detailBO.setOrganizationFormStr(Objects.requireNonNull(SscCommConstant.SchemeOrganizationForm.getInstance(Integer.parseInt(sscSchemeDo.getOrganizationForm()))).getDesc());
        }
        if (sscSchemeDo.getSubpackageFlag()!= null){
            detailBO.setSubpackageFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSubpackageFlag.getInstance(sscSchemeDo.getSubpackageFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderChargeFlag()!= null){
            detailBO.setTenderChargeFlagStr(Objects.requireNonNull(SscCommConstant.SchemeTenderChargeFlag.getInstance(sscSchemeDo.getTenderChargeFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderSaleForm()!= null){
            detailBO.setTenderSaleFormStr(Objects.requireNonNull(SscCommConstant.SchemeTenderSaleForm.getInstance(sscSchemeDo.getTenderSaleForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginFlag()!= null){
            detailBO.setBidMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginFlag.getInstance(sscSchemeDo.getBidMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getBidMarginForm()!= null){
            detailBO.setBidMarginFormStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginForm.getInstance(sscSchemeDo.getBidMarginForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginPayForm()!= null){
            String bidMarginPayFormStr = Arrays.stream(sscSchemeDo.getBidMarginPayForm().split(",")).map(e -> SscCommConstant.SchemeBidMarginPayForm.getInstance(Integer.valueOf(e)).getDesc()).collect(Collectors.joining(","));
            detailBO.setBidMarginPayFormStr(bidMarginPayFormStr);
        }
        if (sscSchemeDo.getPrefMarginFlag()!= null){
            detailBO.setPrefMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemePrefMarginFlag.getInstance(sscSchemeDo.getPrefMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getImportFlag()!= null){
            detailBO.setImportFlagStr(Objects.requireNonNull(SscCommConstant.SchemeImportFlag.getInstance(sscSchemeDo.getImportFlag())).getDesc());
        }
        if (sscSchemeDo.getEmergencyFlag()!= null){
            detailBO.setEmergencyFlagStr(Objects.requireNonNull(SscCommConstant.SchemeEmergencyFlag.getInstance(sscSchemeDo.getEmergencyFlag())).getDesc());
        }
        if (sscSchemeDo.getContractSignFlag()!= null){
            detailBO.setContractSignFlagStr(Objects.requireNonNull(SscCommConstant.SchemeContractSignFlag.getInstance(sscSchemeDo.getContractSignFlag())).getDesc());
        }
        if (sscSchemeDo.getSourcingStatus()!=null){
            detailBO.setSourcingStatusStr(SscCommConstant.SchemeSourcingStatus.getInstance(Integer.parseInt(sscSchemeDo.getSourcingStatus())).getDesc());
        }
        Optional.ofNullable(sscSchemeDo.getSchemeType()).ifPresent(e -> {
            SscCommConstant.SchemeTypeEnum schemeTypeEnum = SscCommConstant.SchemeTypeEnum.findDescByCode(e);
            detailBO.setSchemeTypeStr(ObjectUtil.isNull(schemeTypeEnum) ? null : schemeTypeEnum.getDesc());
        });
        Optional.ofNullable(sscSchemeDo.getSourcingWay()).ifPresent(e -> detailBO.setSourcingWayStr(SscCommConstant.SourcingWayEnum.findDescByCode(e).getDesc()));
        Optional.ofNullable(sscSchemeDo.getMultipleAwardsForOneBid()).ifPresent(e -> detailBO.setMultipleAwardsForOneBidStr(SscCommConstant.YesOrNoEnum.findDescByCode(e).getDesc()));
        // 设置扩展字段
        this.setExtInfo(sscQrySchemeDetailReqBO0, detailBO);
        rspBo.setSscQrySchemeDetailBO(detailBO);
        return rspBo;
    }

    private void validateArg(SscQrySchemeDetailReqBO reqBO){
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscQrySchemeDetailReqBO]不能为空");
        }
        if (reqBO.getSchemeId() == null && reqBO.getSchemeHisId() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeId和schemeHisId]不能同时为空");
        }
        if (reqBO.getEnableDraft() == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
    }

    private void setExtInfo(SscQrySchemeDetailReqBO reqBO, SscQrySchemeDetailBO detailBO) {
        SscExtInfoQryReqBO qryReqBO = new SscExtInfoQryReqBO();
        List<SscExtObjInfoBo> extObjInfos = new ArrayList<>();
        // 标段扩展
        List<SscSchemePackBO> sscSchemePackList = detailBO.getSscSchemePack();
        // 方案扩展
        SscExtObjInfoBo schemeObjInfoBo = new SscExtObjInfoBo();
        schemeObjInfoBo.setOrderId(detailBO.getSchemeId());
        if (ObjectUtil.isNotNull(reqBO.getSchemeHisId())) {
            // 查询方案历史扩展
            schemeObjInfoBo.setObjId(reqBO.getSchemeHisId());
            schemeObjInfoBo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_HIS_EXT);
            // 查询标段历史扩展
            if (CollectionUtil.isNotEmpty(sscSchemePackList)) {
                sscSchemePackList.forEach(e -> {
                    SscExtObjInfoBo packObjInfoBo = new SscExtObjInfoBo();
                    packObjInfoBo.setObjId(e.getPackHisId());
                    packObjInfoBo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_HIS_EXT);
                    extObjInfos.add(packObjInfoBo);
                });
            }
        } else {
            // 查询方案扩展
            schemeObjInfoBo.setObjId(reqBO.getSchemeId());
            schemeObjInfoBo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
            // 查询标段扩展
            if (CollectionUtil.isNotEmpty(sscSchemePackList)) {
                sscSchemePackList.forEach(e -> {
                    SscExtObjInfoBo packObjInfoBo = new SscExtObjInfoBo();
                    packObjInfoBo.setObjId(e.getPackId());
                    packObjInfoBo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
                    extObjInfos.add(packObjInfoBo);
                });
            }
        }
        extObjInfos.add(schemeObjInfoBo);
        qryReqBO.setExtObjInfos(extObjInfos);
        // 扩展字段信息
        SscCommonDo sscCommonDo = this.iSscCommonModel.qryExtInfo(SscRu.js(qryReqBO, SscCommonDo.class));
        List<SscExtObjInfo> infoBoList = sscCommonDo.getExtObjInfos();
        if (CollectionUtil.isNotEmpty(infoBoList)) {
            // key: 业务对象id  value: 扩展字段集合
            Map<Long, List<SscExtInfo>> objIdExtInfoMap = infoBoList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
            if (ObjectUtil.isNotNull(reqBO.getSchemeHisId())) {
                detailBO.setExtFields(SscRu.jsl(objIdExtInfoMap.get(reqBO.getSchemeHisId()), BaseExtendFieldBo.class));
                if (CollectionUtil.isNotEmpty(sscSchemePackList)) {
                    sscSchemePackList.forEach(e -> e.setExtFields(SscRu.jsl(objIdExtInfoMap.get(e.getPackHisId()), BaseExtendFieldBo.class)));
                }
            } else {
                detailBO.setExtFields(SscRu.jsl(objIdExtInfoMap.get(reqBO.getSchemeId()), BaseExtendFieldBo.class));
                if (CollectionUtil.isNotEmpty(sscSchemePackList)) {
                    sscSchemePackList.forEach(e -> e.setExtFields(SscRu.jsl(objIdExtInfoMap.get(e.getPackId()), BaseExtendFieldBo.class)));
                }
            }
        }



    }
}
