package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePlantBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePlantListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePlantListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 类名：SscQrySchemePlantListServiceImpl
 * 说明：描述一下类的作用
 * 时间：2022/11/10
 * 作者：pengyuqi
 */
@HTServiceImpl
public class SscQrySchemePlantListServiceImpl implements SscQrySchemePlantListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Override
    public SscQrySchemePlantListRspBO qrySchemePlanList(SscQrySchemePlantListReqBO sscQrySchemePlantListReqBO0) {
        validDate(sscQrySchemePlantListReqBO0);
        SscSchemeDo sscSchemeDo =
                iSscSchemeModel.qrySchemePlanList(SscRu.js(sscQrySchemePlantListReqBO0, SscSchemeQryBo.class));
        SscQrySchemePlantListRspBO sscQrySchemePlantListRspBO = new SscQrySchemePlantListRspBO();
        if (!CollectionUtils.isEmpty(sscSchemeDo.getSscSchemeMat())) {
            sscQrySchemePlantListRspBO.setRows(SscRu.jsl(sscSchemeDo.getSscSchemeMat(), SscQrySchemePlantBO.class));
        }
        return sscQrySchemePlantListRspBO;
    }
    private void validDate(SscQrySchemePlantListReqBO reqBo) {
        if (reqBo.getSchemeId() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案Id为空");
        }
    }
}
