package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeVersion;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeVersionBo;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: SscQrySchemeVersionListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-01-13
 */
@HTServiceImpl
public class SscQrySchemeVersionListServiceImpl implements SscQrySchemeVersionListService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscQrySchemeVersionListRspBO qrySchemeVersionList(SscQrySchemeVersionListReqBO sscQrySchemeVersionListReqBO) {
        check(sscQrySchemeVersionListReqBO);
        // 没传分页参数默认查询全部
        if (ObjectUtil.isNull(sscQrySchemeVersionListReqBO.getPageNo()) && ObjectUtil.isNull(sscQrySchemeVersionListReqBO.getPageSize())) {
            sscQrySchemeVersionListReqBO.setPageSize(-1);
            sscQrySchemeVersionListReqBO.setPageNo(-1);
        }
        SscQrySchemeVersionListRspBO schemeVersion = iSscSchemeModel.qrySchemeVersionList(JUtil.js(sscQrySchemeVersionListReqBO, SscSchemeQryBo.class));
        List<SscSchemeVersionBo> versionList = schemeVersion.getSscSchemeVersion();
        if (CollectionUtil.isNotEmpty(versionList)) {
            versionList.forEach(e -> {
                SscSchemeVersionBo bo = JUtil.js(e, SscSchemeVersionBo.class);
                if (ObjectUtil.isNotNull(bo.getSchemeClass())) {
                    bo.setSchemeClassStr(SscCommConstant.SchemeClass.getInstance(bo.getSchemeClass()).getDesc());
                }
                if (StrUtil.isNotEmpty(bo.getOrganizationForm())) {
                    bo.setOrganizationFormStr(SscCommConstant.SchemeOrganizationForm.getInstance(Integer.valueOf(bo.getOrganizationForm())).getDesc());
                }
                if (ObjectUtil.isNotEmpty(bo.getPurchaseType())) {
                    bo.setPurchaseTypeStr(SscCommConstant.SchemePurchaseType.getInstance(bo.getPurchaseType()).getDesc());
                }
            });
        }
        return SscRu.js(schemeVersion, SscQrySchemeVersionListRspBO.class);
    }

    private void check(SscQrySchemeVersionListReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }
}
