/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.procinst;

import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.procinst.SscTaskDealService;
import com.tydic.dyc.ssc.service.procinst.bo.SscCandidatesBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskDealReqBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskDealRspBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscTaskInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.procinst.SscTaskDealService"})
public class SscTaskDealServiceImpl
implements SscTaskDealService {
    private static final Logger log = LoggerFactory.getLogger(SscTaskDealServiceImpl.class);
    @Autowired
    private ISscProcInstModel iSscProcInstModel;
    @Autowired
    private ISscAuditOrderModel iSscAuditOrderModel;
    @Autowired
    private ISscSchemeModel sscSchemeModel;

    @PostMapping(value={"dealTask"})
    public SscTaskDealRspBO dealTask(@RequestBody SscTaskDealReqBO reqBO) {
        SscTaskDealRspBO rspBO = new SscTaskDealRspBO();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNextTaskInfos())) {
            uocOrderTaskInst = this.dealToDo(reqBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCompleteTaskInfos())) {
            uocOrderTaskInst = this.dealDone(reqBO);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            uocOrderTaskInst = this.dealPreTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getReturnTaskId())) {
            uocOrderTaskInst = this.dealReturnTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        if (reqBO.getUpdateTaskCandidate() != null && StringUtils.hasText((String)reqBO.getUpdateTaskCandidate().getTaskId())) {
            uocOrderTaskInst = this.dealTaskDealUpdate(reqBO.getUpdateTaskCandidate(), reqBO.getOrderId());
        }
        this.dealRsp(rspBO, uocOrderTaskInst);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void dealRsp(SscTaskDealRspBO rspBO, UocOrderTaskInst uocOrderTaskInst) {
        if (uocOrderTaskInst != null) {
            String pickerConfigNo = uocOrderTaskInst.getObjType().toString();
            rspBO.setMainObjId(uocOrderTaskInst.getObjId() + "");
            if (uocOrderTaskInst.getObjType().equals(SscCommConstant.ObjType.APPROVE)) {
                SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
                sscAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
                SscAuditOrderDo sscAuditOrderDo = this.iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
                pickerConfigNo = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
                rspBO.setMainObjId(sscAuditOrderDo.getUocApprovalObj().get(0).getObjId());
            }
            rspBO.setPickerConfigNo(pickerConfigNo + "_" + uocOrderTaskInst.getObjType());
            rspBO.setObjId(uocOrderTaskInst.getObjId());
            rspBO.setOrderId(uocOrderTaskInst.getOrderId());
        }
    }

    private UocOrderTaskInst dealReturnTask(String taskId, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setTaskInstId(taskId);
        sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        this.deleteTask(sscTaskQryBo);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst dealPreTask(String taskId, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setTaskInstId(taskId);
        sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        this.deleteTask(sscTaskQryBo);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst dealTaskDealUpdate(SscTaskInfoBO completeTaskBo, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), orderId);
        ArrayList<UocOrderTaskDeal> sscUocOrderTaskDeal = new ArrayList<UocOrderTaskDeal>();
        UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
        uocOrderTaskDeal.setOrderId(orderId);
        uocOrderTaskDeal.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        uocOrderTaskDeal.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskDeal.setObjType(uocOrderTaskInst.getObjType());
        SscCandidatesBO uecCandidatesBO = (SscCandidatesBO)completeTaskBo.getCandidates().get(0);
        uocOrderTaskDeal.setDealId(uecCandidatesBO.getCandidateId());
        uocOrderTaskDeal.setDealName(uecCandidatesBO.getCandidateName());
        sscUocOrderTaskDeal.add(uocOrderTaskDeal);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        sscProcInstDo.setSscUocOrderTaskDeal(sscUocOrderTaskDeal);
        this.iSscProcInstModel.updateTaskDeal(sscProcInstDo);
        SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
        ArrayList<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst1 = new UocOrderTaskInst();
        uocOrderTaskInst1.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskInst1.setOrderId(uocOrderTaskInst.getOrderId());
        uocOrderTaskInst1.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        String remarkOld = uocOrderTaskInst.getRemark();
        String objBusiType = remarkOld.split("_")[1];
        String remarkNew = uecCandidatesBO.getCandidateId() + "_" + objBusiType;
        uocOrderTaskInst1.setRemark(remarkNew);
        sscUocOrderTaskInst.add(uocOrderTaskInst1);
        sscProcInstDo1.setSscUocOrderTaskInst(sscUocOrderTaskInst);
        this.iSscProcInstModel.updateTask(sscProcInstDo1);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst checkTaskIsToDo(String taskId, Long orderId) {
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setOrderId(orderId);
        sscTaskQryBo.setTaskInstId(taskId);
        SscProcInstDo sscProcInstDo = this.iSscProcInstModel.getTaskList(sscTaskQryBo);
        if (sscProcInstDo == null || CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            throw new BaseBusinessException("291001", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u4e0d\u5b58\u5728");
        }
        if (SscCommConstant.PROC_TASK_FINISHED.FINISHED.equals(sscProcInstDo.getSscUocOrderTaskInst().get(0).getFinishTag())) {
            throw new BaseBusinessException("291001", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u5df2\u5b8c\u7ed3");
        }
        return sscProcInstDo.getSscUocOrderTaskInst().get(0);
    }

    private void updateTaskDone(SscTaskInfoBO completeTaskBo, SscTaskDealReqBO reqBO) {
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        ArrayList<UocOrderTaskInst> sscUocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getUsername());
        uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
        uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
        uocOrderTaskInst.setObjId(completeTaskBo.getBusiObjId());
        uocOrderTaskInst.setObjType(completeTaskBo.getBusiObjType());
        if (uocOrderTaskInst.getObjType().equals(SscCommConstant.ObjType.APPROVE)) {
            SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
            sscAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
            SscAuditOrderDo sscAuditOrderDo = this.iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
            String objBusiType = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            String remark = reqBO.getUserId() + "_" + objBusiType + "_" + completeTaskBo.getDealResult();
            uocOrderTaskInst.setRemark(remark);
        }
        sscUocOrderTaskInsts.add(uocOrderTaskInst);
        sscProcInstDo.setSscUocOrderTaskInst(sscUocOrderTaskInsts);
        this.iSscProcInstModel.updateTask(sscProcInstDo);
    }

    private UocOrderTaskInst dealDone(SscTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCompleteTaskInfos())) {
            for (SscTaskInfoBO completeTaskBo : reqBO.getCompleteTaskInfos()) {
                uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), reqBO.getOrderId());
                completeTaskBo.setBusiObjType(uocOrderTaskInst.getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInst.getObjId());
                this.updateTaskDone(completeTaskBo, reqBO);
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish().booleanValue()) {
                    SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
                    sscTaskQryBo.setOrderId(reqBO.getOrderId());
                    sscTaskQryBo.setProcState(uocOrderTaskInst.getProcState());
                    sscTaskQryBo.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    sscTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
                    this.deleteTask(sscTaskQryBo);
                }
                if (!Boolean.TRUE.equals(completeTaskBo.getFinish())) continue;
                this.updateProInst(completeTaskBo, reqBO.getOrderId());
            }
        }
        return uocOrderTaskInst;
    }

    private void deleteTask(SscTaskQryBo sscTaskQryBo) {
        SscProcInstDo sscProcInstDo = this.iSscProcInstModel.getTaskList(sscTaskQryBo);
        if (!CollectionUtils.isEmpty(sscProcInstDo.getSscUocOrderTaskInst())) {
            ArrayList<String> taskInstIds = new ArrayList<String>();
            sscProcInstDo.getSscUocOrderTaskInst().forEach(uocOrderTaskInst -> taskInstIds.add(uocOrderTaskInst.getTaskInstId()));
            SscProcInstDo sscProcInstDo1 = new SscProcInstDo();
            ArrayList<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
            UocOrderTaskInst uocOrderTaskInst2 = new UocOrderTaskInst();
            uocOrderTaskInst2.setObjId(sscTaskQryBo.getObjId());
            uocOrderTaskInst2.setOrderId(sscTaskQryBo.getOrderId());
            uocOrderTaskInst2.setTaskInstIds(taskInstIds);
            sscUocOrderTaskInst.add(uocOrderTaskInst2);
            sscProcInstDo1.setSscUocOrderTaskInst(sscUocOrderTaskInst);
            this.iSscProcInstModel.deleteTask(sscProcInstDo1);
        }
    }

    private void dealProInst(SscTaskInfoBO sscTaskInfoBO, Long orderId) {
        SscProcInstDo sscProcInstDoReq = new SscProcInstDo();
        sscProcInstDoReq.setProcInstId(sscTaskInfoBO.getProcInstId());
        SscProcInstDo sscProcInstDoRsp = this.iSscProcInstModel.getProcInst(sscProcInstDoReq);
        if (sscProcInstDoRsp == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sscProcInstDoRsp.getProcInstId())) {
            SscProcInstDo sscProcInstDo = new SscProcInstDo();
            sscProcInstDo.setProcInstId(sscTaskInfoBO.getProcInstId());
            sscProcInstDo.setObjId(sscTaskInfoBO.getBusiObjId());
            sscProcInstDo.setObjType(sscTaskInfoBO.getBusiObjType());
            sscProcInstDo.setOrderId(orderId);
            sscProcInstDo.setProcDefId(sscTaskInfoBO.getProcDefId());
            this.iSscProcInstModel.saveProcInst(sscProcInstDo);
        }
    }

    private UocOrderTaskInst dealTask(SscTaskInfoBO nextTaskInfo, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(orderId);
        uocOrderTaskInst.setTaskInstId(nextTaskInfo.getTaskId());
        uocOrderTaskInst.setObjId(nextTaskInfo.getBusiObjId());
        uocOrderTaskInst.setObjType(nextTaskInfo.getBusiObjType());
        uocOrderTaskInst.setProcState(nextTaskInfo.getStepId());
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInst.setFormUrl(nextTaskInfo.getFormUrl());
        uocOrderTaskInst.setProcDefId(nextTaskInfo.getProcDefId());
        uocOrderTaskInst.setProcInstId(nextTaskInfo.getProcInstId());
        uocOrderTaskInst.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        uocOrderTaskInst.setDealResult(SscCommConstant.TASK_DEAL_RESULT.APPROVING);
        if (uocOrderTaskInst.getTaskSignTag() == null) {
            uocOrderTaskInst.setTaskSignTag(SscCommConstant.TASK_SING_TAG.TACHE_TASK);
        }
        if (nextTaskInfo.getBusiObjType().equals(SscCommConstant.ObjType.APPROVE)) {
            SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
            sscAuditOrderQryBo.setAuditOrderId(nextTaskInfo.getBusiObjId());
            SscAuditOrderDo sscAuditOrderDo = this.iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
            String objBusiType = sscAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            if (!CollectionUtils.isEmpty((Collection)nextTaskInfo.getCandidates())) {
                String remark = ((SscCandidatesBO)nextTaskInfo.getCandidates().get(0)).getCandidateId();
                if (objBusiType != null) {
                    remark = remark + "_" + objBusiType;
                }
                uocOrderTaskInst.setRemark(remark);
            }
        }
        return uocOrderTaskInst;
    }

    private List<UocOrderTaskDeal> dealTaskDeal(SscTaskInfoBO nextTaskInfo, Long orderId) {
        ArrayList<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<UocOrderTaskDeal>();
        if (!CollectionUtils.isEmpty((Collection)nextTaskInfo.getCandidates())) {
            nextTaskInfo.getCandidates().forEach(sscCandidatesBO -> {
                UocOrderTaskDeal deal = new UocOrderTaskDeal();
                deal.setTaskInstId(nextTaskInfo.getTaskId());
                deal.setOrderId(orderId);
                deal.setObjId(nextTaskInfo.getBusiObjId());
                deal.setObjType(nextTaskInfo.getBusiObjType());
                deal.setDealId(sscCandidatesBO.getCandidateId());
                deal.setDealName(sscCandidatesBO.getCandidateName());
                deal.setDealClass("2");
                uocOrderTaskDeals.add(deal);
            });
        }
        return uocOrderTaskDeals;
    }

    private UocOrderTaskInst dealToDo(SscTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNextTaskInfos())) {
            ArrayList<UocOrderTaskInst> sscUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
            ArrayList<UocOrderTaskDeal> sscUocOrderTaskDeal = new ArrayList<UocOrderTaskDeal>();
            reqBO.getNextTaskInfos().forEach(sscTaskInfoBO -> {
                this.dealProInst((SscTaskInfoBO)sscTaskInfoBO, reqBO.getOrderId());
                sscUocOrderTaskInst.add(this.dealTask((SscTaskInfoBO)sscTaskInfoBO, reqBO.getOrderId()));
                sscUocOrderTaskDeal.addAll(this.dealTaskDeal((SscTaskInfoBO)sscTaskInfoBO, reqBO.getOrderId()));
                this.updateStatus((SscTaskInfoBO)sscTaskInfoBO, reqBO.getOrderId());
            });
            SscProcInstDo sscProcInstDo = new SscProcInstDo();
            sscProcInstDo.setSscUocOrderTaskInst(sscUocOrderTaskInst);
            sscProcInstDo.setSscUocOrderTaskDeal(sscUocOrderTaskDeal);
            this.iSscProcInstModel.saveTask(sscProcInstDo);
            uocOrderTaskInst = (UocOrderTaskInst)sscUocOrderTaskInst.get(0);
        }
        return uocOrderTaskInst;
    }

    private void updateStatus(SscTaskInfoBO sscTaskInfoBO, Long orderId) {
        if (SscCommConstant.ObjType.ORDER.equals(sscTaskInfoBO.getBusiObjType())) {
            SscSchemeDo sscSchemeDo = new SscSchemeDo();
            sscSchemeDo.setSchemeId(orderId);
            if ("SSCS0002".equals(sscTaskInfoBO.getStepId())) {
                sscSchemeDo.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.APPROVE.getCode());
                sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.FORWARDING.getCode());
                if (StrUtil.isNotEmpty((CharSequence)sscSchemeDo.getSchemeStatus()) || StrUtil.isNotEmpty((CharSequence)sscSchemeDo.getSchemeAuditStatus())) {
                    this.sscSchemeModel.updateSchemeMain(sscSchemeDo);
                }
            }
        }
    }

    private void updateProInst(SscTaskInfoBO completeTaskBo, Long orderId) {
        SscTaskQryBo sscTaskQryBo = new SscTaskQryBo();
        sscTaskQryBo.setTaskInstId(completeTaskBo.getTaskId());
        sscTaskQryBo.setOrderId(orderId);
        SscProcInstDo task = this.iSscProcInstModel.getTaskList(sscTaskQryBo);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        sscProcInstDo.setProcInstId(task.getSscUocOrderTaskInst().get(0).getProcInstId());
        sscProcInstDo.setFinishTag(SscCommConstant.YesOrNoEnum.YES.getCode());
        sscProcInstDo.setFinishTime(new Date());
        this.iSscProcInstModel.updateProcInst(sscProcInstDo);
    }
}

