package com.tydic.dyc.ssc.service.procinst;

import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetProcInstListReqBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetProcInstListRspBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscProcInstBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题:SscGetProcInstListServiceImpl
 * 说明:TODO
 * 时间:2023/3/13 16:26
 * 作者:代愿愿
 */
@HTServiceImpl
public class SscGetProcInstListServiceImpl implements SscGetProcInstListService {
    @Autowired
    private ISscProcInstModel iSscProcInstModel;
    @Override
    public SscGetProcInstListRspBO getProcInstList(SscGetProcInstListReqBO sscGetProcInstListReqBO) {
        SscProcInstDo sscProcInstDo = SscRu.js(sscGetProcInstListReqBO,SscProcInstDo.class);
        SscProcInstDo sscProcInstDo1 = iSscProcInstModel.getProcInstList(sscProcInstDo);
        SscGetProcInstListRspBO rspBO = new SscGetProcInstListRspBO();
        if(!CollectionUtils.isEmpty(sscProcInstDo1.getSscUocOrderProcInst())){
            rspBO.setRows(SscRu.jsl(sscProcInstDo1.getSscUocOrderProcInst(), SscProcInstBO.class));
        }
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }
}
