package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePutUpReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMainReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMainRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * @Description: SscUpdateSchemeMainServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-15
 */
@HTServiceImpl
public class SscUpdateSchemeMainServiceImpl implements SscUpdateSchemeMainService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscUpdateSchemeMainRspBO updateSchemeMain(SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO) {
        SscUpdateSchemeMainRspBO rspBO = SscRu.success(SscUpdateSchemeMainRspBO.class);
        check(sscUpdateSchemeMainReqBO);
        iSscSchemeModel.updateSchemeMain(SscRu.js(sscUpdateSchemeMainReqBO, SscSchemeDo.class));
        // 修改扩展字段信息
        this.updateExtInfo(sscUpdateSchemeMainReqBO);
        return rspBO;
    }

    private void check(SscUpdateSchemeMainReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }

    private void updateExtInfo(SscUpdateSchemeMainReqBO reqBO) {
        List<BaseExtendFieldBo> extFieldList = reqBO.getExtFields();
        if (CollectionUtil.isNotEmpty(extFieldList)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            sscCommonDo.setExtObjInfos(Collections.singletonList(objInfo));
            iSscCommonModel.updateExtInfo(sscCommonDo);
        }
    }
}
