/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMainInfoListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeMainInfoListService"})
public class SscQrySchemeMainInfoListServiceImpl
implements SscQrySchemeMainInfoListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"qrySchemeMainInfoList"})
    public SscQrySchemeMainInfoListRspBO qrySchemeMainInfoList(@RequestBody SscQrySchemeMainInfoListReqBO sscQrySchemeMainInfoListReqBO) {
        this.check(sscQrySchemeMainInfoListReqBO);
        SscQrySchemeMainInfoListRspBO rspBO = SscRu.success(SscQrySchemeMainInfoListRspBO.class);
        SscQrySchemeMainInfoListRspBO schemeMainInfoList = this.iSscSchemeModel.qrySchemeMainInfoList(sscQrySchemeMainInfoListReqBO);
        rspBO.setSscQrySchemeMainInfoList(schemeMainInfoList.getSscQrySchemeMainInfoList());
        this.setExtInfo(rspBO);
        return rspBO;
    }

    private void check(SscQrySchemeMainInfoListReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getSchemeIdList())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setExtInfo(SscQrySchemeMainInfoListRspBO rspBO) {
        List sscQrySchemeMainInfoList = rspBO.getSscQrySchemeMainInfoList();
        if (CollectionUtil.isNotEmpty((Collection)sscQrySchemeMainInfoList)) {
            List<SscExtObjInfo> objInfoList = sscQrySchemeMainInfoList.stream().map(e -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(e.getSchemeId());
                objInfo.setOrderId(e.getSchemeId());
                objInfo.setObjType("ssc_scheme_ext");
                return objInfo;
            }).collect(Collectors.toList());
            SscCommonDo sscCommonDo = new SscCommonDo();
            sscCommonDo.setExtObjInfos(objInfoList);
            SscCommonDo extInfoResult = this.iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> extObjInfoList = extInfoResult.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(extObjInfoList)) {
                Map<Long, List> objIdInfoListMap = extObjInfoList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
                sscQrySchemeMainInfoList.forEach(e -> e.setExtFields(SscRu.jsl((List)objIdInfoListMap.get(e.getSchemeId()), BaseExtendFieldBo.class)));
            }
        }
    }
}

