package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.bo.SscSetSchemeMatNullValueBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSetSchemeMatNullValueBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Author: dmc
 * @Date: 2022/11/14 10:30
 * @Description: SSCS0010-方案明细批量设置服务
 */
@HTServiceImpl
public class SscSetSchemeMatNullValueBatchServiceImpl implements SscSetSchemeMatNullValueBatchService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscSetSchemeMatNullValueBatchRspBO setSchemeMatNullValueBatch(SscSetSchemeMatNullValueBatchReqBO reqBO) {
        //1 参数校验
        this.validationParam(reqBO);
        //2 入参转换
        SscSchemeDo sscSchemeDo = SscRu.js(reqBO, SscSchemeDo.class);
        //3 根据updateType的值调用批量更新
        this.executeMethod(sscSchemeDo, reqBO.getUpdateType());

        return new SscSetSchemeMatNullValueBatchRspBO();
    }

    /**
     * 调用更新方法
     */
    private void executeMethod(SscSchemeDo sscSchemeDo, String updateType) {
        Integer type = Integer.valueOf(updateType);
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo.getSscSchemeMat();
        if(sscSchemeMat.size() != 1){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "sscSchemeMat(方案物料信息)有且只能有一条数据,当前存在"+sscSchemeMat.size());
        }
        //应用到全部物料行                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             updateType=1
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_ALL_MAT)) {
            this.iSscSchemeModel.updateSchemeMatBatchUnNullValue(sscSchemeDo);
        }
        //应用到选中物料行	updateType=3
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_CHECKED)) {
            if(CollectionUtils.isEmpty(sscSchemeMat.get(0).getSchemeMatIds())){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参schemeMatIds方案物料ID集合为空");
            }
            this.iSscSchemeModel.updateSchemeMatBatchUnNullValue(sscSchemeDo);
        }
        //应用到未填写物料行  updateType=2
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_NO_WRITE)) {
            this.iSscSchemeModel.setSchemeMatNullValue(sscSchemeDo);
        }
    }

    /**
     * 参数校验
     * @param reqBO reqBO
     */
    private void validationParam(SscSetSchemeMatNullValueBatchReqBO reqBO) {
        if(null == reqBO){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getSchemeId()){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象[schemeId 方案id]为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getSscSchemeMat())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象[sscSchemeMat 方案物料信息]为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getEnableDraft())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象[enableDraft 是否草稿]为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getUpdateType())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参对象[updateType 更新类型]为空");
        }
    }
}
