/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeService"})
public class SscDeleteSchemeServiceImpl
implements SscDeleteSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"deleteScheme"})
    public SscDeleteSchemeRspBO deleteScheme(@RequestBody SscDeleteSchemeReqBO sscDeleteSchemeReqBO0) {
        SscDeleteSchemeRspBO rspBo = SscRu.success(SscDeleteSchemeRspBO.class);
        this.validateArg(sscDeleteSchemeReqBO0);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setEnableDraft(sscDeleteSchemeReqBO0.getEnableDraft());
        sscSchemeDo.setSchemeId(sscDeleteSchemeReqBO0.getSchemeId());
        this.iSscSchemeModel.deleteScheme(sscSchemeDo);
        this.deleteExtInfo(sscDeleteSchemeReqBO0);
        return rspBo;
    }

    private void validateArg(SscDeleteSchemeReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscDeleteSchemeReqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void deleteExtInfo(SscDeleteSchemeReqBO reqBO) {
        SscCommonDo sscCommonDo = new SscCommonDo();
        ArrayList<SscExtObjInfo> extObjInfos = new ArrayList<SscExtObjInfo>();
        extObjInfos.add(this.createObjInfo("ssc_scheme_ext", reqBO.getSchemeId()));
        extObjInfos.add(this.createObjInfo("ssc_scheme_pack_ext", reqBO.getSchemeId()));
        extObjInfos.add(this.createObjInfo("ssc_scheme_mat_ext", reqBO.getSchemeId()));
        extObjInfos.add(this.createObjInfo("ssc_scheme_invite_sup_ext", reqBO.getSchemeId()));
        sscCommonDo.setExtObjInfos(extObjInfos);
        this.iSscCommonModel.deleteExtInfo(sscCommonDo);
    }

    private SscExtObjInfo createObjInfo(String objType, Long schemeId) {
        SscExtObjInfo objInfo = new SscExtObjInfo();
        objInfo.setOrderId(schemeId);
        objInfo.setObjType(objType);
        return objInfo;
    }
}

