/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtObjInfoBo;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeDetailService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeDetailService"})
public class SscQrySchemeDetailServiceImpl
implements SscQrySchemeDetailService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"qrySchemeDetail"})
    public SscQrySchemeDetailRspBO qrySchemeDetail(@RequestBody SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO0) {
        SscQrySchemeDetailRspBO rspBo = SscRu.success(SscQrySchemeDetailRspBO.class);
        this.validateArg(sscQrySchemeDetailReqBO0);
        SscSchemeQryBo qryBo = new SscSchemeQryBo();
        qryBo.setSchemeId(sscQrySchemeDetailReqBO0.getSchemeId());
        qryBo.setEnableDraft(sscQrySchemeDetailReqBO0.getEnableDraft());
        qryBo.setSchemeHisId(sscQrySchemeDetailReqBO0.getSchemeHisId());
        SscSchemeDo sscSchemeDo = this.iSscSchemeModel.qrySchemeDetail(qryBo);
        if (sscSchemeDo == null) {
            throw new BaseBusinessException("291002", "\u65b9\u6848\u8be6\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        SscQrySchemeDetailBO detailBO = SscRu.js(sscSchemeDo, SscQrySchemeDetailBO.class);
        if (sscSchemeDo.getSchemeClass() != null) {
            detailBO.setSchemeClassStr(Objects.requireNonNull(SscCommConstant.SchemeClass.getInstance((Integer)sscSchemeDo.getSchemeClass())).getDesc());
        }
        if (sscSchemeDo.getSchemeStatus() != null) {
            detailBO.setSchemeStatusStr(Objects.requireNonNull(SscCommConstant.SchemeStatus.getInstance((String)sscSchemeDo.getSchemeStatus())).getDesc());
        }
        if (sscSchemeDo.getPurchaseType() != null) {
            detailBO.setPurchaseTypeStr(Objects.requireNonNull(SscCommConstant.SchemePurchaseType.getInstance((Integer)sscSchemeDo.getPurchaseType())).getDesc());
        }
        if (sscSchemeDo.getCheckType() != null) {
            detailBO.setCheckTypeStr(Objects.requireNonNull(SscCommConstant.SchemeCheckType.getInstance((Integer)sscSchemeDo.getCheckType())).getDesc());
        }
        if (sscSchemeDo.getOfferType() != null) {
            detailBO.setOfferTypeStr(Objects.requireNonNull(SscCommConstant.SchemeOfferType.getInstance((Integer)sscSchemeDo.getOfferType())).getDesc());
        }
        if (sscSchemeDo.getBiddingFlag() != null) {
            detailBO.setBiddingFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBiddingFlag.getInstance((Integer)sscSchemeDo.getBiddingFlag())).getDesc());
        }
        if (sscSchemeDo.getSupplierNameDisplayFlag() != null) {
            detailBO.setSupplierNameDisplayFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSupplierNameDisplayFlag.getInstance((Integer)sscSchemeDo.getSupplierNameDisplayFlag())).getDesc());
        }
        if (sscSchemeDo.getOrganizationForm() != null) {
            detailBO.setOrganizationFormStr(Objects.requireNonNull(SscCommConstant.SchemeOrganizationForm.getInstance((Integer)Integer.parseInt(sscSchemeDo.getOrganizationForm()))).getDesc());
        }
        if (sscSchemeDo.getSubpackageFlag() != null) {
            detailBO.setSubpackageFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSubpackageFlag.getInstance((Integer)sscSchemeDo.getSubpackageFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderChargeFlag() != null) {
            detailBO.setTenderChargeFlagStr(Objects.requireNonNull(SscCommConstant.SchemeTenderChargeFlag.getInstance((Integer)sscSchemeDo.getTenderChargeFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderSaleForm() != null) {
            detailBO.setTenderSaleFormStr(Objects.requireNonNull(SscCommConstant.SchemeTenderSaleForm.getInstance((Integer)sscSchemeDo.getTenderSaleForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginFlag() != null) {
            detailBO.setBidMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginFlag.getInstance((Integer)sscSchemeDo.getBidMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getBidMarginForm() != null) {
            detailBO.setBidMarginFormStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginForm.getInstance((Integer)sscSchemeDo.getBidMarginForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginPayForm() != null) {
            String bidMarginPayFormStr = Arrays.stream(sscSchemeDo.getBidMarginPayForm().split(",")).map(e -> SscCommConstant.SchemeBidMarginPayForm.getInstance((Integer)Integer.valueOf(e)).getDesc()).collect(Collectors.joining(","));
            detailBO.setBidMarginPayFormStr(bidMarginPayFormStr);
        }
        if (sscSchemeDo.getPrefMarginFlag() != null) {
            detailBO.setPrefMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemePrefMarginFlag.getInstance((Integer)sscSchemeDo.getPrefMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getImportFlag() != null) {
            detailBO.setImportFlagStr(Objects.requireNonNull(SscCommConstant.SchemeImportFlag.getInstance((Integer)sscSchemeDo.getImportFlag())).getDesc());
        }
        if (sscSchemeDo.getEmergencyFlag() != null) {
            detailBO.setEmergencyFlagStr(Objects.requireNonNull(SscCommConstant.SchemeEmergencyFlag.getInstance((Integer)sscSchemeDo.getEmergencyFlag())).getDesc());
        }
        if (sscSchemeDo.getContractSignFlag() != null) {
            detailBO.setContractSignFlagStr(Objects.requireNonNull(SscCommConstant.SchemeContractSignFlag.getInstance((Integer)sscSchemeDo.getContractSignFlag())).getDesc());
        }
        if (sscSchemeDo.getSourcingStatus() != null) {
            detailBO.setSourcingStatusStr(SscCommConstant.SchemeSourcingStatus.getInstance((Integer)Integer.parseInt(sscSchemeDo.getSourcingStatus())).getDesc());
        }
        Optional.ofNullable(sscSchemeDo.getSchemeType()).ifPresent(e -> {
            SscCommConstant.SchemeTypeEnum schemeTypeEnum = SscCommConstant.SchemeTypeEnum.findDescByCode((String)e);
            detailBO.setSchemeTypeStr(ObjectUtil.isNull((Object)schemeTypeEnum) ? null : schemeTypeEnum.getDesc());
        });
        Optional.ofNullable(sscSchemeDo.getSourcingWay()).ifPresent(e -> detailBO.setSourcingWayStr(SscCommConstant.SourcingWayEnum.findDescByCode((String)e).getDesc()));
        Optional.ofNullable(sscSchemeDo.getMultipleAwardsForOneBid()).ifPresent(e -> detailBO.setMultipleAwardsForOneBidStr(SscCommConstant.YesOrNoEnum.findDescByCode((Integer)e).getDesc()));
        this.setExtInfo(sscQrySchemeDetailReqBO0, detailBO);
        rspBo.setSscQrySchemeDetailBO(detailBO);
        return rspBo;
    }

    private void validateArg(SscQrySchemeDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscQrySchemeDetailReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null && reqBO.getSchemeHisId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[schemeId\u548cschemeHisId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setExtInfo(SscQrySchemeDetailReqBO reqBO, SscQrySchemeDetailBO detailBO) {
        SscExtInfoQryReqBO qryReqBO = new SscExtInfoQryReqBO();
        ArrayList<SscExtObjInfoBo> extObjInfos = new ArrayList<SscExtObjInfoBo>();
        List sscSchemePackList = detailBO.getSscSchemePack();
        SscExtObjInfoBo schemeObjInfoBo = new SscExtObjInfoBo();
        schemeObjInfoBo.setOrderId(detailBO.getSchemeId());
        if (ObjectUtil.isNotNull((Object)reqBO.getSchemeHisId())) {
            schemeObjInfoBo.setObjId(reqBO.getSchemeHisId());
            schemeObjInfoBo.setObjType("ssc_scheme_his_ext");
            if (CollectionUtil.isNotEmpty((Collection)sscSchemePackList)) {
                sscSchemePackList.forEach(e -> {
                    SscExtObjInfoBo packObjInfoBo = new SscExtObjInfoBo();
                    packObjInfoBo.setObjId(e.getPackHisId());
                    packObjInfoBo.setObjType("ssc_scheme_pack_his_ext");
                    extObjInfos.add(packObjInfoBo);
                });
            }
        } else {
            schemeObjInfoBo.setObjId(reqBO.getSchemeId());
            schemeObjInfoBo.setObjType("ssc_scheme_ext");
            if (CollectionUtil.isNotEmpty((Collection)sscSchemePackList)) {
                sscSchemePackList.forEach(e -> {
                    SscExtObjInfoBo packObjInfoBo = new SscExtObjInfoBo();
                    packObjInfoBo.setObjId(e.getPackId());
                    packObjInfoBo.setObjType("ssc_scheme_pack_ext");
                    extObjInfos.add(packObjInfoBo);
                });
            }
        }
        extObjInfos.add(schemeObjInfoBo);
        qryReqBO.setExtObjInfos(extObjInfos);
        SscCommonDo sscCommonDo = this.iSscCommonModel.qryExtInfo(SscRu.js(qryReqBO, SscCommonDo.class));
        List<SscExtObjInfo> infoBoList = sscCommonDo.getExtObjInfos();
        if (CollectionUtil.isNotEmpty(infoBoList)) {
            Map<Long, List> objIdExtInfoMap = infoBoList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo, (a, b) -> a));
            if (ObjectUtil.isNotNull((Object)reqBO.getSchemeHisId())) {
                detailBO.setExtFields(SscRu.jsl(objIdExtInfoMap.get(reqBO.getSchemeHisId()), BaseExtendFieldBo.class));
                if (CollectionUtil.isNotEmpty((Collection)sscSchemePackList)) {
                    sscSchemePackList.forEach(e -> e.setExtFields(SscRu.jsl((List)objIdExtInfoMap.get(e.getPackHisId()), BaseExtendFieldBo.class)));
                }
            } else {
                detailBO.setExtFields(SscRu.jsl(objIdExtInfoMap.get(reqBO.getSchemeId()), BaseExtendFieldBo.class));
                if (CollectionUtil.isNotEmpty((Collection)sscSchemePackList)) {
                    sscSchemePackList.forEach(e -> e.setExtFields(SscRu.jsl((List)objIdExtInfoMap.get(e.getPackId()), BaseExtendFieldBo.class)));
                }
            }
        }
    }
}

