/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeVersionListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeVersionListService"})
public class SscQrySchemeVersionListServiceImpl
implements SscQrySchemeVersionListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeVersionList"})
    public SscQrySchemeVersionListRspBO qrySchemeVersionList(@RequestBody SscQrySchemeVersionListReqBO sscQrySchemeVersionListReqBO) {
        SscQrySchemeVersionListRspBO schemeVersion;
        List versionList;
        this.check(sscQrySchemeVersionListReqBO);
        if (ObjectUtil.isNull((Object)sscQrySchemeVersionListReqBO.getPageNo()) && ObjectUtil.isNull((Object)sscQrySchemeVersionListReqBO.getPageSize())) {
            sscQrySchemeVersionListReqBO.setPageSize(Integer.valueOf(-1));
            sscQrySchemeVersionListReqBO.setPageNo(Integer.valueOf(-1));
        }
        if (CollectionUtil.isNotEmpty((Collection)(versionList = (schemeVersion = this.iSscSchemeModel.qrySchemeVersionList((SscSchemeQryBo)JUtil.js((Object)sscQrySchemeVersionListReqBO, SscSchemeQryBo.class))).getSscSchemeVersion()))) {
            versionList.forEach(e -> {
                if (ObjectUtil.isNotNull((Object)e.getSchemeClass())) {
                    e.setSchemeClassStr(SscCommConstant.SchemeClass.getInstance((Integer)e.getSchemeClass()).getDesc());
                }
                if (StrUtil.isNotEmpty((CharSequence)e.getOrganizationForm())) {
                    e.setOrganizationFormStr(SscCommConstant.SchemeOrganizationForm.getInstance((Integer)Integer.valueOf(e.getOrganizationForm())).getDesc());
                }
                if (ObjectUtil.isNotEmpty((Object)e.getPurchaseType())) {
                    e.setPurchaseTypeStr(SscCommConstant.SchemePurchaseType.getInstance((Integer)e.getPurchaseType()).getDesc());
                }
                if (StrUtil.isNotEmpty((CharSequence)e.getSchemeAuditStatus())) {
                    e.setSchemeAuditStatusStr(SscCommConstant.SchemeAuditStatus.findDescByCode((String)e.getSchemeAuditStatus()).getDesc());
                }
            });
        }
        return SscRu.js(schemeVersion, SscQrySchemeVersionListRspBO.class);
    }

    private void check(SscQrySchemeVersionListReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

