/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchInsertService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddCoefficientModifyBusiService;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiReqBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAddCoefficientModifyBusiRspBo;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchInsertService"})
public class UccSkuAddPriceBatchInsertServiceImpl
implements UccSkuAddPriceBatchInsertService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchInsertServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuAddCoefficientModifyBusiService uccSkuAddCoefficientModifyBusiService;

    @PostMapping(value={"batchInsertSkuAddPrice"})
    public UccSkuAddPriceBatchInsertRspBO batchInsertSkuAddPrice(@RequestBody UccSkuAddPriceBatchInsertReqBO reqBO) {
        UccSkuAddPriceBatchInsertRspBO rspBO = new UccSkuAddPriceBatchInsertRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f20\u5165\u53c2\u6570\u975e\u6cd5\uff01");
            return rspBO;
        }
        ArrayList uccSkuAddCoefficientPOS = new ArrayList();
        List skuId = reqBO.getAddPriceInfoList().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS1 = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuId);
        if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOS1)) {
            ArrayList uccSkuAddPriceBatchInsertBOS = new ArrayList();
            List havSkus = uccSkuAddCoefficientPOS1.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            reqBO.getAddPriceInfoList().forEach(each -> {
                if (!havSkus.contains(each.getSkuId())) {
                    uccSkuAddPriceBatchInsertBOS.add(each);
                }
            });
            reqBO.setAddPriceInfoList(uccSkuAddPriceBatchInsertBOS);
        }
        reqBO.getAddPriceInfoList().forEach(skuPriceInfo -> {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddPriceBatchInsertBO.class, UccSkuAddCoefficientPO.class, (boolean)false);
            beanCopier.copy(skuPriceInfo, (Object)uccSkuAddCoefficientPO, null);
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setAddCoefficient(skuPriceInfo.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setCatelogId(skuPriceInfo.getCatalogId());
            uccSkuAddCoefficientPOS.add(uccSkuAddCoefficientPO);
        });
        if (CollectionUtils.isEmpty(uccSkuAddCoefficientPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6240\u6709\u5355\u54c1\u90fd\u5df2\u6dfb\u52a0\u52a0\u4ef7\u7cfb\u6570\uff01");
            return rspBO;
        }
        try {
            this.uccSkuAddCoefficientMapper.batchInsert(uccSkuAddCoefficientPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u90e8\u5206\u5355\u54c1\u65b0\u589e\u52a0\u4ef7\u5931\u8d25\uff01");
        }
        ArrayList<UccSkuAddCoefficientLogPO> uccSkuAddCoefficientLogPOS = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddCoefficientPO.class, UccSkuAddCoefficientLogPO.class, (boolean)false);
            beanCopier.copy((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO, null);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuAddCoefficientLogPO.setSkuPriceId(uccSkuAddCoefficientPO.getSkuId());
            uccSkuAddCoefficientLogPO.setExpiryTime(uccSkuAddCoefficientPO.getExpTime());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            if (!ObjectUtils.isEmpty((Object)reqBO.getUserId())) {
                uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUserId().toString());
            }
            uccSkuAddCoefficientLogPOS.add(uccSkuAddCoefficientLogPO);
        }
        try {
            this.uccSkuAddCoefficientLogMapper.batchInsert(uccSkuAddCoefficientLogPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u6279\u91cf\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a" + e.getMessage());
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setIsAddCoefficient(Integer.valueOf(1));
        List skuIds = reqBO.getAddPriceInfoList().stream().map(UccSkuAddPriceBatchInsertBO::getSkuId).collect(Collectors.toList());
        try {
            this.uccSkuMapper.batchUpdateById(skuIds, uccSkuPo);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5355\u54c1\u662f\u5426\u5df2\u52a0\u4ef7\u6807\u8bc6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ZTBusinessException("\u4fee\u6539\u5355\u54c1\u662f\u5426\u5df2\u52a0\u4ef7\u6807\u8bc6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        List<Long> LongTimeFlagSkuIds = reqBO.getAddPriceInfoList().stream().filter(bo -> ObjectUtil.isNotEmpty((Object)bo.getLongTimeFlag()) && bo.getLongTimeFlag() == 1).map(UccSkuAddPriceBatchInsertBO::getSkuId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(LongTimeFlagSkuIds)) {
            UccSkuAddCoefficientModifyBusiReqBo uccSkuAddCoefficientModifyBusiReqBo = new UccSkuAddCoefficientModifyBusiReqBo();
            uccSkuAddCoefficientModifyBusiReqBo.setOperationType(1);
            uccSkuAddCoefficientModifyBusiReqBo.setEffectiveState(1);
            uccSkuAddCoefficientModifyBusiReqBo.setSkuIds(LongTimeFlagSkuIds);
            UccSkuAddCoefficientModifyBusiRspBo uccSkuAddCoefficientModifyBusiRspBo = this.uccSkuAddCoefficientModifyBusiService.dealCoefficientConfigModify(uccSkuAddCoefficientModifyBusiReqBo);
            if (!"0000".equals(uccSkuAddCoefficientModifyBusiRspBo.getRespCode())) {
                log.error("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1\u5931\u8d25\uff1a" + uccSkuAddCoefficientModifyBusiRspBo.getRespDesc());
                throw new ZTBusinessException("\u5355\u54c1\u52a0\u4ef7\u4fee\u6539\u5904\u7406\u670d\u52a1\u5931\u8d25\uff1a" + uccSkuAddCoefficientModifyBusiRspBo.getRespDesc());
            }
        }
        this.syncSkuEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u6210\u529f\uff01");
        return rspBO;
    }

    private void syncSkuEs(UccSkuAddPriceBatchInsertReqBO reqBO) {
        List skuIds = reqBO.getAddPriceInfoList().stream().map(UccSkuAddPriceBatchInsertBO::getSkuId).collect(Collectors.toList());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5355\u54c1\u5f85\u52a0\u4ef7\u8bbe\u7f6e\u52a0\u4ef7\u7cfb\u6570|\u540c\u6b65\u5355\u54c1\u4fe1\u606fES|\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

