/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.api.bo.role;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tydic.nbchat.user.api.bo.role.UserRoleInfo;
import com.tydic.nbchat.user.api.bo.user.UserDeptInfo;
import com.tydic.nbchat.user.api.bo.user.UserPostInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubSystemInfo
implements Serializable {
    private String code;
    private String tenantName;
    private List<String> depts = new ArrayList<String>();
    private List<UserRoleInfo> roles = new ArrayList<UserRoleInfo>();
    private List<UserPostInfo> posts = new ArrayList<UserPostInfo>();
    private UserDeptInfo dept;
    private String realName;
    private String avatarUrl;

    public boolean hasRole() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public boolean mathDept(String deptId) {
        if (this.depts != null) {
            return this.depts.contains(deptId);
        }
        return false;
    }

    public boolean hasApiPermission(String api) {
        if (this.roles != null) {
            for (UserRoleInfo role : this.roles) {
                if (!role.getApis().contains(api)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMenuPermission(String menuUrl) {
        if (this.roles != null) {
            for (UserRoleInfo role : this.roles) {
                if (!role.getMenus().contains(menuUrl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPost(String postId) {
        if (this.posts != null) {
            for (UserPostInfo post : this.posts) {
                if (!post.getPostId().equals(postId)) continue;
                return true;
            }
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public List<String> getDepts() {
        return this.depts;
    }

    public List<UserRoleInfo> getRoles() {
        return this.roles;
    }

    public List<UserPostInfo> getPosts() {
        return this.posts;
    }

    public UserDeptInfo getDept() {
        return this.dept;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setDepts(List<String> depts) {
        this.depts = depts;
    }

    public void setRoles(List<UserRoleInfo> roles) {
        this.roles = roles;
    }

    public void setPosts(List<UserPostInfo> posts) {
        this.posts = posts;
    }

    public void setDept(UserDeptInfo dept) {
        this.dept = dept;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubSystemInfo)) {
            return false;
        }
        SubSystemInfo other = (SubSystemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        List<String> this$depts = this.getDepts();
        List<String> other$depts = other.getDepts();
        if (this$depts == null ? other$depts != null : !((Object)this$depts).equals(other$depts)) {
            return false;
        }
        List<UserRoleInfo> this$roles = this.getRoles();
        List<UserRoleInfo> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<UserPostInfo> this$posts = this.getPosts();
        List<UserPostInfo> other$posts = other.getPosts();
        if (this$posts == null ? other$posts != null : !((Object)this$posts).equals(other$posts)) {
            return false;
        }
        UserDeptInfo this$dept = this.getDept();
        UserDeptInfo other$dept = other.getDept();
        if (this$dept == null ? other$dept != null : !((Object)this$dept).equals(other$dept)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$avatarUrl = this.getAvatarUrl();
        String other$avatarUrl = other.getAvatarUrl();
        return !(this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubSystemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        List<String> $depts = this.getDepts();
        result = result * 59 + ($depts == null ? 43 : ((Object)$depts).hashCode());
        List<UserRoleInfo> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<UserPostInfo> $posts = this.getPosts();
        result = result * 59 + ($posts == null ? 43 : ((Object)$posts).hashCode());
        UserDeptInfo $dept = this.getDept();
        result = result * 59 + ($dept == null ? 43 : ((Object)$dept).hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        return result;
    }

    public String toString() {
        return "SubSystemInfo(code=" + this.getCode() + ", tenantName=" + this.getTenantName() + ", depts=" + String.valueOf(this.getDepts()) + ", roles=" + String.valueOf(this.getRoles()) + ", posts=" + String.valueOf(this.getPosts()) + ", dept=" + String.valueOf(this.getDept()) + ", realName=" + this.getRealName() + ", avatarUrl=" + this.getAvatarUrl() + ")";
    }
}

