/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.api.bo.eums;

public enum CustomizeTypeEnum {
    _AUDIO("audio", "\u8bed\u97f3", "2"),
    _AUDIO2("audio2", "\u8bed\u97f32.0", "7"),
    _2D("2d", "2d\u6570\u5b57\u4eba", "1"),
    _2DGIF("2d_gif", "2d_gif\u6570\u5b57\u4eba", "4"),
    _25D("2.5d", "2.5d\u6570\u5b57\u4eba", "5"),
    _25DMTK("2.5d_mtk", "2.5d_mtk\u6570\u5b57\u4eba", "3"),
    _25DMTK2("2.5d_mtk2", "2.5d\u6570\u5b57\u4eba2", "6");

    private String code;
    private String name;
    private String type;

    private CustomizeTypeEnum(String code, String name, String type) {
        this.code = code;
        this.name = name;
        this.type = type;
    }

    public static String getType(String code) {
        if (code.startsWith("2")) {
            return "1";
        }
        if (code.startsWith("audio")) {
            return "2";
        }
        return null;
    }

    public static CustomizeTypeEnum getByCode(String code) {
        for (CustomizeTypeEnum customizeTypeEnum : CustomizeTypeEnum.values()) {
            if (!customizeTypeEnum.getCode().equals(code)) continue;
            return customizeTypeEnum;
        }
        return null;
    }

    public static String getRightsType(String code) {
        for (CustomizeTypeEnum customizeTypeEnum : CustomizeTypeEnum.values()) {
            if (!customizeTypeEnum.getCode().equals(code)) continue;
            return customizeTypeEnum.getType();
        }
        return null;
    }

    public static String getCodeByType(String type) {
        for (CustomizeTypeEnum customizeTypeEnum : CustomizeTypeEnum.values()) {
            if (!customizeTypeEnum.getType().equals(type)) continue;
            return customizeTypeEnum.getCode();
        }
        return null;
    }

    public boolean equalsCode(String code) {
        return this.code.equals(code);
    }

    public static boolean isExistCode(String code) {
        for (CustomizeTypeEnum field : CustomizeTypeEnum.values()) {
            if (!field.code.equals(code)) continue;
            return true;
        }
        return false;
    }

    public static String convertType(String code) {
        if (_2D.getCode().equals(code)) {
            return "2d_mtk";
        }
        CustomizeTypeEnum customizeTypeEnum = CustomizeTypeEnum.getByCode(code);
        if (customizeTypeEnum != null) {
            return customizeTypeEnum.getCode();
        }
        return null;
    }

    public static boolean isAudioType(String code) {
        return _AUDIO.getCode().equals(code) || _AUDIO2.getCode().equals(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }
}

