/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.producer;

import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
public class RocketMQProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducer.class);
    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${rocketmq.producer.send-message-timeout}")
    private Integer messageTimeOut;

    public void sendAsyncMsg(String topic, String msgBody, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(topic, MessageBuilder.withPayload((Object)msgBody).build(), callback);
    }

    public void sendAsyncMsg(String topic, String tagName, String msgBody, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build(), callback);
    }

    public void sendDelayMsg(String topic, String msgBody, Integer delayLevel) {
        this.rocketMQTemplate.syncSend(topic, MessageBuilder.withPayload((Object)msgBody).build(), (long)this.messageTimeOut.intValue(), delayLevel.intValue());
    }

    public void sendDelayMsg(String topic, String tagName, String msgBody, Integer delayLevel) {
        this.rocketMQTemplate.syncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build(), (long)this.messageTimeOut.intValue(), delayLevel.intValue());
    }

    public void sendMsg(String topic, String msgBody) {
        this.rocketMQTemplate.syncSend(topic, MessageBuilder.withPayload((Object)msgBody).build());
    }

    public void sendMsg(String topic, String tagName, String msgBody) {
        this.rocketMQTemplate.syncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build());
    }
}

