/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.config;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="upload-file-manage")
public class FileManageConfigPropertiesBean {
    private String tmpPath = "/tmp";
    private String uploadType = "local";
    private String localPath = "/tmp";
    private String accessUrlPrefix = "http://localhost/";
    private List<String> allowReferers = Lists.newArrayList();
    private List<String> whiteList = Lists.newArrayList();
    private List<String> blackList = Lists.newArrayList();

    public boolean matchWhiteIp(String reqIp) {
        if (!this.whiteList.isEmpty()) {
            for (String whiteIp : this.whiteList) {
                if (!whiteIp.equals("*") && !whiteIp.equals(reqIp)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean matchBlackIp(String reqIp) {
        if (!this.blackList.isEmpty()) {
            for (String blackIp : this.blackList) {
                if (!blackIp.equals(reqIp)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchReferes(String reqRefere) {
        if (!this.allowReferers.isEmpty() && !StringUtils.isEmpty((CharSequence)reqRefere)) {
            for (String allowReferer : this.allowReferers) {
                if (!reqRefere.startsWith(allowReferer)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getAccessUrlPrefix() {
        if (!this.accessUrlPrefix.endsWith("/")) {
            return this.accessUrlPrefix + "/";
        }
        return this.accessUrlPrefix;
    }

    public String getTmpPath() {
        if (!this.tmpPath.endsWith("/")) {
            return this.tmpPath + "/";
        }
        return this.tmpPath;
    }

    public String getLocalPath() {
        if (!this.localPath.endsWith("/")) {
            return this.localPath + "/";
        }
        return this.localPath;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public List<String> getAllowReferers() {
        return this.allowReferers;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public List<String> getBlackList() {
        return this.blackList;
    }

    public void setTmpPath(String tmpPath) {
        this.tmpPath = tmpPath;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setAccessUrlPrefix(String accessUrlPrefix) {
        this.accessUrlPrefix = accessUrlPrefix;
    }

    public void setAllowReferers(List<String> allowReferers) {
        this.allowReferers = allowReferers;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public void setBlackList(List<String> blackList) {
        this.blackList = blackList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileManageConfigPropertiesBean)) {
            return false;
        }
        FileManageConfigPropertiesBean other = (FileManageConfigPropertiesBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tmpPath = this.getTmpPath();
        String other$tmpPath = other.getTmpPath();
        if (this$tmpPath == null ? other$tmpPath != null : !this$tmpPath.equals(other$tmpPath)) {
            return false;
        }
        String this$uploadType = this.getUploadType();
        String other$uploadType = other.getUploadType();
        if (this$uploadType == null ? other$uploadType != null : !this$uploadType.equals(other$uploadType)) {
            return false;
        }
        String this$localPath = this.getLocalPath();
        String other$localPath = other.getLocalPath();
        if (this$localPath == null ? other$localPath != null : !this$localPath.equals(other$localPath)) {
            return false;
        }
        String this$accessUrlPrefix = this.getAccessUrlPrefix();
        String other$accessUrlPrefix = other.getAccessUrlPrefix();
        if (this$accessUrlPrefix == null ? other$accessUrlPrefix != null : !this$accessUrlPrefix.equals(other$accessUrlPrefix)) {
            return false;
        }
        List<String> this$allowReferers = this.getAllowReferers();
        List<String> other$allowReferers = other.getAllowReferers();
        if (this$allowReferers == null ? other$allowReferers != null : !((Object)this$allowReferers).equals(other$allowReferers)) {
            return false;
        }
        List<String> this$whiteList = this.getWhiteList();
        List<String> other$whiteList = other.getWhiteList();
        if (this$whiteList == null ? other$whiteList != null : !((Object)this$whiteList).equals(other$whiteList)) {
            return false;
        }
        List<String> this$blackList = this.getBlackList();
        List<String> other$blackList = other.getBlackList();
        return !(this$blackList == null ? other$blackList != null : !((Object)this$blackList).equals(other$blackList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileManageConfigPropertiesBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tmpPath = this.getTmpPath();
        result = result * 59 + ($tmpPath == null ? 43 : $tmpPath.hashCode());
        String $uploadType = this.getUploadType();
        result = result * 59 + ($uploadType == null ? 43 : $uploadType.hashCode());
        String $localPath = this.getLocalPath();
        result = result * 59 + ($localPath == null ? 43 : $localPath.hashCode());
        String $accessUrlPrefix = this.getAccessUrlPrefix();
        result = result * 59 + ($accessUrlPrefix == null ? 43 : $accessUrlPrefix.hashCode());
        List<String> $allowReferers = this.getAllowReferers();
        result = result * 59 + ($allowReferers == null ? 43 : ((Object)$allowReferers).hashCode());
        List<String> $whiteList = this.getWhiteList();
        result = result * 59 + ($whiteList == null ? 43 : ((Object)$whiteList).hashCode());
        List<String> $blackList = this.getBlackList();
        result = result * 59 + ($blackList == null ? 43 : ((Object)$blackList).hashCode());
        return result;
    }

    public String toString() {
        return "FileManageConfigPropertiesBean(tmpPath=" + this.getTmpPath() + ", uploadType=" + this.getUploadType() + ", localPath=" + this.getLocalPath() + ", accessUrlPrefix=" + this.getAccessUrlPrefix() + ", allowReferers=" + this.getAllowReferers() + ", whiteList=" + this.getWhiteList() + ", blackList=" + this.getBlackList() + ")";
    }
}

