/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="nicc-im.config")
public class NiccImConfigPropertiesBean {
    private Long heartbeatRate = 10000L;
    private Long heartbeatThreshold = 60000L;
    private String wsAddr;
    private Boolean authEnable = false;
    private Boolean chatSilentEnable = true;
    private String autoAnswerType = "dubbo";
    private String autoAnswerWhen = "post_after";
    private String chatSilentLevel = "120";
    private List<Integer> silentsLevels = Lists.newArrayList();

    public Integer getSilentLevel(long msgTimeout) {
        if (!this.silentsLevels.isEmpty()) {
            for (int i = 0; i < this.silentsLevels.size(); ++i) {
                if (!(i + 1 < this.silentsLevels.size() ? (long)(this.silentsLevels.get(i) * 1000) <= msgTimeout && msgTimeout < (long)(this.silentsLevels.get(i + 1) * 1000) : msgTimeout >= (long)(this.silentsLevels.get(i) * 1000))) continue;
                return this.silentsLevels.get(i);
            }
        }
        return 0;
    }

    public void setChatSilentLevel(String chatSilentLevel) {
        this.chatSilentLevel = chatSilentLevel;
        if (chatSilentLevel != null) {
            ArrayList levels = Lists.newArrayList();
            List<String> arr = Arrays.asList(chatSilentLevel.split(","));
            for (String s : arr) {
                levels.add(Integer.valueOf(s));
            }
            this.silentsLevels = levels;
        }
    }

    public Long getHeartbeatRate() {
        return this.heartbeatRate;
    }

    public Long getHeartbeatThreshold() {
        return this.heartbeatThreshold;
    }

    public String getWsAddr() {
        return this.wsAddr;
    }

    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    public Boolean getChatSilentEnable() {
        return this.chatSilentEnable;
    }

    public String getAutoAnswerType() {
        return this.autoAnswerType;
    }

    public String getAutoAnswerWhen() {
        return this.autoAnswerWhen;
    }

    public String getChatSilentLevel() {
        return this.chatSilentLevel;
    }

    public List<Integer> getSilentsLevels() {
        return this.silentsLevels;
    }

    public void setHeartbeatRate(Long heartbeatRate) {
        this.heartbeatRate = heartbeatRate;
    }

    public void setHeartbeatThreshold(Long heartbeatThreshold) {
        this.heartbeatThreshold = heartbeatThreshold;
    }

    public void setWsAddr(String wsAddr) {
        this.wsAddr = wsAddr;
    }

    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    public void setChatSilentEnable(Boolean chatSilentEnable) {
        this.chatSilentEnable = chatSilentEnable;
    }

    public void setAutoAnswerType(String autoAnswerType) {
        this.autoAnswerType = autoAnswerType;
    }

    public void setAutoAnswerWhen(String autoAnswerWhen) {
        this.autoAnswerWhen = autoAnswerWhen;
    }

    public void setSilentsLevels(List<Integer> silentsLevels) {
        this.silentsLevels = silentsLevels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NiccImConfigPropertiesBean)) {
            return false;
        }
        NiccImConfigPropertiesBean other = (NiccImConfigPropertiesBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$heartbeatRate = this.getHeartbeatRate();
        Long other$heartbeatRate = other.getHeartbeatRate();
        if (this$heartbeatRate == null ? other$heartbeatRate != null : !((Object)this$heartbeatRate).equals(other$heartbeatRate)) {
            return false;
        }
        Long this$heartbeatThreshold = this.getHeartbeatThreshold();
        Long other$heartbeatThreshold = other.getHeartbeatThreshold();
        if (this$heartbeatThreshold == null ? other$heartbeatThreshold != null : !((Object)this$heartbeatThreshold).equals(other$heartbeatThreshold)) {
            return false;
        }
        String this$wsAddr = this.getWsAddr();
        String other$wsAddr = other.getWsAddr();
        if (this$wsAddr == null ? other$wsAddr != null : !this$wsAddr.equals(other$wsAddr)) {
            return false;
        }
        Boolean this$authEnable = this.getAuthEnable();
        Boolean other$authEnable = other.getAuthEnable();
        if (this$authEnable == null ? other$authEnable != null : !((Object)this$authEnable).equals(other$authEnable)) {
            return false;
        }
        Boolean this$chatSilentEnable = this.getChatSilentEnable();
        Boolean other$chatSilentEnable = other.getChatSilentEnable();
        if (this$chatSilentEnable == null ? other$chatSilentEnable != null : !((Object)this$chatSilentEnable).equals(other$chatSilentEnable)) {
            return false;
        }
        String this$autoAnswerType = this.getAutoAnswerType();
        String other$autoAnswerType = other.getAutoAnswerType();
        if (this$autoAnswerType == null ? other$autoAnswerType != null : !this$autoAnswerType.equals(other$autoAnswerType)) {
            return false;
        }
        String this$autoAnswerWhen = this.getAutoAnswerWhen();
        String other$autoAnswerWhen = other.getAutoAnswerWhen();
        if (this$autoAnswerWhen == null ? other$autoAnswerWhen != null : !this$autoAnswerWhen.equals(other$autoAnswerWhen)) {
            return false;
        }
        String this$chatSilentLevel = this.getChatSilentLevel();
        String other$chatSilentLevel = other.getChatSilentLevel();
        if (this$chatSilentLevel == null ? other$chatSilentLevel != null : !this$chatSilentLevel.equals(other$chatSilentLevel)) {
            return false;
        }
        List<Integer> this$silentsLevels = this.getSilentsLevels();
        List<Integer> other$silentsLevels = other.getSilentsLevels();
        return !(this$silentsLevels == null ? other$silentsLevels != null : !((Object)this$silentsLevels).equals(other$silentsLevels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NiccImConfigPropertiesBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $heartbeatRate = this.getHeartbeatRate();
        result = result * 59 + ($heartbeatRate == null ? 43 : ((Object)$heartbeatRate).hashCode());
        Long $heartbeatThreshold = this.getHeartbeatThreshold();
        result = result * 59 + ($heartbeatThreshold == null ? 43 : ((Object)$heartbeatThreshold).hashCode());
        String $wsAddr = this.getWsAddr();
        result = result * 59 + ($wsAddr == null ? 43 : $wsAddr.hashCode());
        Boolean $authEnable = this.getAuthEnable();
        result = result * 59 + ($authEnable == null ? 43 : ((Object)$authEnable).hashCode());
        Boolean $chatSilentEnable = this.getChatSilentEnable();
        result = result * 59 + ($chatSilentEnable == null ? 43 : ((Object)$chatSilentEnable).hashCode());
        String $autoAnswerType = this.getAutoAnswerType();
        result = result * 59 + ($autoAnswerType == null ? 43 : $autoAnswerType.hashCode());
        String $autoAnswerWhen = this.getAutoAnswerWhen();
        result = result * 59 + ($autoAnswerWhen == null ? 43 : $autoAnswerWhen.hashCode());
        String $chatSilentLevel = this.getChatSilentLevel();
        result = result * 59 + ($chatSilentLevel == null ? 43 : $chatSilentLevel.hashCode());
        List<Integer> $silentsLevels = this.getSilentsLevels();
        result = result * 59 + ($silentsLevels == null ? 43 : ((Object)$silentsLevels).hashCode());
        return result;
    }

    public String toString() {
        return "NiccImConfigPropertiesBean(heartbeatRate=" + this.getHeartbeatRate() + ", heartbeatThreshold=" + this.getHeartbeatThreshold() + ", wsAddr=" + this.getWsAddr() + ", authEnable=" + this.getAuthEnable() + ", chatSilentEnable=" + this.getChatSilentEnable() + ", autoAnswerType=" + this.getAutoAnswerType() + ", autoAnswerWhen=" + this.getAutoAnswerWhen() + ", chatSilentLevel=" + this.getChatSilentLevel() + ", silentsLevels=" + this.getSilentsLevels() + ")";
    }
}

