/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.config.filter;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.im.config.FileManageConfigPropertiesBean;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;

@WebFilter(filterName="fileAccessFilter", urlPatterns={"/im-files/*"})
@Order(value=1)
public class FileAccessFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FileAccessFilter.class);
    @Resource
    private FileManageConfigPropertiesBean fileManageConfigPropertiesBean;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String client = request.getRemoteHost();
        String requestUri = request.getRequestURI();
        log.debug("FileAccessFilter requestUri = {}", (Object)requestUri);
        String referer = request.getHeader("referer");
        if (!this.fileManageConfigPropertiesBean.matchReferes(referer)) {
            log.warn("Access denied : \u7981\u6b62\u5916\u94fe\u8bbf\u95ee  , referer = {}", (Object)referer);
            this.authError(response, "Access denied!");
            return;
        }
        if (!this.fileManageConfigPropertiesBean.matchWhiteIp(client)) {
            log.warn("Access denied : ip\u4e0d\u5728\u767d\u540d\u5355\u5185  , client = {}", (Object)client);
            this.authError(response, "Access denied!");
            return;
        }
        if (this.fileManageConfigPropertiesBean.matchBlackIp(client)) {
            log.warn("Access denied : ip\u5728\u9ed1\u540d\u5355\u5185  , client = {}", (Object)client);
            this.authError(response, "Access denied!");
            return;
        }
        chain.doFilter(req, res);
    }

    private void authError(HttpServletResponse response, String msg) {
        Rsp rsp = BaseRspUtils.createErrorRsp((String)"9999", (String)msg);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write(JSONObject.toJSONString((Object)rsp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

