/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.config.proxy;

import com.tydic.nicc.im.config.proxy.ServletProxyConfig;
import com.tydic.nicc.im.config.proxy.ServletProxyConfigBean;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.mitre.dsmiley.httpproxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.stereotype.Component;

@Component
public class InitServletProxy
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(InitServletProxy.class);
    @Resource
    private ServletProxyConfig servletProxyConfig;

    public void onStartup(ServletContext servletContext) {
        if (this.servletProxyConfig.getServlets() != null && !this.servletProxyConfig.getServlets().isEmpty()) {
            log.info("\u52a0\u8f7dservlet\u4ee3\u7406\u914d\u7f6e:{}", (Object)this.servletProxyConfig);
            for (ServletProxyConfigBean servlet : this.servletProxyConfig.getServlets()) {
                LinkedHashMap<String, String> initParameters = new LinkedHashMap<String, String>();
                initParameters.put("targetUri", servlet.getProxyUrl());
                initParameters.put("log", String.valueOf(this.servletProxyConfig.getPrintLog()));
                ServletRegistration.Dynamic registration = servletContext.addServlet(servlet.getName(), (Servlet)new ProxyServlet());
                registration.addMapping(new String[]{servlet.getMapping()});
                registration.setInitParameters(initParameters);
                log.info("\u6ce8\u518c Servlet\u62e6\u622a\u5668\u4ee3\u7406:{},{} -> {}", new Object[]{servlet.getProxyDesc(), servlet.getMapping(), servlet.getProxyUrl()});
            }
        }
    }
}

