/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.im.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.im.core.LastMessageRspBO;
import com.tydic.nicc.common.eums.MsgChatTypeField;
import com.tydic.nicc.common.eums.MsgEventTypeField;
import com.tydic.nicc.common.eums.MsgFromInTypeField;
import com.tydic.nicc.common.eums.MsgTypeField;
import com.tydic.nicc.common.msg.ImAlertMessageBody;
import com.tydic.nicc.common.msg.ImEventMessageBody;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImMessageCommon;
import com.tydic.nicc.common.msg.ImReceiptMessageBody;
import com.tydic.nicc.common.msg.ImSysMessageBody;
import com.tydic.nicc.common.msg.ImUserMessageBody;
import com.tydic.nicc.common.msg.event.EventMsgContent;
import com.tydic.nicc.common.msg.event.EventMsgRead;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.im.exception.ImMsgParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImMessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(ImMessageBuilder.class);

    public static ImMessage buildLastUserMessage(LastMessageRspBO lastMessageRspBO, String sessionId) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(MsgTypeField.USER.getCode());
        message.setMsgTime(Long.valueOf(lastMessageRspBO.getMsgTime().getTime()));
        message.setMsgId(lastMessageRspBO.getMsgId());
        message.setFromNo(lastMessageRspBO.getFromNo());
        message.setFromInType("0");
        message.setToNo(lastMessageRspBO.getFromNo());
        message.setChatType(lastMessageRspBO.getChatType());
        message.setSessionId(sessionId);
        try {
            ImUserMessageBody userMessageBody = new ImUserMessageBody();
            userMessageBody.setMsgForm(lastMessageRspBO.getMsgForm());
            userMessageBody.setMsgContent(lastMessageRspBO.getMsgContent());
            message.setMsgBody((ImMessageBody)userMessageBody);
            return message;
        }
        catch (JSONException e) {
            log.error("\u7528\u6237\u6d88\u606f\u6784\u5efa\u9519\u8bef:", (Throwable)e);
            return message;
        }
    }

    public static ImMessage buildUserMessage(ImMessage from, String chatType, String code, String status) {
        ImMessage receipt = ImMessageBuilder.buildBlankMessage(MsgTypeField.USER.getCode());
        receipt.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        receipt.setMsgId(IdWorker.nextAutoIdStr());
        receipt.setFromNo(from.getToNo());
        receipt.setToNo(from.getFromNo());
        receipt.setChatType(chatType);
        receipt.setSessionId(from.getSessionId());
        ImReceiptMessageBody receiptMessageBody = (ImReceiptMessageBody)receipt.getMsgBody();
        receiptMessageBody.setCode(code);
        receiptMessageBody.setStatus(status);
        receipt.setMsgBody((ImMessageBody)receiptMessageBody);
        return receipt;
    }

    public static ImMessage buildReceiptMessage(ImMessage from, String imMsgId, String code, String status) {
        ImMessage receipt = ImMessageBuilder.buildBlankMessage(MsgTypeField.RECEIPT.getCode());
        receipt.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        receipt.setMsgId(from.getMsgId());
        receipt.setFromNo(from.getToNo());
        receipt.setToNo(from.getFromNo());
        receipt.setChatType(MsgChatTypeField.SYSTEM.getCode());
        receipt.setSessionId(from.getSessionId());
        ImReceiptMessageBody receiptMessageBody = (ImReceiptMessageBody)receipt.getMsgBody();
        receiptMessageBody.setCode(code);
        receiptMessageBody.setStatus(status);
        receiptMessageBody.setMsgId(imMsgId);
        receipt.setMsgBody((ImMessageBody)receiptMessageBody);
        return receipt;
    }

    public static ImMessage buildEventMessageReadByReceiptMsg(ImMessage from) {
        ImMessage event = ImMessageBuilder.buildBlankMessage(MsgTypeField.EVENT.getCode());
        event.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        event.setMsgId(IdWorker.nextAutoIdStr());
        event.setFromNo(from.getFromNo());
        event.setToNo(from.getToNo());
        event.setChatType(from.getChatType());
        event.setSessionId(from.getSessionId());
        ImEventMessageBody eventMessageBody = (ImEventMessageBody)event.getMsgBody();
        eventMessageBody.setEventType(MsgEventTypeField.MSG_READ.getCode());
        eventMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        eventMessageBody.setEventContent(new EventMsgContent());
        EventMsgRead msgRead = new EventMsgRead();
        msgRead.setMsgId(from.getMsgId());
        msgRead.setTimestamp(from.getMsgTime());
        msgRead.setUserId(from.getFromNo());
        eventMessageBody.getEventContent().setMsgRead(msgRead);
        return event;
    }

    public static ImMessage buildBlankMessage(String msgType) {
        ImMessage imMessage = new ImMessage();
        imMessage.setMsgType(msgType);
        ImUserMessageBody messageBody = null;
        if (MsgTypeField.USER.getCode().equals(msgType)) {
            messageBody = new ImUserMessageBody();
        }
        if (MsgTypeField.ALERT.getCode().equals(msgType)) {
            messageBody = new ImAlertMessageBody();
        }
        if (MsgTypeField.EVENT.getCode().equals(msgType)) {
            messageBody = new ImEventMessageBody();
        }
        if (MsgTypeField.SYSTEM.getCode().equals(msgType)) {
            messageBody = new ImSysMessageBody();
        }
        if (MsgTypeField.RECEIPT.getCode().equals(msgType)) {
            messageBody = new ImReceiptMessageBody();
        }
        imMessage.setMsgBody((ImMessageBody)messageBody);
        return imMessage;
    }

    public static ImMessage MessageParse(String msg) {
        try {
            ImMessage imMessage = new ImMessage();
            ImMessageCommon msgCommon = (ImMessageCommon)JSONObject.parseObject((String)msg, ImMessageCommon.class);
            if (msgCommon != null) {
                if (StringUtils.isEmpty((CharSequence)MsgTypeField.getNameByCode((String)msgCommon.getMsgType()))) {
                    throw new ImMsgParseException("\u6d88\u606f\u7c7b\u578b\u9519\u8bef:msgType = " + msgCommon.getMsgType());
                }
                if (StringUtils.isEmpty((CharSequence)MsgFromInTypeField.getNameByCode((String)msgCommon.getFromInType()))) {
                    throw new ImMsgParseException("\u6d88\u606f\u63a5\u5165\u65b9\u5f0f\u9519\u8bef:fromInType = " + msgCommon.getFromInType());
                }
                if (StringUtils.isEmpty((CharSequence)MsgChatTypeField.getNameByCode((String)msgCommon.getChatType()))) {
                    throw new ImMsgParseException("\u804a\u5929\u7c7b\u578b\u9519\u8bef:chatType = " + msgCommon.getChatType());
                }
                if (msgCommon.getMsgTime() == null) {
                    throw new ImMsgParseException("\u5b57\u6bb5 msgTime \u4e3a\u7a7a!");
                }
                if (msgCommon.getFromNo() == null) {
                    throw new ImMsgParseException("\u5b57\u6bb5 fromNo \u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)msgCommon.getMsgId())) {
                    throw new ImMsgParseException("\u5b57\u6bb5 msgId \u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)msgCommon.getToNo())) {
                    throw new ImMsgParseException("\u5b57\u6bb5 toNo \u4e3a\u7a7a!");
                }
                if (msgCommon.getMsgBody() == null) {
                    throw new ImMsgParseException("\u5b57\u6bb5 msgBody \u4e3a\u7a7a!");
                }
                ImMessageBody messageBody = null;
                try {
                    if (MsgTypeField.USER.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImUserMessageBody.class);
                    }
                    if (MsgTypeField.ALERT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImAlertMessageBody.class);
                    }
                    if (MsgTypeField.EVENT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImEventMessageBody.class);
                    }
                    if (MsgTypeField.SYSTEM.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImSysMessageBody.class);
                    }
                    if (MsgTypeField.RECEIPT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImReceiptMessageBody.class);
                    }
                    imMessage.setMsgId(msgCommon.getMsgId());
                    imMessage.setSessionId(msgCommon.getSessionId());
                    imMessage.setMsgType(msgCommon.getMsgType());
                    imMessage.setChatType(msgCommon.getChatType());
                    imMessage.setFromNo(msgCommon.getFromNo());
                    imMessage.setFromInType(msgCommon.getFromInType());
                    imMessage.setMsgTime(msgCommon.getMsgTime());
                    imMessage.setToNo(msgCommon.getToNo());
                    imMessage.setMsgBody(messageBody);
                }
                catch (JSONException e) {
                    throw new ImMsgParseException("\u6d88\u606f\u4f53\u89e3\u6790\u9519\u8bef:" + e.getMessage());
                }
                if (messageBody == null) {
                    throw new ImMsgParseException("\u6d88\u606f\u4f53\u4e0d\u5f97\u4e3a\u7a7a!");
                }
                return imMessage;
            }
            throw new ImMsgParseException("\u6d88\u606f\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        catch (JSONException e) {
            log.info("\u6d88\u606f\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage());
            throw new ImMsgParseException("\u6d88\u606f\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
    }
}

