/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.pipeline;

import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.GoodsDetailsMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.SpiderLogMapper;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetails;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.mapper.po.SpiderLogPO;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;

@Component
public class GoodsDetailPipeline
implements Pipeline {
    private static final Logger log = LoggerFactory.getLogger(GoodsDetailPipeline.class);
    @Resource
    private GoodsDetailsMapper goodsDetailsMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private SpiderLogMapper spiderLogMapper;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(ResultItems resultItems, Task task) {
        HashMap hashMap = (HashMap)resultItems.get("map");
        if (hashMap.size() > 0) {
            Goods goods = (Goods)hashMap.get("goods");
            Object keyword = hashMap.get("keyword");
            GoodsDetailsWithBLOBs goodsDetails = (GoodsDetailsWithBLOBs)hashMap.get("goodsDetails");
            if (goods != null) {
                Goods good = this.goodsMapper.selectByPrimaryKey(goods);
                if (good != null) {
                    goods.setGoodId(good.getGoodId());
                    goods.setUpdated(new Date());
                    this.goodsMapper.updateByPrimaryKeySelective(goods);
                } else {
                    goods.setCreated(new Date());
                    goods.setUpdated(new Date());
                    if (StringUtils.isEmpty((CharSequence)goods.getCategoryId())) {
                        goods.setCategoryId("0");
                    }
                    this.goodsMapper.insertSelective(goods);
                }
                this.processDataPipeline.inserPriceInfo(goods, good);
            } else {
                log.info("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
            }
            if (goodsDetails != null) {
                if (goodsDetails.getSkuAttrNames() != null && goodsDetails.getGoodsNo() != null) {
                    if (this.goodsDetailsMapper.selectByPrimaryKey((GoodsDetails)goodsDetails) == null) {
                        goodsDetails.setCreated(new Date());
                        goodsDetails.setUpdated(new Date());
                        this.goodsDetailsMapper.insertSelective(goodsDetails);
                    } else {
                        goodsDetails.setUpdated(new Date());
                        this.goodsDetailsMapper.updateByPrimaryKeySelective(goodsDetails);
                    }
                } else {
                    log.info("\u5546\u54c1\u8be6\u60c5\u4e3a\u7a7a");
                }
                SpiderLogPO logPO = new SpiderLogPO();
                logPO.setSign(goods.getPrefix());
                logPO.setCategoryId(goods.getCategoryId());
                logPO.setGoodsNo(goods.getGoodsNo());
                logPO.setIsDelete(Integer.valueOf(0));
                logPO.setCreateTime(new Date());
                logPO.setSkuId(goods.getSkuId());
                logPO.setNum(Integer.valueOf(1));
                if (keyword != null) {
                    logPO.setGoodsNo(keyword.toString());
                    logPO.setSpiderType("4");
                } else {
                    logPO.setSpiderType("3");
                }
                logPO.setExecutionNumber(goods.getExecutionNumber());
                logPO.setPrice(goods.getPrice());
                this.spiderLogMapper.insertSelective(logPO);
            } else {
                log.info("\u5546\u54c1\u8be6\u60c5\u5217\u8868\u4e3a\u7a7a");
            }
        } else {
            log.info("\u5546\u54c1\u8be6\u60c5\u5217\u8868\u548c\u5546\u54c1\u5217\u8868\u5747\u4e3a\u7a7a");
        }
    }
}

