/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.pipeline;

import com.tydic.nicc.spider.compoent.eum.MallCommentState;
import com.tydic.nicc.spider.mapper.GoodsCommentMapper;
import com.tydic.nicc.spider.mapper.GoodsDetailsMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.PriceMapper;
import com.tydic.nicc.spider.mapper.SpiderLogMapper;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsCommentPO;
import com.tydic.nicc.spider.mapper.po.GoodsDetails;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.mapper.po.PricePO;
import com.tydic.nicc.spider.mapper.po.SpiderLogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessDataPipeline {
    private static final Logger log = LoggerFactory.getLogger(ProcessDataPipeline.class);
    @Resource
    GoodsMapper goodsMapper;
    @Resource
    GoodsDetailsMapper goodsDetailsMapper;
    @Resource
    private SpiderLogMapper spiderLogMapper;
    @Resource
    private GoodsCommentMapper commentMapper;
    @Resource
    private PriceMapper priceMapper;

    public void processDataMap(Map<String, Object> map) {
        try {
            if (!Objects.isNull(map)) {
                List goodsList = (List)map.get("goodsList");
                ArrayList updateGoodsList = new ArrayList();
                ArrayList insertGoodsList = new ArrayList();
                List goodsDetailsWithBLOBsList = (List)map.get("goodsDetailsList");
                Object keyword = map.get("keyword");
                if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                    goodsList = goodsList.stream().filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Goods>(Comparator.comparing(Goods::getGoodsNo))), ArrayList::new));
                    goodsList.forEach(goods -> {
                        if (goods.getGoodsNo() != null) {
                            Goods good1 = this.goodsMapper.selectByPrimaryKey(goods);
                            if (good1 != null) {
                                goods.setUpdated(new Date());
                                goods.setGoodId(good1.getGoodId());
                                this.goodsMapper.updateByPrimaryKeySelective(goods);
                            } else {
                                goods.setCreated(new Date());
                                goods.setUpdated(new Date());
                                if (StringUtils.isEmpty((CharSequence)goods.getCategoryId())) {
                                    goods.setCategoryId("0");
                                }
                                this.goodsMapper.insertSelective(goods);
                            }
                            this.inserPriceInfo((Goods)goods, good1);
                        } else {
                            log.info("\u5546\u54c1\u7f16\u53f7\u4e3a\u7a7a");
                        }
                    });
                } else {
                    log.info("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
                }
                if (CollectionUtils.isNotEmpty((Collection)goodsDetailsWithBLOBsList)) {
                    goodsDetailsWithBLOBsList = goodsDetailsWithBLOBsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GoodsDetailsWithBLOBs>(Comparator.comparing(GoodsDetails::getGoodsNo))), ArrayList::new));
                    log.info("\u8be6\u60c5\u53bb\u91cd\u540e\u6761\u6570:" + goodsDetailsWithBLOBsList.size());
                    ArrayList updateList = new ArrayList();
                    ArrayList insertList = new ArrayList();
                    goodsDetailsWithBLOBsList.forEach(goodsDetailsWithBLOBs -> {
                        if (goodsDetailsWithBLOBs.getSkuAttrNames() != null && goodsDetailsWithBLOBs.getGoodsNo() != null) {
                            if (this.goodsDetailsMapper.selectByPrimaryKey((GoodsDetails)goodsDetailsWithBLOBs) == null) {
                                goodsDetailsWithBLOBs.setCreated(new Date());
                                goodsDetailsWithBLOBs.setUpdated(new Date());
                                this.goodsDetailsMapper.insertSelective(goodsDetailsWithBLOBs);
                            } else {
                                goodsDetailsWithBLOBs.setUpdated(new Date());
                                this.goodsDetailsMapper.updateByPrimaryKeySelective(goodsDetailsWithBLOBs);
                            }
                        } else {
                            log.info("\u5546\u54c1\u8be6\u60c5\u4e3a\u7a7a");
                        }
                    });
                    SpiderLogPO logPO = new SpiderLogPO();
                    logPO.setSign(((Goods)goodsList.get(0)).getPrefix());
                    logPO.setCategoryId(((Goods)goodsList.get(0)).getCategoryId());
                    logPO.setGoodsNo(((Goods)goodsList.get(0)).getGoodsNo());
                    logPO.setIsDelete(Integer.valueOf(0));
                    logPO.setCreateTime(new Date());
                    logPO.setSkuId(((Goods)goodsList.get(0)).getSkuId());
                    if (keyword != null) {
                        logPO.setGoodsNo(keyword.toString());
                        logPO.setSpiderType("4");
                    } else {
                        logPO.setSpiderType("3");
                    }
                    logPO.setNum(Integer.valueOf(goodsList.size()));
                    logPO.setExecutionNumber(((Goods)goodsList.get(0)).getExecutionNumber());
                    logPO.setPrice(((Goods)goodsList.get(0)).getPrice());
                    this.spiderLogMapper.insertSelective(logPO);
                } else {
                    log.info("\u5546\u54c1\u8be6\u60c5\u5217\u8868\u4e3a\u7a7a");
                }
            }
        }
        catch (Exception e) {
            log.error("processDataMap() is error", (Throwable)e);
            throw e;
        }
    }

    public void processDataList(List<Goods> goodsList, int currentPage, int totalPage, String keyword) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList = goodsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Goods>(Comparator.comparing(Goods::getGoodsNo))), ArrayList::new));
            log.info("\u6839\u636e\u5546\u54c1goosNo\u53bb\u91cd\u5b9e\u9645\u5b58\u50a8{}\u6761\u6570\u636e", (Object)goodsList.size());
            ArrayList updateList = new ArrayList();
            goodsList.forEach(good -> {
                String goodsNo = good.getGoodsNo();
                if (StringUtils.isNotEmpty((CharSequence)goodsNo)) {
                    try {
                        if (good == null) return;
                        Goods goods = this.goodsMapper.selectByPrimaryKey(good);
                        if (Objects.isNull(goods)) {
                            good.setUpdated(new Date());
                            good.setCreated(new Date());
                            if (StringUtils.isEmpty((CharSequence)good.getCategoryId())) {
                                good.setCategoryId("0");
                            }
                            this.goodsMapper.insertSelective(good);
                        } else {
                            good.setGoodId(goods.getGoodId());
                            good.setUpdated(new Date());
                            this.goodsMapper.updateByPrimaryKeySelective(good);
                        }
                        this.inserPriceInfo((Goods)good, goods);
                        return;
                    }
                    catch (Exception e) {
                        log.error("ProcessDataPipeline : goodsMapper update or insert {} is error", (Object)goodsNo);
                        log.error("{}", (Throwable)e);
                        throw e;
                    }
                } else {
                    log.info("ProcessDataPipeline :goodsMapper update or insert goodsNo is null");
                }
            });
            SpiderLogPO logPO = new SpiderLogPO();
            logPO.setSign(((Goods)goodsList.get(0)).getPrefix());
            logPO.setCategoryId(((Goods)goodsList.get(0)).getCategoryId());
            logPO.setIsDelete(Integer.valueOf(0));
            logPO.setCreateTime(new Date());
            logPO.setCurrentPage(Integer.valueOf(currentPage));
            logPO.setTotalPage(Integer.valueOf(totalPage));
            logPO.setGoodsNo(keyword);
            logPO.setSkuId(((Goods)goodsList.get(0)).getSkuId());
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                logPO.setSpiderType("4");
            } else {
                logPO.setSpiderType("2");
            }
            logPO.setNum(Integer.valueOf(goodsList.size()));
            logPO.setExecutionNumber(((Goods)goodsList.get(0)).getExecutionNumber());
            this.spiderLogMapper.insertSelective(logPO);
        } else {
            log.info("ProcessDataPipeline :goodsList is Empty");
        }
    }

    public void processDataList(List<GoodsCommentPO> goodsCommentList) {
        if (CollectionUtils.isNotEmpty(goodsCommentList)) {
            goodsCommentList = goodsCommentList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GoodsCommentPO>(Comparator.comparing(GoodsCommentPO::getCommentId))), ArrayList::new));
            ArrayList updateList = new ArrayList();
            ArrayList insertList = new ArrayList();
            Long goodId = Long.parseLong(((GoodsCommentPO)goodsCommentList.get(0)).getGoodsNo());
            String prefix = ((GoodsCommentPO)goodsCommentList.get(0)).getPrefix();
            String tableName = prefix + "_goods_comment";
            if (MallCommentState.getStateByCode(prefix).equals("1")) {
                Long num = goodId % 10L;
                tableName = prefix + "_goods_comment_" + num;
            }
            String finalTableName = tableName;
            goodsCommentList.forEach(comment -> {
                String commentId = comment.getCommentId();
                String goodsNo = comment.getGoodsNo();
                if (commentId != null && StringUtils.isNotEmpty((CharSequence)goodsNo)) {
                    try {
                        if (this.commentMapper.selectCountBycommentId(commentId, finalTableName) == 0) {
                            insertList.add(comment);
                        }
                        updateList.add(comment);
                    }
                    catch (Exception e) {
                        log.error("ProcessDataPipeline :  update or insert {} is error", (Object)goodsNo, (Object)e);
                        throw e;
                    }
                } else {
                    log.info("ProcessDataPipeline : update or insert goodsNo is null");
                }
            });
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.commentMapper.updateBatchBy(updateList, tableName);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.commentMapper.insertBatch(insertList, tableName);
            }
        } else {
            log.info("ProcessDataPipeline :goodsCommentList is Empty");
        }
    }

    public void inserPriceInfo(Goods good, Goods good1) {
        PricePO pricePO = new PricePO();
        pricePO.setGoodsNo(good.getGoodsNo());
        pricePO.setSkuId(good.getSkuId());
        pricePO.setPrefix(good.getPrefix());
        if (good1 != null && good1.getPrice() != null && good1.getPrice().intValue() > 0) {
            pricePO.setPrevChangeTime(good1.getUpdated());
            pricePO.setPrevPriceValue(good1.getPrice().toString());
        }
        pricePO.setPriceType("sales");
        pricePO.setPriceValue(good.getPrice());
        pricePO.setChangeTime(new Date());
        if (good.getPrice() != null && good.getPrice().toString().equals("0")) {
            pricePO.setIsValid(Integer.valueOf(0));
        } else {
            pricePO.setIsValid(Integer.valueOf(1));
        }
        pricePO.setExeNumber(good.getExecutionNumber());
        this.priceMapper.insertSelective(pricePO);
    }
}

