/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.category;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.pipeline.CategoryTempPipeline;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.ChineseCharactersUtils;
import com.tydic.nicc.spider.config.util.TempUtil;
import com.tydic.nicc.spider.mapper.DcDataSourceInfoMapper;
import com.tydic.nicc.spider.mapper.DcStrategyInfoMapper;
import com.tydic.nicc.spider.mapper.DcTemplateInfoMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.DcDataSourceInfoPO;
import com.tydic.nicc.spider.mapper.po.DcStrategyInfo;
import com.tydic.nicc.spider.mapper.po.DcTemplateInfoPOWithBLOBs;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class CategoryTempProcessor {
    private static final Logger log = LoggerFactory.getLogger(CategoryTempProcessor.class);
    @Autowired
    private DcTemplateInfoMapper dcTemplateInfoMapper;
    @Autowired
    private DcDataSourceInfoMapper dcDataSourceInfoMapper;
    @Autowired
    private CategoryTempPipeline categoryTempPipeline;
    @Autowired
    private DcStrategyInfoMapper dcStrategyInfoMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void categoryProcess(String mall) {
        try {
            DcTemplateInfoPOWithBLOBs templateInfo = this.dcTemplateInfoMapper.selectBySource(mall, Integer.valueOf(1));
            ArrayList<CategoryPO> categoryPOList = new ArrayList<CategoryPO>();
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> param = new HashMap<String, String>();
            if (templateInfo == null) return;
            DcDataSourceInfoPO infoPO = this.dcDataSourceInfoMapper.selectBySign(mall);
            DcStrategyInfo strategyInfo = this.dcStrategyInfoMapper.selectByMall(mall, Integer.valueOf(1));
            param.put("dataSourceUrl", infoPO.getUrl());
            if (StringUtils.isNotEmpty((CharSequence)templateInfo.getAttributeInfo())) {
                List list = (List)mapper.readValue(templateInfo.getAttributeInfo(), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
                for (Map map : list) {
                    if (((String)map.get("code")).equals("categoryList")) {
                        String categoryList = (String)map.get("value");
                        param.put("categoryList", categoryList);
                    }
                    if (((String)map.get("code")).equals("categoryId")) {
                        String categoryId = (String)map.get("value");
                        param.put("categoryId", categoryId);
                    }
                    if (((String)map.get("code")).equals("categoryName")) {
                        String categoryName = (String)map.get("value");
                        param.put("categoryName", categoryName);
                    }
                    if (((String)map.get("code")).equals("pater")) {
                        String pater = (String)map.get("value");
                        param.put("pater", pater);
                    }
                    if (!((String)map.get("code")).equals("url")) continue;
                    String url = (String)map.get("value");
                    param.put("url", url);
                }
            }
            if (templateInfo.getCrawlingMode().equals("API")) {
                String result = TempUtil.requestHttpUrl(templateInfo, mapper, strategyInfo);
                if (result.equals("8888")) throw new DcBusinessException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:" + result);
                if (templateInfo.getResponseType().equals("JSON")) {
                    if (!TempUtil.detectJsonFormat(result).equals("JSON")) throw new DcBusinessException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:" + result);
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)param.get("pater")))) {
                        this.apiProcessor(result, categoryPOList, param, mall);
                    } else {
                        this.apiNewProcessor(result, categoryPOList, param, mall);
                    }
                } else if (templateInfo.getResponseType().equals("HTML")) {
                    Html html = new Html(result);
                    this.htmlProcess(html, categoryPOList, param, mall);
                }
            } else if (templateInfo.getCrawlingMode().equals("HTML")) {
                try {
                    Html html = this.startDriver(strategyInfo, templateInfo.getUrl(), infoPO, param);
                    if (html != null) {
                        this.htmlProcess(html, categoryPOList, param, mall);
                    }
                }
                catch (Exception e) {
                    log.info("\u722c\u53d6\u5f02\u5e38", (Throwable)e);
                    throw new DcBusinessException("\u722c\u53d6\u5f02\u5e38");
                }
            }
            if (!CollectionUtils.isNotEmpty(categoryPOList)) return;
            this.categoryTempPipeline.process(categoryPOList);
            return;
        }
        catch (Exception e) {
            log.error("\u722c\u53d6{}\u7c7b\u76ee\u5f02\u5e38", (Object)mall, (Object)e);
            throw new DcBusinessException("\u722c\u53d6{}\u7c7b\u76ee\u5f02\u5e38", mall);
        }
    }

    private void apiNewProcessor(String result, List<CategoryPO> categoryPOList, Map<String, String> param, String mall) {
        String[] cateList = param.get("categoryList").split(";");
        String[] ids = param.get("categoryId").split(";");
        String[] names = param.get("categoryName").split(";");
        String[] urls = param.get("url").split(";");
        String dataSourceUrl = param.get("dataSourceUrl");
        int num = cateList.length;
        List divs = new ArrayList();
        List divs2 = new ArrayList();
        ArrayList divs3 = new ArrayList();
        for (int j = 0; j < num - 1; ++j) {
            if (CollectionUtils.isNotEmpty(divs3)) {
                divs.clear();
                divs.addAll(divs3);
                divs3.clear();
            } else {
                divs = new JsonPathSelector(cateList[j]).selectList(result);
            }
            for (int i = 0; i < divs.size(); ++i) {
                String categoryId = "";
                String pater = "0";
                String categoryName = "";
                String url = "";
                String divStr = (String)divs.get(i);
                if (StringUtils.isNotEmpty((CharSequence)ids[j]) && divStr.contains(ids[j].replace("$.", ""))) {
                    categoryId = new JsonPathSelector(ids[j]).select(divStr);
                }
                if (j == 0) {
                    if (StringUtils.isNotEmpty((CharSequence)names[j]) && divStr.contains(names[j].replace("$.", ""))) {
                        categoryName = new JsonPathSelector(names[j]).select(divStr);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)urls[j]) && divStr.contains(urls[j].replace("$.", ""))) {
                        url = new JsonPathSelector(urls[j]).select(divStr);
                    } else {
                        List<String> placeholderNames = TempUtil.extractPlaceholderNames(urls[j]);
                        if (CollectionUtils.isNotEmpty(placeholderNames)) {
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            for (String placeholderName : placeholderNames) {
                                String value = "";
                                if (placeholderName.contains("categoryId")) {
                                    value = categoryId;
                                } else if (StringUtils.isEmpty((CharSequence)param.get(placeholderName))) {
                                    value = new JsonPathSelector("$." + placeholderName).select(divStr);
                                    placeholders.put(placeholderName, value);
                                }
                                placeholders.put(placeholderName, value);
                            }
                            url = TempUtil.replacePlaceholders(urls[j], placeholders);
                        }
                    }
                    CategoryPO categoryPO = new CategoryPO();
                    categoryPO.setCategoryId(categoryId);
                    categoryPO.setPater(pater);
                    categoryPO.setName(categoryName);
                    categoryPO.setUrl(url);
                    categoryPO.setLevel(Integer.valueOf(j + 1));
                    categoryPO.setSign(mall);
                    categoryPO.setCreatedTime(new Date());
                    categoryPOList.add(categoryPO);
                }
                divs2 = new JsonPathSelector(cateList[j + 1]).selectList(divStr);
                divs3.addAll(divs2);
                for (int n = 0; n < divs2.size(); ++n) {
                    String categoryId2 = "";
                    String pater2 = categoryId;
                    String categoryName2 = "";
                    String url2 = "";
                    String div2Str = (String)divs2.get(n);
                    if (StringUtils.isNotEmpty((CharSequence)ids[j + 1]) && div2Str.contains(ids[j + 1].replace("$.", ""))) {
                        categoryId2 = new JsonPathSelector(ids[j + 1]).select(div2Str);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)names[j + 1]) && div2Str.contains(names[j + 1].replace("$.", ""))) {
                        categoryName2 = new JsonPathSelector(names[j + 1]).select(div2Str);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)urls[j + 1]) && div2Str.contains(urls[j + 1].replace("$.", ""))) {
                        url2 = new JsonPathSelector(urls[j + 1]).select(div2Str);
                    } else {
                        List<String> placeholderNames = TempUtil.extractPlaceholderNames(urls[j + 1]);
                        if (CollectionUtils.isNotEmpty(placeholderNames)) {
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            for (String placeholderName : placeholderNames) {
                                String value = "";
                                if (placeholderName.equals("categoryId")) {
                                    value = categoryId2;
                                    placeholders.put(placeholderName, value);
                                }
                                if (placeholderName.equals("pater")) {
                                    value = categoryId;
                                    placeholders.put(placeholderName, value);
                                }
                                if (placeholderName.equals("pater2")) {
                                    for (CategoryPO categoryPO : categoryPOList) {
                                        if (!categoryPO.getCategoryId().equals(categoryId)) continue;
                                        value = categoryPO.getPater();
                                        break;
                                    }
                                    placeholders.put(placeholderName, value);
                                }
                                if (!StringUtils.isEmpty((CharSequence)param.get(placeholderName))) continue;
                                value = new JsonPathSelector("$." + placeholderName).select(div2Str);
                                placeholders.put(placeholderName, value);
                            }
                            url2 = TempUtil.replacePlaceholders(urls[j + 1], placeholders);
                        }
                    }
                    CategoryPO categoryPO2 = new CategoryPO();
                    categoryPO2.setCategoryId(categoryId2);
                    categoryPO2.setPater(pater2);
                    categoryPO2.setName(categoryName2);
                    categoryPO2.setUrl(url2);
                    categoryPO2.setLevel(Integer.valueOf(j + 2));
                    categoryPO2.setSign(mall);
                    categoryPO2.setCreatedTime(new Date());
                    categoryPOList.add(categoryPO2);
                }
            }
        }
    }

    private void apiProcessor(String result, List<CategoryPO> categoryPOList, Map<String, String> param, String mall) {
        String categoryList = param.get("categoryList");
        String categoryId = param.get("categoryId");
        String pater = param.get("pater");
        String categoryName = param.get("categoryName");
        String url = param.get("url");
        String[] cateList = categoryList.split(";");
        for (int i = 1; i < cateList.length + 1; ++i) {
            List list = new JsonPathSelector(cateList[i - 1]).selectList(result);
            for (int j = 0; j < list.size(); ++j) {
                String id = "";
                String pId = "";
                String name = "";
                String categoryUrl = "";
                String cateStr = (String)list.get(j);
                if (StringUtils.isNotEmpty((CharSequence)categoryId) && cateStr.contains(categoryId.replace("$.", ""))) {
                    id = new JsonPathSelector(categoryId).select(cateStr);
                }
                if (StringUtils.isNotEmpty((CharSequence)pater) && cateStr.contains(pater.replace("$.", ""))) {
                    pId = new JsonPathSelector(pater).select(cateStr);
                }
                if (StringUtils.isNotEmpty((CharSequence)categoryName) && cateStr.contains(categoryName.replace("$.", ""))) {
                    name = new JsonPathSelector(categoryName).select(cateStr);
                }
                if (StringUtils.isNotEmpty((CharSequence)url) && cateStr.contains(url.replace("$.", ""))) {
                    categoryUrl = new JsonPathSelector(url).select(cateStr);
                } else {
                    List<String> placeholderNames = TempUtil.extractPlaceholderNames(url);
                    if (CollectionUtils.isNotEmpty(placeholderNames)) {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        for (String placeholderName : placeholderNames) {
                            String value = "";
                            value = StringUtils.isNotEmpty((CharSequence)param.get(placeholderName)) ? new JsonPathSelector(param.get(placeholderName)).select(cateStr) : new JsonPathSelector("$." + placeholderName).select(cateStr);
                            placeholders.put(placeholderName, value);
                        }
                        categoryUrl = TempUtil.replacePlaceholders(url, placeholders);
                    }
                }
                CategoryPO categoryPO = new CategoryPO();
                categoryPO.setCategoryId(id);
                categoryPO.setPater(StringUtils.isNotEmpty((CharSequence)pId) ? pId : "0");
                categoryPO.setName(name);
                categoryPO.setUrl(categoryUrl);
                categoryPO.setLevel(Integer.valueOf(i));
                categoryPO.setSign(mall);
                categoryPO.setCreatedTime(new Date());
                categoryPOList.add(categoryPO);
            }
        }
    }

    private void htmlProcess(Html html, List<CategoryPO> categoryPOList, Map<String, String> param, String mall) {
        if (html != null) {
            String[] cateList = param.get("categoryList").split(";");
            String[] ids = param.get("categoryId").split(";");
            String[] names = param.get("categoryName").split(";");
            String[] urls = param.get("url").split(";");
            String dataSourceUrl = param.get("dataSourceUrl");
            int num = cateList.length;
            List divs = new ArrayList();
            List divs2 = new ArrayList();
            ArrayList divs3 = new ArrayList();
            for (int j = 0; j < num - 1; ++j) {
                if (CollectionUtils.isNotEmpty(divs3)) {
                    divs.clear();
                    divs.addAll(divs3);
                    divs3.clear();
                } else {
                    divs = html.$(cateList[j]).nodes();
                }
                for (int i = 0; i < divs.size(); ++i) {
                    String id = "";
                    Selectable divHtml = (Selectable)divs.get(i);
                    String name = TempUtil.getStr(divHtml, names[j]);
                    String categoryUrl = TempUtil.getStr(divHtml, urls[j]);
                    if (ids != null && ids.length > 2 && StringUtils.isNotEmpty((CharSequence)ids[j])) {
                        id = TempUtil.getStr(divHtml, ids[j]);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)categoryUrl)) {
                        categoryUrl = TempUtil.getUrl(dataSourceUrl, categoryUrl);
                        if (StringUtils.isEmpty((CharSequence)id)) {
                            id = ids.length > 2 ? TempUtil.extractValue(categoryUrl, ids[j]) : TempUtil.extractValue(categoryUrl, null);
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)id)) {
                        id = ChineseCharactersUtils.toPinyin(name);
                    }
                    if (j == 0) {
                        CategoryPO categoryPO = new CategoryPO();
                        categoryPO.setCategoryId(id);
                        categoryPO.setPater("0");
                        categoryPO.setName(name);
                        categoryPO.setUrl(categoryUrl);
                        categoryPO.setLevel(Integer.valueOf(j + 1));
                        categoryPO.setSign(mall);
                        categoryPO.setCreatedTime(new Date());
                        categoryPOList.add(categoryPO);
                    }
                    divs2 = divHtml.$(cateList[j + 1]).nodes();
                    divs3.addAll(divs2);
                    for (int n = 0; n < divs2.size(); ++n) {
                        Selectable divHtml2 = (Selectable)divs2.get(n);
                        String name2 = TempUtil.getStr(divHtml2, names[j + 1]);
                        String id2 = "";
                        String categoryUrl2 = TempUtil.getStr(divHtml2, urls[j + 1]);
                        if (ids != null && ids.length > 2 && StringUtils.isNotEmpty((CharSequence)ids[j + 1])) {
                            id2 = TempUtil.getStr(divHtml2, ids[j + 1]);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)categoryUrl2)) {
                            categoryUrl2 = TempUtil.getUrl(dataSourceUrl, categoryUrl2);
                            if (StringUtils.isEmpty((CharSequence)id2)) {
                                id2 = ids.length > 2 ? TempUtil.extractValue(categoryUrl2, ids[j + 1]) : TempUtil.extractValue(categoryUrl2, null);
                            }
                        }
                        if (StringUtils.isEmpty((CharSequence)id2)) {
                            id2 = ChineseCharactersUtils.toPinyin(name2);
                        }
                        CategoryPO categoryPO2 = new CategoryPO();
                        categoryPO2.setCategoryId(id2);
                        categoryPO2.setPater(id);
                        categoryPO2.setName(name2);
                        categoryPO2.setUrl(categoryUrl2);
                        categoryPO2.setLevel(Integer.valueOf(j + 2));
                        categoryPO2.setSign(mall);
                        categoryPO2.setCreatedTime(new Date());
                        categoryPOList.add(categoryPO2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Html startDriver(DcStrategyInfo strategyInfo, String url, DcDataSourceInfoPO infoPO, Map<String, String> param) {
        RemoteWebDriver driver = null;
        String result = "";
        try {
            String proxyIp = null;
            if (strategyInfo != null && StringUtils.isNotEmpty((CharSequence)strategyInfo.getProxyIp())) {
                proxyIp = strategyInfo.getProxyIp();
            }
            while (driver == null) {
                try {
                    driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.NORMAL, proxyIp).getDriver();
                }
                catch (Exception e) {
                    log.error("\u6d4f\u89c8\u5668\u542f\u52a8\u5f02\u5e38", (Throwable)e);
                }
            }
            if (infoPO != null && StringUtils.isNotEmpty((CharSequence)infoPO.getToken())) {
                driver = TempUtil.loginCookie(driver, infoPO.getToken(), infoPO.getUrl());
            }
            driver.get(url);
            driver.executeScript("window.open('" + url + "','newwindow')", new Object[0]);
            Set windowHandles = driver.getWindowHandles();
            Iterator iterator = windowHandles.iterator();
            iterator.next();
            String window = (String)iterator.next();
            log.info("\u6253\u5f00\u65b0\u7a97\u53e3");
            driver.switchTo().window(window);
            String[] cateList = param.get("categoryList").split(";");
            List elements = driver.findElementsByCssSelector(cateList[0]);
            if (!elements.isEmpty()) {
                Actions actions = new Actions((WebDriver)driver);
                for (WebElement element : elements) {
                    actions.moveToElement(element).build().perform();
                    Thread.sleep(500L);
                }
            } else {
                log.info("No elements found to hover over.");
            }
            if (strategyInfo != null && strategyInfo.getTaskInterval() != null) {
                TimeUnit.SECONDS.sleep(strategyInfo.getTaskInterval().intValue());
            }
            Html html = new Html(driver.getPageSource());
            return html;
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return null;
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.error("\u6d4f\u89c8\u5668\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
            finally {
                driver.quit();
            }
        }
    }
}

