/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.category;

import com.jayway.jsonpath.PathNotFoundException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Component
public class DlCategoryProcessorWithJsoup
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(DlCategoryProcessorWithJsoup.class);
    private static final String CATEGORY_URL = "https://b2b.nbdeli.com/";

    public void process(Page page) {
        String jsonStr = null;
        Document doc = null;
        try {
            doc = Jsoup.parse((URL)new URL(CATEGORY_URL), (int)3000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Elements eles = doc.getElementsByTag("script");
        for (Element ele : eles) {
            String script = ele.toString();
            if (script.indexOf("compData") <= -1) continue;
            script = ele.data();
            int beginIndex = script.indexOf("=") + 1;
            int endIndex = script.indexOf("if(!compData)");
            String newScript = script.substring(beginIndex, endIndex);
            int lastIndexOf = newScript.lastIndexOf(";");
            jsonStr = newScript.substring(1, lastIndexOf);
        }
        try {
            JsonPathSelector jsonPathSelector = new JsonPathSelector("$.*.backdata.frontCategoryTree.*");
            List list1 = jsonPathSelector.selectList(jsonStr);
            ArrayList<CategoryPO> list2 = new ArrayList<CategoryPO>();
            this.recursion(list1, list2, "0");
            log.info("\u5f97\u529b\u5546\u57ce\u5171\u6709{}\u6761\u5206\u7c7b", (Object)list2.size());
            page.putField("zkhCategoryList", list2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recursion(List<String> list1, List<CategoryPO> list2, String parentId) {
        if (list1 == null) {
            return;
        }
        JsonPathSelector jsonPathSelector1 = new JsonPathSelector("$.categoryName");
        JsonPathSelector jsonPathSelector2 = new JsonPathSelector("$.categoryUuid");
        JsonPathSelector jsonPathSelector3 = new JsonPathSelector("$.subList");
        String pater = parentId;
        for (String jsonStr : list1) {
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setPater(pater);
            String name = jsonPathSelector1.select(jsonStr);
            String uuid = jsonPathSelector2.select(jsonStr);
            categoryPO.setCategoryId(uuid);
            categoryPO.setName(name);
            if ("0".equals(pater)) {
                categoryPO.setLevel(Integer.valueOf(1));
            } else {
                categoryPO.setLevel(Integer.valueOf(2));
            }
            categoryPO.setSign(MallType.DL.getCode());
            categoryPO.setCreatedBy("kkx");
            categoryPO.setCreatedTime(new Date());
            list2.add(categoryPO);
            List newList = null;
            try {
                boolean flag = jsonStr.contains("subList");
                if (flag) {
                    newList = jsonPathSelector3.selectList(jsonStr);
                } else {
                    categoryPO.setUrl("https://b2b.nbdeli.com/pcweb/productList?cat=" + name + "&categoryUuid=" + uuid + "&state=1");
                    categoryPO.setLevel(Integer.valueOf(3));
                }
            }
            catch (PathNotFoundException p) {
                p.printStackTrace();
            }
            parentId = uuid;
            this.recursion(newList, list2, parentId);
        }
    }

    public Site getSite() {
        return Site.me();
    }
}

