/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.category;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class XySecondaryCategoryProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(XySecondaryCategoryProcessor.class);
    private RemoteWebDriver driver;

    public void process(Page page) {
        this.driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
        List categoryPOLists = (List)page.getRequest().getExtra("categoryPOList");
        ArrayList categoryPOList = new ArrayList();
        categoryPOLists.forEach(categoryPO -> {
            categoryPO.setId(null);
            categoryPO.setSign(MallType.XiYu.getCode());
            String pageUrl = categoryPO.getUrl();
            String paterID = categoryPO.getCategoryId();
            categoryPOList.add(categoryPO);
            this.driver.get(pageUrl);
            this.driver.executeScript("history.go(0)", new Object[0]);
            PageOperateUtil.pageRefresh(this.driver);
            Page page0 = PageOperateUtil.createPage(pageUrl, this.driver.getPageSource());
            this.secondaryCategoryProcessor(page0, categoryPOList, paterID);
            log.info("{}\u5206\u7c7b\u4e0b\u6709\u4e8c\u7ea7\u4e09\u7ea7\u5206\u7c7b\u5171{}\u6761\u6570\u636e", (Object)paterID, (Object)categoryPOList.size());
        });
        page.putField("zkhCategoryList", categoryPOList);
        this.driver.quit();
    }

    private void secondaryCategoryProcessor(Page page, List<CategoryPO> categoryPOList, String paterID) {
        Html html = page.getHtml();
        List divs = html.$("div.catList").nodes();
        divs.forEach(div -> {
            String secondaryUrl = div.$("div.cat-title-name").$("a", "href").get();
            String secondaryName = div.$("div.cat-title-name a").xpath("///allText()").get();
            String[] secondaryStringUrls = secondaryUrl.split("[/ : . \\- _ # %]");
            String secondaryCategoryId = secondaryStringUrls[7];
            CategoryPO secondaryCategory = new CategoryPO();
            secondaryCategory.setCategoryId(secondaryCategoryId);
            secondaryCategory.setName(secondaryName);
            secondaryCategory.setUrl(secondaryUrl);
            secondaryCategory.setPater(paterID);
            secondaryCategory.setLevel(Integer.valueOf(2));
            secondaryCategory.setSign(MallType.XiYu.getCode());
            secondaryCategory.setCreatedBy("Sakura");
            secondaryCategory.setCreatedTime(new Date());
            secondaryCategory.setUpdatedBy("Sakura");
            categoryPOList.add(secondaryCategory);
            List list = div.$("div.node-title").nodes();
            if (list != null) {
                list.forEach(item -> {
                    String url = item.$("a", "href").get();
                    String name = item.$("a", "title").get();
                    String[] stringUrls = url.split("[/ : . \\- _ # %]");
                    String categoryId = stringUrls[7];
                    CategoryPO thirdCategory = new CategoryPO();
                    thirdCategory.setCategoryId(categoryId);
                    thirdCategory.setName(name);
                    thirdCategory.setUrl(url);
                    thirdCategory.setPater(secondaryCategoryId);
                    thirdCategory.setLevel(Integer.valueOf(3));
                    thirdCategory.setSign(MallType.XiYu.getCode());
                    thirdCategory.setCreatedBy("Sakura");
                    thirdCategory.setCreatedTime(new Date());
                    thirdCategory.setUpdatedBy("Sakura");
                    categoryPOList.add(thirdCategory);
                });
            }
        });
    }

    public Site getSite() {
        return Site.me().addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36").addHeader("Upgrade-Insecure-Requests", "1").addHeader("Sec-Fetch-Mode", "navigate");
    }
}

