/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsCommentPO;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.selector.Html;

@Component
public class BzdetDescriptionProcessor {
    private static final Logger log = LoggerFactory.getLogger(BzdetDescriptionProcessor.class);
    @Value(value="${nicc-plugin.spider.isPiderComment}")
    private boolean isPiderComment;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public Map<String, Object> process(Goods goods, RemoteWebDriver driver) {
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String url = goods.getUrl();
            driver.get(url);
            Thread.sleep(3000L);
            PageOperateUtil.pageRefresh(driver);
            Page page0 = PageOperateUtil.createPage(url, driver.getPageSource());
            this.pageProcess(page0, goodsDetails, goods);
        }
        catch (Exception e) {
            driver.quit();
            log.error("\u5927\u6c5f\u79d1\u6280\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        log.info("\u5927\u6c5f\u79d1\u6280\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        return map;
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String[] thirdStrings;
        String categoryId;
        String title;
        String skuNo;
        Html html = page.getHtml();
        List divs = html.$("div.guigecanshu").nodes();
        HashMap hashMap = new HashMap();
        StringBuilder commodityAttribute = new StringBuilder();
        divs.forEach(selectable -> {
            String goodsAttribute = selectable.$("div.guigecanshu").xpath("///allText()").get();
            String[] attribute = goodsAttribute.split("\uff1a");
            commodityAttribute.append(attribute[0] + ",");
            hashMap.put(attribute[0], attribute[1]);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        HashMap extJsonMap = new HashMap();
        String extJson = "";
        List specbox = html.$("ul.specbox>li").nodes();
        if (CollectionUtils.isNotEmpty((Collection)specbox)) {
            specbox.forEach(node -> {
                String na = node.$("span.specinfo").xpath("///allText()").get();
                String value = node.$("span:nth-child(2)").xpath("///allText()").get();
                extJsonMap.put(na, value);
            });
        }
        if (extJsonMap != null) {
            extJson = JSONUtil.toJsonStr(extJsonMap);
        }
        String introduce = html.$("div.prdDescOut").get();
        String brandName = html.$("ul.specbox> li:nth-child(3) > span:nth-child(2)").xpath("///allText()").get();
        goods.setPrefix(MallType.Gome.getCode());
        goods.setBrandName(brandName);
        String price = html.$("#prdPrice").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)price)) {
            if (price.equals("\u00a5\u6682\u65e0\u552e\u4ef7")) {
                goods.setPrice(new BigDecimal(0));
            } else {
                price = price.replace("\u00a5", "").trim();
                goods.setPrice(new BigDecimal(price));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(skuNo = html.$("span.product-number").xpath("///@title").get()))) {
            goods.setSkuId(skuNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(title = html.$("#gm-prd-main > div.hgroup > h1").xpath("///allText()").get()))) {
            goods.setTitle(title);
        }
        String catName = html.$("div.breadcrumbs-wrapper > div > div.left > ul > li:nth-child(4) > a").xpath("///allText()").get();
        String catId = html.$("div.breadcrumbs-wrapper > div > div.left > ul > li:nth-child(4) > a").xpath("///@href").get();
        if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("[/ : . \\- _ # %]"))[thirdStrings.length - 2]))) {
            goods.setCategoryId(categoryId);
        }
        if (StringUtils.isNotEmpty((CharSequence)catName)) {
            goods.setCategoryName(catName);
        }
        HashMap<String, String> comment = new HashMap<String, String>();
        if (this.isPiderComment) {
            String goodRateShow = html.$("div.sper > span").xpath("///allText()").get();
            if (StringUtils.isNotBlank((CharSequence)goodRateShow)) {
                goodRateShow = "100";
            }
            comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
            String prdId = "prdId:\"(\\d+)\"";
            Pattern patternprdId = Pattern.compile(prdId);
            Matcher matcherprdId = patternprdId.matcher(html.get());
            if (matcherprdId.find()) {
                prdId = matcherprdId.group(1);
                this.goodsComment(prdId, goods.getGoodsNo(), comment);
            }
        }
        goodsDetails.setPrefix(MallType.Gome.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuId(skuNo);
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
        goodsDetails.setExtJson(extJson);
        goodsDetails.setExecutionNumber(goods.getExecutionNumber());
        String commentStr = "";
        if (comment != null && comment.size() > 0) {
            commentStr = JSONUtil.toJsonStr(comment);
            goodsDetails.setComment(commentStr);
        }
    }

    private void goodsComment(String pId, String goodNo, HashMap<String, String> comment) {
        String result;
        String url = "https://www.zjmi-mall.com.cn" + pId + "/1/all/0/10/flag/appraise";
        HttpResponse response = HttpRequest.get((String)url).execute();
        if (response.isOk() && (result = response.body()) != null) {
            JSONArray list;
            JSONObject object = JSONObject.parseObject((String)result);
            String commentCountStr = object.getString("totalCount");
            String afterCountStr = object.getString("additional");
            String goodCountStr = object.getString("good");
            String generalCountStr = object.getString("mid");
            String poorCountStr = object.getString("bad");
            comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
            comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
            comment.put("\u597d\u8bc4\u6570", goodCountStr);
            comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
            comment.put("\u5dee\u8bc4\u6570", poorCountStr);
            JSONObject jsonObject = object.getJSONObject("evaList");
            JSONArray evaList = jsonObject.getJSONArray("Evalist");
            if (jsonObject != null && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)evaList.toString(), (Feature[])new Feature[0])))) {
                ArrayList<GoodsCommentPO> goodsCommentPOS = new ArrayList<GoodsCommentPO>();
                for (Map map : list) {
                    GoodsCommentPO commentPO = new GoodsCommentPO();
                    commentPO.setPrefix(MallType.Gome.getCode());
                    commentPO.setCreatetime(new Date());
                    commentPO.setUpdatetime(new Date());
                    if (map.get("loginname") != null) {
                        commentPO.setUserName(map.get("loginname").toString());
                    }
                    if (map.get("appraiseId") != null) {
                        commentPO.setCommentId(map.get("appraiseId").toString());
                    }
                    if (map.get("appraiseElSum") != null) {
                        commentPO.setCommentCon(map.get("appraiseElSum").toString());
                    }
                    if (map.get("post_time") != null) {
                        commentPO.setCommentTime(map.get("post_time").toString());
                    }
                    commentPO.setGoodsNo(goodNo);
                    if (map.get("receiveCity") != null) {
                        commentPO.setLocation(map.get("receiveCity").toString());
                    }
                    if (map.get("replyNum") != null) {
                        commentPO.setSpriteComment(map.get("replyNum").toString());
                    }
                    if (map.get("apprnum") != null) {
                        commentPO.setSpritePraise(map.get("apprnum").toString());
                    }
                    if (map.get("mscore") != null) {
                        commentPO.setStar(map.get("mscore").toString());
                    }
                    goodsCommentPOS.add(commentPO);
                }
                this.processDataPipeline.processDataList(goodsCommentPOS);
            }
        }
    }
}

