/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.minio.MinioHelper;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class ComixDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ComixDescriptionProcessor.class);
    @Autowired
    private MinioHelper minioHelper;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        ComixDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            goodsDetails.setExecutionNumber(executionNumber);
            if (goods.getUrl().contains("mro.qx.com")) {
                this.mroqx(goodsDetails, goods);
            } else {
                this.pageProcess(page, goodsDetails, goods);
            }
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u9f50\u5fc3\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u9f50\u5fc3\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String[] thirdStrings;
        String categoryId;
        Object selfDriver = null;
        Object driver = null;
        String url = goods.getUrl();
        String goodsno = goods.getGoodsNo();
        Html html = page.getHtml();
        List divs = html.$("ul.attributes.clearfix>li").nodes();
        HashMap hashMap = new HashMap();
        StringBuilder commodityAttribute = new StringBuilder();
        divs.forEach(selectable -> {
            String goodsAttributeStr = selectable.$("li").xpath("///allText()").get();
            String goodsAttribute = null;
            String goodsSaleAttribute = null;
            if (StringUtils.isNotEmpty((CharSequence)goodsAttributeStr)) {
                String[] att = goodsAttributeStr.split("\uff1a");
                goodsAttribute = att[0];
                if (att.length > 1) {
                    goodsSaleAttribute = att[1];
                }
            }
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        String brandName = hashMap.get("\u54c1\u724c").toString();
        String pic = html.$("ul.listImg>li>img").xpath("///@src").get();
        goods.setPic(pic);
        String isSelf = html.$("div.zydp").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)isSelf)) {
            if (isSelf.contains("\u9f50\u5fc3\u5546\u57ce\u81ea\u8425")) {
                goods.setSupplierName("\u9f50\u5fc3\u5546\u57ce\u81ea\u8425");
            } else {
                goods.setSupplierName("\u975e\u81ea\u8425");
            }
        } else {
            goods.setSupplierName("comix");
        }
        String price = html.$("dl.fcs-price>dd").xpath("///allText()").get();
        String skuId = hashMap.get("\u5546\u54c1\u7f16\u7801").toString();
        String title = html.$("div.detail-hd").xpath("///allText()").get();
        String catName = html.$("ul.crumbClip.clearfix > li:nth-child(3) > dl > dt > a").xpath("///allText()").get();
        String catId = html.$(" ul.crumbClip.clearfix > li:nth-child(3) > dl > dt > a").xpath("///@href").get();
        if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("="))[1]))) {
            goods.setCategoryId(categoryId);
        }
        if (StringUtils.isNotEmpty((CharSequence)catName)) {
            goods.setCategoryName(catName);
        }
        if (StringUtils.isNotEmpty((CharSequence)skuId)) {
            goods.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            goods.setTitle(title);
        }
        goods.setPrefix(MallType.Comix.getCode());
        goods.setBrandName(brandName);
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            String cleanedPrice = price.replaceAll("\u00a5", "");
            goods.setPrice(new BigDecimal(cleanedPrice));
        } else {
            log.info("\u9f50\u5fc3\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
            goods.setSkuState("0");
        }
        goodsDetails.setPrefix(MallType.Comix.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuId(skuId);
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
    }

    public Site getSite() {
        return Site.me();
    }

    private void mroqx(GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String result;
        String url = "https://mrgateway.qx.com/v1/goods/indexgoodsinfo";
        String url1 = goods.getUrl();
        String goodsno = goods.getGoodsNo();
        Object selfDriver = null;
        Object driver = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", goods.getGoodsNo());
        String resultStr = JSON.toJSONString(param);
        HttpResponse httpResponse = HttpRequest.post((String)url).body(resultStr, "application/json").execute();
        if (httpResponse.isOk() && StringUtils.isNotEmpty((CharSequence)(result = httpResponse.body()))) {
            JSONObject object = JSONObject.parseObject((String)result);
            JSONObject data = JSONObject.parseObject((String)object.get((Object)"data").toString());
            String title = data.getString("prouctName");
            JSONArray imageArray = data.getJSONArray("image");
            JSONObject firstImage = imageArray.getJSONObject(0);
            String pic = firstImage.getString("url");
            String price = data.getString("sellPrice");
            String skuId = data.getString("mallCode");
            String brandName = data.getString("brand");
            String catName = data.getString("categoryName");
            String[] part1 = catName.split(">");
            if (part1.length >= 2) {
                String penultimatePart = part1[part1.length - 2];
                String[] subParts = penultimatePart.split("\\|");
                String categoryName = subParts[1];
                String categoryId = subParts[0];
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
            } else {
                String categoryName = catName.split("\\|")[1];
                String categoryId = catName.split("\\|")[0];
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
            }
            String[] parts = catName.split(">");
            if (StringUtils.isNotEmpty((CharSequence)pic)) {
                goods.setPic(pic);
            }
            if (StringUtils.isNotEmpty((CharSequence)skuId)) {
                goods.setSkuId(skuId);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPrefix(MallType.Comix.getCode());
            goods.setBrandName(brandName);
            goods.setSupplierName("\u9f50\u5fc3\u5546\u57ce\u81ea\u8425");
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                goods.setPrice(new BigDecimal(price));
            } else {
                log.info("\u9f50\u5fc3\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            goodsDetails.setPrefix(MallType.Comix.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(skuId);
            goodsDetails.setCreated(new Date());
        }
    }
}

