/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.minio.MinioHelper;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.aliyun.AliyunConfig;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class GajDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(GajDescriptionProcessor.class);
    @Autowired
    private AliyunConfig aliyunConfig;
    private static boolean isAccurate;
    @Autowired
    private MinioHelper minioHelper;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        GajDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            String url = goods.getUrl();
            String result = HttpRequest.post((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u56fa\u5b89\u6377\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u56fa\u5b89\u6377\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        String url = goods.getUrl();
        try {
            String[] thirdStrings;
            String categoryId;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            Html html = GajDescriptionProcessor.createHtml(driver.getPageSource());
            String goodsno = goods.getGoodsNo();
            List divs = html.$("div.spec-item").nodes();
            HashMap hashMap = new HashMap();
            StringBuilder commodityAttribute = new StringBuilder();
            divs.forEach(selectable -> {
                String goodsAttribute = selectable.$("span.new_class_left").xpath("///allText()").get();
                String goodsSaleAttribute = selectable.$("span.new_class").xpath("///allText()").get();
                commodityAttribute.append(goodsAttribute + ",");
                hashMap.put(goodsAttribute, goodsSaleAttribute);
            });
            String skuAttrJson = JSON.toJSONString(hashMap);
            String introduce = html.$("div#productImg").get();
            String brandName = html.$("h1.text-2 strong:nth-child(1)").xpath("///allText()").get();
            String price = html.$("#productParams > div.newReplace > div > div.right > div > div.good-price > strong > span").xpath("///allText()").get();
            String pic = html.$("div.box-img-warpper > div.small > img").xpath("///@src").get();
            String skuId = html.$("div.newReplace > div > div.middle > div > div.spec > div:nth-child(1) > span.new_class").xpath("///allText()").get();
            String title = html.$("div.newReplace > div > div.middle > div > div.good-info-height > div > h1").xpath("///allText()").get();
            String catName = html.$("#breadcrumb > div > div:nth-child(4) > span > a").xpath("///allText()").get();
            String catId = html.$("#breadcrumb > div > div:nth-child(4) > span > a").xpath("///@href").get();
            if (!isAccurate) {
                try {
                    RemoteWebDriver screenshotTaker = driver;
                    RemoteWebDriver js = driver;
                    js.executeScript("window.scrollTo(0, 80);", new Object[0]);
                    js.executeScript("document.body.style.zoom = '0.67';", new Object[0]);
                    File screenshot = (File)screenshotTaker.getScreenshotAs(OutputType.FILE);
                    try {
                        OSS ossClient = new OSSClientBuilder().build(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
                        String ossObjectName = this.aliyunConfig.getBucketName() + "_mymro_" + goodsno + ".png";
                        PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunConfig.getBucketName(), ossObjectName, screenshot);
                        PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
                        String fileUrl = "http://" + this.aliyunConfig.getBucketName() + "." + this.aliyunConfig.getEndpoint() + "/" + ossObjectName;
                        goods.setScreenshot(fileUrl);
                    }
                    catch (Exception e) {
                        log.error("\u56fa\u5b89\u6377\u622a\u56fe\u4e0a\u4f20OSS\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.info("\u56fa\u5b89\u6377\u5546\u57ce\u622a\u56fe\u65f6\u51fa\u73b0\u95ee\u9898", (Object)goods.getGoodsNo());
                    log.error("\u622a\u56fe\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("[/ : . \\- _ # %]"))[thirdStrings.length - 2]))) {
                goods.setCategoryId(categoryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)catName)) {
                goods.setCategoryName(catName);
            }
            if (StringUtils.isNotEmpty((CharSequence)skuId)) {
                goods.setSkuId(skuId);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPic(pic);
            goods.setPrefix(MallType.GAJ.getCode());
            goods.setBrandName(brandName);
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                String cleanedPrice = price.replaceAll(",", "");
                goods.setPrice(new BigDecimal(cleanedPrice));
            } else {
                log.info("\u56fd\u5b89\u6377\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            goodsDetails.setPrefix(MallType.GAJ.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(skuId);
            goodsDetails.setSkuAttrNames(commodityAttribute.toString());
            goodsDetails.setSkuAttrJson(skuAttrJson);
            goodsDetails.setCreated(new Date());
            goodsDetails.setIntroduce(introduce);
        }
        catch (Exception e) {
            log.info("\u56fa\u5b89\u6377\u5546\u57ce\u722c\u53d6\u8be6\u60c5\u9875\u65f6\u51fa\u73b0\u95ee\u9898", (Object)goods.getGoodsNo());
            log.error("\u622a\u56fe\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        return Site.me();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

