/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailTempPipeline;
import com.tydic.nicc.spider.config.util.TempUtil;
import com.tydic.nicc.spider.mapper.DcDataSourceInfoMapper;
import com.tydic.nicc.spider.mapper.DcStrategyInfoMapper;
import com.tydic.nicc.spider.mapper.DcTemplateInfoMapper;
import com.tydic.nicc.spider.mapper.po.DcDataSourceInfoPO;
import com.tydic.nicc.spider.mapper.po.DcStrategyInfo;
import com.tydic.nicc.spider.mapper.po.DcTemplateInfoPO;
import com.tydic.nicc.spider.mapper.po.DcTemplateInfoPOWithBLOBs;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class GoodsDetailsTempProcessor {
    private static final Logger log = LoggerFactory.getLogger(GoodsDetailsTempProcessor.class);
    @Autowired
    private GoodsDetailTempPipeline goodsDetailTempPipeline;
    @Autowired
    private DcTemplateInfoMapper dcTemplateInfoMapper;
    @Autowired
    private DcStrategyInfoMapper dcStrategyInfoMapper;
    @Autowired
    private DcDataSourceInfoMapper dcDataSourceInfoMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Goods goods) {
        String skuId = goods.getSkuId();
        String goodsNo = goods.getGoodsNo();
        String mall = goods.getPrefix();
        String url = goods.getUrl();
        Integer templateType = 3;
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> goodMap = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        goodsDetails.setPrefix(mall);
        goodsDetails.setGoodsNo(goodsNo);
        goodsDetails.setExecutionNumber(executionNumber);
        goodsDetails.setSkuId(skuId);
        try {
            RemoteWebDriver driver;
            log.info("\u722c\u53d6{}\u5546\u57ce{}\u5f00\u59cb", (Object)mall, (Object)url);
            DcTemplateInfoPOWithBLOBs templateInfo = this.dcTemplateInfoMapper.selectBySource(mall, templateType);
            ObjectMapper mapper = new ObjectMapper();
            if (templateInfo == null) return;
            DcDataSourceInfoPO infoPO = this.dcDataSourceInfoMapper.selectBySign(mall);
            DcStrategyInfo strategyInfo = this.dcStrategyInfoMapper.selectByMall(mall, templateType);
            String requestBody = templateInfo.getRequestParam();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)templateInfo.getAttributeInfo())) {
                List list = (List)mapper.readValue(templateInfo.getAttributeInfo(), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
                for (Map map : list) {
                    if (((String)map.get("code")).equals("goodsNo")) {
                        String goodsNoPath = (String)map.get("value");
                        paramMap.put("goodsNo", goodsNoPath);
                    }
                    if (((String)map.get("code")).equals("skuId")) {
                        paramMap.put("skuId", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("skuName")) {
                        paramMap.put("skuName", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("title")) {
                        paramMap.put("title", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("price")) {
                        paramMap.put("price", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("costPrice")) {
                        paramMap.put("costPrice", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("pic")) {
                        paramMap.put("pic", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("url")) {
                        paramMap.put("url", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("brandId")) {
                        paramMap.put("brandId", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("brandName")) {
                        paramMap.put("brandName", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("shopName")) {
                        paramMap.put("shopName", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("label")) {
                        paramMap.put("label", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("categoryId")) {
                        paramMap.put("categoryId", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("categoryName")) {
                        paramMap.put("categoryName", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("skuAttrList")) {
                        paramMap.put("skuAttrList", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("skuAttr")) {
                        paramMap.put("skuAttr", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("commentList")) {
                        paramMap.put("commentList", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("comment")) {
                        paramMap.put("comment", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("skuState")) {
                        paramMap.put("skuState", (String)map.get("value"));
                    }
                    if (((String)map.get("code")).equals("commentClick")) {
                        paramMap.put("commentClick", (String)map.get("value"));
                    }
                    if (!((String)map.get("code")).equals("skuAttrClick")) continue;
                    paramMap.put("skuAttrClick", (String)map.get("value"));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                if (!templateInfo.getResponseType().equals("HTML")) {
                    url = templateInfo.getUrl();
                    this.packTempInfo((DcTemplateInfoPO)templateInfo, skuId, goodsNo, requestBody, url);
                } else {
                    templateInfo.setUrl(url);
                }
            } else {
                url = templateInfo.getUrl();
                this.packTempInfo((DcTemplateInfoPO)templateInfo, skuId, goodsNo, requestBody, url);
            }
            if (templateInfo.getCrawlingMode().equals("API")) {
                String result = TempUtil.requestHttpUrl(templateInfo, mapper, strategyInfo);
                if (result.equals("8888")) throw new DcBusinessException("\u8bf7\u6c42\u5931\u8d25");
                if (templateInfo.getResponseType().equals("JSON")) {
                    if (TempUtil.detectJsonFormat(result).equals("JSON")) {
                        this.apiProcess(goods, goodsDetails, result, paramMap);
                    }
                } else if (templateInfo.getResponseType().equals("HTML")) {
                    Html html = new Html(result);
                    this.htmlProcess(goods, goodsDetails, html, paramMap);
                }
            } else if (templateInfo.getCrawlingMode().equals("HTML") && (driver = TempUtil.startDriver(strategyInfo, templateInfo.getUrl(), infoPO)) != null) {
                try {
                    this.htmlDriverProcess(goods, goodsDetails, driver, paramMap);
                }
                catch (Exception e) {
                    log.error("\u5546\u57ce{}\u722c\u53d6\u8be6\u60c5{}\u5931\u8d25", new Object[]{mall, templateInfo.getUrl(), e});
                }
                finally {
                    if (driver != null) {
                        try {
                            driver.quit();
                        }
                        catch (Exception e) {
                            log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                        }
                    }
                }
            }
            goodMap.put("goods", goods);
            goodMap.put("goodsDetails", goodsDetails);
            this.goodsDetailTempPipeline.process(goodMap);
            return;
        }
        catch (Exception e) {
            log.info("\u5546\u57ce{}\u722c\u53d6\u6570\u636e\u5931\u8d25", (Object)mall, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void packTempInfo(DcTemplateInfoPO templateInfo, String skuId, String goodsNo, String requstBody, String url) {
        try {
            if (templateInfo.getRequestMethod() != null && templateInfo.getRequestMethod().equals("1")) {
                List<String> placeholderNames = TempUtil.extractPlaceholderNames(requstBody);
                if (CollectionUtils.isNotEmpty(placeholderNames)) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    for (String placeholderName : placeholderNames) {
                        if (placeholderName.equals("skuId")) {
                            placeholders.put(placeholderName, skuId);
                        }
                        if (!placeholderName.equals("goodsNo")) continue;
                        placeholders.put(placeholderName, goodsNo);
                    }
                    String body = TempUtil.replacePlaceholders(requstBody, placeholders);
                    templateInfo.setRequestParam(body);
                }
            } else {
                List<String> placeholderNames = TempUtil.extractPlaceholderNames(url);
                if (CollectionUtils.isNotEmpty(placeholderNames)) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    for (String placeholderName : placeholderNames) {
                        if (placeholderName.equals("skuId")) {
                            placeholders.put(placeholderName, skuId);
                        }
                        if (!placeholderName.equals("goodsNo")) continue;
                        placeholders.put(placeholderName, goodsNo);
                    }
                    String body = TempUtil.replacePlaceholders(url, placeholders);
                    templateInfo.setUrl(body);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5c01\u88c5templateInfo\u5931\u8d25", (Throwable)e);
        }
    }

    private void apiProcess(Goods goods, GoodsDetailsWithBLOBs goodsDetails, String goodStr, Map<String, String> paramMap) {
        String url;
        String skuId;
        String goodsNo;
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("goodsNo")) && StringUtils.isNotEmpty((CharSequence)(goodsNo = new JsonPathSelector(paramMap.get("goodsNo")).select(goodStr)))) {
            goods.setGoodsNo(goodsNo);
            goodsDetails.setGoodsNo(goodsNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuId"))) {
            String spuId = new JsonPathSelector(paramMap.get("spuId")).select(goodStr);
            goods.setSpuId(spuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuName"))) {
            String spuName = new JsonPathSelector(paramMap.get("spuName")).select(goodStr);
            goods.setSpuName(spuName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuId")) && StringUtils.isNotEmpty((CharSequence)(skuId = new JsonPathSelector(paramMap.get("skuId")).select(goodStr)))) {
            goods.setSkuId(skuId);
            goodsDetails.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("title"))) {
            String title = new JsonPathSelector(paramMap.get("title")).select(goodStr);
            goods.setTitle(title);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("price"))) {
            String price = "0";
            if (paramMap.get("price").contains("/")) {
                String[] prices = paramMap.get("price").split("/");
                price = new JsonPathSelector(prices[0]).select(goodStr);
                price = String.valueOf(Double.valueOf(price) / Double.valueOf(prices[1]));
            } else {
                price = new JsonPathSelector(paramMap.get("price")).select(goodStr);
            }
            price = TempUtil.getPrice(price);
            if (StringUtils.isEmpty((CharSequence)price)) {
                price = "0";
            }
            goods.setPrice(new BigDecimal(price));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("costPrice"))) {
            String costPrice = "0";
            if (paramMap.get("price").contains("/")) {
                String[] costPrices = paramMap.get("costPrice").split("/");
                costPrice = new JsonPathSelector(costPrices[0]).select(goodStr);
                costPrice = String.valueOf(Double.valueOf(costPrice) / Double.valueOf(costPrices[1]));
            } else {
                costPrice = new JsonPathSelector(paramMap.get("costPrice")).select(goodStr);
            }
            costPrice = TempUtil.getPrice(costPrice);
            if (StringUtils.isEmpty((CharSequence)costPrice)) {
                costPrice = "0";
            }
            goods.setCostPrice(new BigDecimal(costPrice));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("pic"))) {
            String pic = new JsonPathSelector(paramMap.get("pic")).select(goodStr);
            goods.setPic(pic);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("url")) && paramMap.get("url").contains("$.")) {
            url = new JsonPathSelector(paramMap.get("url")).select(goodStr);
            goods.setUrl(url);
        } else {
            url = paramMap.get("url");
            List<String> placeholderNames = TempUtil.extractPlaceholderNames(url);
            if (CollectionUtils.isNotEmpty(placeholderNames)) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                for (String placeholderName : placeholderNames) {
                    Object value = "";
                    if (StringUtils.isNotEmpty((CharSequence)paramMap.get(placeholderName))) {
                        value = new JsonPathSelector(paramMap.get(placeholderName)).select(goodStr);
                    } else if (placeholderName.equals("skuId")) {
                        value = goods.getSkuId();
                    }
                    placeholders.put(placeholderName, (String)value);
                }
                url = TempUtil.replacePlaceholders(url, placeholders);
            }
            goods.setUrl(url);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandId"))) {
            String brandId = new JsonPathSelector(paramMap.get("brandId")).select(goodStr);
            goods.setBrandId(brandId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandName"))) {
            String brandName = new JsonPathSelector(paramMap.get("brandName")).select(goodStr);
            goods.setBrandName(brandName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("shopName"))) {
            String shopName = new JsonPathSelector(paramMap.get("shopName")).select(goodStr);
            goods.setSupplierName(shopName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("label"))) {
            String label = new JsonPathSelector(paramMap.get("label")).select(goodStr);
            goods.setLabel(label);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryId"))) {
            String cateId = new JsonPathSelector(paramMap.get("categoryId")).select(goodStr);
            goods.setCategoryId(cateId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryName"))) {
            String cateName = new JsonPathSelector(paramMap.get("categoryName")).select(goodStr);
            goods.setCategoryName(cateName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttrList"))) {
            List skuAttrList = new JsonPathSelector(paramMap.get("skuAttrList")).selectList(goodStr);
            goodsDetails.setExtJson(JSONUtil.toJsonStr((Object)skuAttrList));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttr"))) {
            HashMap<String, String> skuAttrJson = new HashMap<String, String>();
            String[] skuAttr = paramMap.get("skuAttr").split("/");
            String skuSaleAttrNames = "";
            ArrayList<String> skuSaleAttrNamesList = new ArrayList<String>();
            if (skuAttr.length == 2) {
                List list = new JsonPathSelector(paramMap.get("skuAttrList")).selectList(goodStr);
                for (String str : list) {
                    String name = "";
                    String value = "";
                    if (str.contains(skuAttr[0].replace("$.", ""))) {
                        name = new JsonPathSelector(skuAttr[0]).select(str);
                    }
                    if (str.contains(skuAttr[1].replace("$.", ""))) {
                        value = new JsonPathSelector(skuAttr[1]).select(str);
                    }
                    skuAttrJson.put(name, value);
                    skuSaleAttrNamesList.add(name);
                }
                skuSaleAttrNames = String.join((CharSequence)".", skuSaleAttrNamesList);
            }
            goodsDetails.setSkuAttrJson(JSONUtil.toJsonStr(skuAttrJson));
            goodsDetails.setSkuAttrNames(skuSaleAttrNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("commentList"))) {
            String commentList = new JsonPathSelector(paramMap.get("commentList")).select(goodStr);
            goodsDetails.setIntroduce(commentList);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("comment"))) {
            HashMap<String, String> comment = new HashMap<String, String>();
            String[] comments = paramMap.get("comment").split(":");
            if (comments.length == 2) {
                List list = new JsonPathSelector(paramMap.get("commentList")).selectList(goodStr);
                for (String str : list) {
                    String name = new JsonPathSelector(comments[0]).select(str);
                    String value = new JsonPathSelector(comments[1]).select(str);
                    comment.put(name, value);
                }
            }
            goodsDetails.setComment(JSONUtil.toJsonStr(comment));
        }
    }

    public void htmlProcess(Goods goods, GoodsDetailsWithBLOBs goodsDetails, Html html, Map<String, String> paramMap) {
        String url;
        String skuId;
        String goodsNo;
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuState"))) {
            String skuState = TempUtil.getStr((Selectable)html, paramMap.get("skuState"));
            skuState = StringUtils.isNotEmpty((CharSequence)skuState) ? "0" : "1";
            goods.setSkuState(skuState);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("goodsNo")) && StringUtils.isNotEmpty((CharSequence)(goodsNo = TempUtil.getStr((Selectable)html, paramMap.get("goodsNo"))))) {
            goods.setGoodsNo(goodsNo);
            goodsDetails.setGoodsNo(goodsNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuId"))) {
            String spuId = TempUtil.getStr((Selectable)html, paramMap.get("spuId"));
            goods.setSpuId(spuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuName"))) {
            String spuName = TempUtil.getStr((Selectable)html, paramMap.get("spuName"));
            goods.setSpuName(spuName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuId")) && StringUtils.isNotEmpty((CharSequence)(skuId = TempUtil.getStr((Selectable)html, paramMap.get("skuId"))))) {
            goods.setSkuId(skuId);
            goodsDetails.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("title"))) {
            String title = TempUtil.getStr((Selectable)html, paramMap.get("title"));
            goods.setTitle(title);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("price"))) {
            goods.setPrice(new BigDecimal(TempUtil.getPrice((Selectable)html, paramMap.get("price"), false)));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("costPrice"))) {
            goods.setCostPrice(new BigDecimal(TempUtil.getPrice((Selectable)html, paramMap.get("costPrice"), false)));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("pic"))) {
            String pic = TempUtil.getStr((Selectable)html, paramMap.get("pic"));
            goods.setPic(pic);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("url")) && !paramMap.get("url").contains("$")) {
            url = TempUtil.getStr((Selectable)html, paramMap.get("url"));
            goods.setUrl(url);
        } else {
            url = paramMap.get("url");
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                List<String> placeholderNames = TempUtil.extractPlaceholderNames(url);
                if (CollectionUtils.isNotEmpty(placeholderNames)) {
                    String[] placeholders = new HashMap();
                    for (String placeholderName : placeholderNames) {
                        String value = "";
                        if (StringUtils.isNotEmpty((CharSequence)paramMap.get(placeholderName))) {
                            value = TempUtil.getStr((Selectable)html, paramMap.get(placeholderName));
                        } else if (placeholderName.equals("skuId")) {
                            value = goods.getSkuId();
                        }
                        placeholders.put(placeholderName, value);
                    }
                    url = TempUtil.replacePlaceholders(url, placeholders);
                }
                goods.setUrl(url);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandId"))) {
            String brandId = TempUtil.getStr((Selectable)html, paramMap.get("brandId"));
            goods.setBrandId(brandId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandName"))) {
            String brandName = TempUtil.getStr((Selectable)html, paramMap.get("brandName"));
            goods.setBrandName(brandName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("shopName"))) {
            String shopName = TempUtil.getStr((Selectable)html, paramMap.get("shopName"));
            goods.setSupplierName(shopName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("label"))) {
            String[] labels = paramMap.get("label").split(";");
            String label = "";
            for (String lab : labels) {
                label = label + TempUtil.getStr((Selectable)html, lab) + ";";
            }
            goods.setLabel(label);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryId"))) {
            String cateId = "";
            String param = "";
            if (paramMap.get("categoryId").contains("?")) {
                String[] cateIds = paramMap.get("categoryId").split("\\?");
                cateId = TempUtil.getStr((Selectable)html, cateIds[0]);
                param = cateIds[1];
            } else {
                cateId = TempUtil.getStr((Selectable)html, paramMap.get("categoryId"));
            }
            if (StringUtils.isNotEmpty((CharSequence)cateId) && cateId.contains("/")) {
                cateId = TempUtil.extractValue(cateId, param);
            }
            goods.setCategoryId(cateId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryName"))) {
            String cateName = TempUtil.getStr((Selectable)html, paramMap.get("categoryName"));
            goods.setCategoryName(cateName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttrList"))) {
            List divs = html.$(paramMap.get("skuAttrList")).nodes();
            goodsDetails.setExtJson(JSONUtil.toJsonStr((Object)divs));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttr"))) {
            HashMap<String, String> skuAttrJson = new HashMap<String, String>();
            List divs = null;
            String str = paramMap.get("skuAttr");
            String skuSaleAttrNames = "";
            ArrayList<String> skuSaleAttrNamesList = new ArrayList<String>();
            if (paramMap.get("skuAttr").contains(":")) {
                String[] strs = paramMap.get("skuAttr").split("/");
                divs = html.$(paramMap.get("skuAttrList")).nodes();
                for (Selectable div : divs) {
                    String name = TempUtil.getStr(div, strs[0]);
                    String value = TempUtil.getStr(div, strs[1]);
                    skuAttrJson.put(name, value);
                    skuSaleAttrNamesList.add(name);
                }
            } else {
                divs = html.$(paramMap.get("skuAttr")).nodes();
                for (Selectable div : divs) {
                    String att = div.xpath("///allText()").get();
                    String[] attrs = att.split("\uff1a");
                    String name = "";
                    String value = "";
                    if (attrs.length > 1) {
                        name = attrs[0];
                        value = attrs[1];
                    } else {
                        attrs = att.split(":");
                        if (attrs.length > 1) {
                            name = attrs[0];
                            value = attrs[1];
                        } else {
                            attrs = att.split(" ");
                            if (attrs.length > 1) {
                                name = attrs[0];
                                value = attrs[1];
                            }
                        }
                    }
                    skuAttrJson.put(name, value);
                    skuSaleAttrNamesList.add(name);
                }
            }
            skuSaleAttrNames = String.join((CharSequence)",", skuSaleAttrNamesList);
            goodsDetails.setSkuAttrJson(JSONUtil.toJsonStr(skuAttrJson));
            goodsDetails.setSkuAttrNames(skuSaleAttrNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("commentList"))) {
            String commentList = TempUtil.getStr((Selectable)html, paramMap.get("commentList"));
            goodsDetails.setIntroduce(commentList);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("comment"))) {
            HashMap<String, String> comment = new HashMap<String, String>();
            String[] comments = paramMap.get("comment").split(";");
            for (int i = 0; i < comments.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)comments[i])) continue;
                String value = TempUtil.getPrice(TempUtil.getStr((Selectable)html, comments[i]));
                if (StringUtils.isNotEmpty((CharSequence)value) && i == 0) {
                    comment.put("\u603b\u8bc4\u4ef7\u6570", value);
                }
                if (i == 1) {
                    comment.put("\u6652\u56fe", value);
                }
                if (i == 2) {
                    comment.put("\u89c6\u9891\u6652\u5355", value);
                }
                if (i == 3) {
                    comment.put("\u8ffd\u8bc4\u6570", value);
                }
                if (i == 4) {
                    comment.put("\u597d\u8bc4\u6570", value);
                }
                if (i == 5) {
                    comment.put("\u4e2d\u8bc4\u6570", value);
                }
                if (i != 6) continue;
                comment.put("\u5dee\u8bc4\u6570", value);
            }
            goodsDetails.setComment(JSONUtil.toJsonStr(comment));
        }
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }

    public void htmlDriverProcess(Goods goods, GoodsDetailsWithBLOBs goodsDetails, RemoteWebDriver driver, Map<String, String> paramMap) {
        String url;
        String skuId;
        String goodsNo;
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuState"))) {
            String skuState = TempUtil.getDriverStr(driver, paramMap.get("skuState"));
            skuState = StringUtils.isNotEmpty((CharSequence)skuState) ? "0" : "1";
            goods.setSkuState(skuState);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("goodsNo")) && StringUtils.isNotEmpty((CharSequence)(goodsNo = TempUtil.getDriverStr(driver, paramMap.get("goodsNo"))))) {
            goods.setGoodsNo(goodsNo);
            goodsDetails.setGoodsNo(goodsNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuId"))) {
            String spuId = TempUtil.getDriverStr(driver, paramMap.get("spuId"));
            goods.setSpuId(spuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("spuName"))) {
            String spuName = TempUtil.getDriverStr(driver, paramMap.get("spuName"));
            goods.setSpuName(spuName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuId")) && StringUtils.isNotEmpty((CharSequence)(skuId = TempUtil.getDriverStr(driver, paramMap.get("skuId"))))) {
            goods.setSkuId(skuId);
            goodsDetails.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("title"))) {
            String title = TempUtil.getDriverStr(driver, paramMap.get("title"));
            goods.setTitle(title);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("price"))) {
            goods.setPrice(new BigDecimal(TempUtil.getDriverPrice(driver, paramMap.get("price"), false)));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("costPrice"))) {
            goods.setCostPrice(new BigDecimal(TempUtil.getDriverPrice(driver, paramMap.get("costPrice"), false)));
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("pic"))) {
            String pic = TempUtil.getDriverStr(driver, paramMap.get("pic"));
            goods.setPic(pic);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("url")) && !paramMap.get("url").contains("$")) {
            url = TempUtil.getDriverStr(driver, paramMap.get("url"));
            goods.setUrl(url);
        } else {
            url = paramMap.get("url");
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                List<String> placeholderNames = TempUtil.extractPlaceholderNames(url);
                if (CollectionUtils.isNotEmpty(placeholderNames)) {
                    String[] placeholders = new HashMap();
                    for (String placeholderName : placeholderNames) {
                        String value = "";
                        if (StringUtils.isNotEmpty((CharSequence)paramMap.get(placeholderName))) {
                            value = TempUtil.getDriverStr(driver, paramMap.get(placeholderName));
                        } else if (placeholderName.equals("skuId")) {
                            value = goods.getSkuId();
                        }
                        placeholders.put(placeholderName, value);
                    }
                    url = TempUtil.replacePlaceholders(url, placeholders);
                }
                goods.setUrl(url);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandId"))) {
            String brandId = TempUtil.getDriverStr(driver, paramMap.get("brandId"));
            goods.setBrandId(brandId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("shopName"))) {
            String shopName = TempUtil.getDriverStr(driver, paramMap.get("shopName"));
            goods.setSupplierName(shopName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("label"))) {
            String[] labels = paramMap.get("label").split(";");
            String label = "";
            for (String lab : labels) {
                label = label + TempUtil.getDriverStr(driver, lab) + ";";
            }
            goods.setLabel(label);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryId"))) {
            String cateId = "";
            String param = "";
            if (paramMap.get("categoryId").contains("?")) {
                String[] cateIds = paramMap.get("categoryId").split("\\?");
                cateId = TempUtil.getDriverStr(driver, cateIds[0]);
                param = cateIds[1];
            } else {
                cateId = TempUtil.getDriverStr(driver, paramMap.get("categoryId"));
            }
            if (StringUtils.isNotEmpty((CharSequence)cateId) && cateId.contains("/")) {
                cateId = TempUtil.extractValue(cateId, param);
            }
            goods.setCategoryId(cateId);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("categoryName"))) {
            String cateName = TempUtil.getDriverStr(driver, paramMap.get("categoryName"));
            goods.setCategoryName(cateName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttrClick"))) {
            try {
                driver.findElementByCssSelector(paramMap.get("skuAttrClick")).click();
            }
            catch (Exception e) {
                log.error("\u5c5e\u6027\u70b9\u51fb\u5931\u8d25", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttrList"))) {
            try {
                List divs = driver.findElementsByCssSelector(paramMap.get("skuAttrList"));
                String json = "";
                for (WebElement div : divs) {
                    json = json + div.getText() + ";";
                }
                goodsDetails.setExtJson(JSONUtil.toJsonStr((Object)json));
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6skuAttrList\u5143\u7d20\u5931\u8d25", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("skuAttr"))) {
            HashMap<String, String> skuAttrJson = new HashMap<String, String>();
            String skuSaleAttrNames = "";
            ArrayList<String> skuSaleAttrNamesList = new ArrayList<String>();
            List divs = null;
            try {
                String value;
                String name;
                if (paramMap.get("skuAttr").contains("/")) {
                    String[] strs = paramMap.get("skuAttr").split("/");
                    divs = driver.findElementsByCssSelector(paramMap.get("skuAttrList"));
                    for (WebElement div : divs) {
                        name = "";
                        value = "";
                        try {
                            name = div.findElement(By.cssSelector((String)strs[0])).getText();
                            value = div.findElement(By.cssSelector((String)strs[1])).getText();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        skuAttrJson.put(name, value);
                        skuSaleAttrNamesList.add(name);
                    }
                } else {
                    divs = driver.findElementsByCssSelector(paramMap.get("skuAttr"));
                    for (WebElement div : divs) {
                        String[] attrs = div.getText().split("\uff1a");
                        name = "";
                        value = "";
                        if (attrs.length > 1) {
                            name = attrs[0];
                            value = attrs[1];
                        } else {
                            attrs = div.getText().split(":");
                            if (attrs.length > 1) {
                                name = attrs[0];
                                value = attrs[1];
                            } else {
                                attrs = div.getText().split(" ");
                                if (attrs.length > 1) {
                                    name = attrs[0];
                                    value = attrs[1];
                                }
                            }
                        }
                        skuAttrJson.put(name, value);
                        skuSaleAttrNamesList.add(name);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)paramMap.get("brandName"))) {
                    goods.setBrandName((String)skuAttrJson.get("\u54c1\u724c"));
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6skuAttr\u5143\u7d20\u5931\u8d25", (Throwable)e);
            }
            skuSaleAttrNames = String.join((CharSequence)",", skuSaleAttrNamesList);
            goodsDetails.setSkuAttrJson(JSONUtil.toJsonStr(skuAttrJson));
            goodsDetails.setSkuAttrNames(skuSaleAttrNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("brandName"))) {
            String brandName = TempUtil.getDriverStr(driver, paramMap.get("brandName"));
            goods.setBrandName(brandName);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("commentClick"))) {
            try {
                if (paramMap.get("commentClick").contains(";")) {
                    String[] clicks = paramMap.get("commentClick").split(";");
                    if (clicks.length == 2) {
                        driver.findElement(By.cssSelector((String)clicks[0])).click();
                        driver.findElement(By.cssSelector((String)clicks[1])).click();
                    } else {
                        driver.findElementByCssSelector(paramMap.get("commentClick")).click();
                    }
                } else {
                    driver.findElementByCssSelector(paramMap.get("commentClick")).click();
                }
            }
            catch (Exception e) {
                log.error("\u8bc4\u4ef7\u70b9\u51fb\u5931\u8d25", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("commentList"))) {
            String commentList = TempUtil.getDriverStr(driver, paramMap.get("commentList"));
            goodsDetails.setIntroduce(commentList);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramMap.get("comment"))) {
            HashMap<String, String> comment = new HashMap<String, String>();
            String[] comments = paramMap.get("comment").split(";");
            for (int i = 0; i < comments.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)comments[i])) continue;
                String value = TempUtil.getPrice(TempUtil.getDriverStr(driver, comments[i]));
                if (StringUtils.isNotEmpty((CharSequence)value) && i == 0) {
                    comment.put("\u603b\u8bc4\u4ef7\u6570", value);
                }
                if (i == 1) {
                    comment.put("\u6652\u56fe", value);
                }
                if (i == 2) {
                    comment.put("\u89c6\u9891\u6652\u5355", value);
                }
                if (i == 3) {
                    comment.put("\u8ffd\u8bc4\u6570", value);
                }
                if (i == 4) {
                    comment.put("\u597d\u8bc4\u6570", value);
                }
                if (i == 5) {
                    comment.put("\u4e2d\u8bc4\u6570", value);
                }
                if (i != 6) continue;
                comment.put("\u5dee\u8bc4\u6570", value);
            }
            goodsDetails.setComment(JSONUtil.toJsonStr(comment));
        }
    }
}

