/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.aliyun.AliyunConfig;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class GuangBoDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(GuangBoDescriptionProcessor.class);
    @Autowired
    private AliyunConfig aliyunConfig;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        GuangBoDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(page, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u5e7f\u535a\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u5e7f\u535a\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String url = page.getUrl().toString();
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        String goodsno = goods.getGoodsNo();
        try {
            String[] thirdStrings;
            String categoryId;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            Html html = GuangBoDescriptionProcessor.createHtml(driver.getPageSource());
            String pic = html.$("div.photoproduct>div.photopro > ul>li>a>img").xpath("///@src").get();
            String price1 = html.$("#store_price").xpath("///allText()").get();
            String price = price1.replace("\u00a5", "");
            String skuId = html.$("div.detailstop > ul> li:nth-child(3) > span:nth-child(2) ").xpath("///allText()").get();
            String title = html.$("strong.tuang_h").xpath("///allText()").get();
            String catName = html.$("div.position >a:nth-child(4)").xpath("///allText()").get();
            String catId = html.$("div.position >a:nth-child(4)").xpath("///@href").get();
            if (!isAccurate) {
                try {
                    RemoteWebDriver screenshotTaker = driver;
                    RemoteWebDriver js = driver;
                    js.executeScript("window.scrollTo(0, 80);", new Object[0]);
                    js.executeScript("document.body.style.zoom = '0.67';", new Object[0]);
                    File screenshot = (File)screenshotTaker.getScreenshotAs(OutputType.FILE);
                    try {
                        OSS ossClient = new OSSClientBuilder().build(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
                        String ossObjectName = this.aliyunConfig.getBucketName() + "_mymro_" + goodsno + ".png";
                        PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunConfig.getBucketName(), ossObjectName, screenshot);
                        PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
                        String fileUrl = "http://" + this.aliyunConfig.getBucketName() + "." + this.aliyunConfig.getEndpoint() + "/" + ossObjectName;
                        goods.setScreenshot(fileUrl);
                    }
                    catch (Exception e) {
                        log.error("\u56fa\u5b89\u6377\u622a\u56fe\u4e0a\u4f20OSS\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.info("\u56fa\u5b89\u6377\u5546\u57ce\u622a\u56fe\u65f6\u51fa\u73b0\u95ee\u9898", (Object)goods.getGoodsNo());
                    log.error("\u622a\u56fe\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("list_"))[1].replace(".htm", "")))) {
                goods.setCategoryId(categoryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)catName)) {
                goods.setCategoryName(catName);
            }
            if (StringUtils.isNotEmpty((CharSequence)skuId)) {
                goods.setSkuId(skuId);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPic(pic);
            goods.setPrefix(MallType.Guangbo.getCode());
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                goods.setPrice(new BigDecimal(price));
            } else {
                log.info("\u5e7f\u535a\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            goodsDetails.setPrefix(MallType.Guangbo.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(goods.getSkuId());
            goodsDetails.setSkuAttrNames("\u672a\u83b7\u53d6\u5230\u76f8\u5173\u4fe1\u606f");
            goodsDetails.setSkuAttrJson("");
            goodsDetails.setCreated(new Date());
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u722c\u53d6\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ce\u9875\u9762\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        Site site = Site.me().setUserAgent("Mozilla/5.0...");
        return site;
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

