/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.minio.MinioHelper;
import com.tydic.nicc.spider.api.ProxyService;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.aliyun.AliyunConfig;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.config.util.ChineseCharactersUtils;
import com.tydic.nicc.spider.config.util.OssUploaderUtil;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsCommentPO;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
@Service
public class JdDescriptionProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdDescriptionProcessorWithSelfDriver.class);
    private final OssUploaderUtil ossUploaderUtil;
    @Autowired
    private AliyunConfig aliyunConfig;
    @Autowired
    private ProxyService proxyService;
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    private static boolean isAccurate;
    @Autowired
    private MinioHelper minioHelper;
    @Value(value="${nicc-plugin.spider.isPiderComment}")
    private boolean isPiderComment;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Autowired
    private CommodityInformationServiceFactory commodityInformationServiceFactory;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Autowired
    public JdDescriptionProcessorWithSelfDriver(OssUploaderUtil ossUploaderUtil) {
        this.ossUploaderUtil = ossUploaderUtil;
    }

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        JdDescriptionProcessorWithSelfDriver.isAccurate = isAccurate;
    }

    public Map<String, Object> process(RemoteWebDriver driver, Goods paramTo) {
        String url = paramTo.getUrl();
        String goodsNo = paramTo.getGoodsNo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String skuId = null;
        try {
            Pattern pattern = Pattern.compile("[^0-9]+");
            Matcher matcher = pattern.matcher(url);
            skuId = matcher.replaceAll("").trim();
            paramTo.setSkuId(skuId);
            driver = this.commodityInformationServiceFactory.loginCookie(MallType.JD.getCode(), driver);
            TimeUnit.SECONDS.sleep(1L);
            driver.executeScript("window.open('" + url + "','newwindow')", new Object[0]);
            Set windowHandles = driver.getWindowHandles();
            Iterator iterator = windowHandles.iterator();
            iterator.next();
            String window = (String)iterator.next();
            log.info("\u6253\u5f00\u65b0\u7a97\u53e3");
            driver.switchTo().window(window);
            driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
            if (StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://www.jd.com/?") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://passport.jd.com/") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://cfe.m.jd.com")) {
                throw new DcBusinessException("ip\u88ab\u5c01\u5f53\u524durl:" + driver.getCurrentUrl());
            }
            Html html = this.newHtml(driver);
            if (html != null) {
                if (StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://www.jd.com/?") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://passport.jd.com/") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://cfe.m.jd.com")) {
                    throw new DcBusinessException("\u672a\u83b7\u53d6\u6b63\u786e\u6570\u636e\u5f53\u524durl:" + driver.getCurrentUrl());
                }
            } else {
                throw new DcBusinessException("ip\u88ab\u5c01\u5f53\u524durl:" + driver.getCurrentUrl());
            }
            this.pageProcess(map, html, paramTo, driver, url);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u5f02\u5e38{},driver{}", new Object[]{goodsNo, e, driver});
            driver.quit();
            throw new DcBusinessException(e.getMessage());
        }
        return map;
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private void pageProcess(Map<String, Object> map, Html html, Goods goods, RemoteWebDriver driver, String url) {
        List nodesback;
        List nodesPack;
        HashMap extJsonMap = new HashMap();
        HashMap<String, String> comment = new HashMap<String, String>();
        String goodsno = goods.getGoodsNo();
        GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
        goods.setPrefix(MallType.JD.getCode());
        goodsDetailsWithBLOBs.setGoodsNo(goods.getGoodsNo());
        goodsDetailsWithBLOBs.setPrefix(MallType.JD.getCode());
        goodsDetailsWithBLOBs.setExecutionNumber(goods.getExecutionNumber());
        String categoryName = html.$("#crumb-wrap > div > div.crumb.fl.clearfix > div:nth-child(5) > a").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            goods.setCategoryId(ChineseCharactersUtils.toPinyin(categoryName));
            goods.setCategoryName(categoryName);
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetailsWithBLOBs);
        String brandName = html.$("ul#parameter-brand li[title]").xpath("///@title").get();
        if (StringUtils.isBlank((CharSequence)brandName)) {
            brandName = html.$("div.J-hove-wrap > div.item > div.name >a[title]").xpath("///@title").get();
        }
        goods.setBrandName(brandName);
        String title = html.$("div.sku-name").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            goods.setTitle(title);
        }
        ArrayList<String> label = new ArrayList<String>();
        String three = null;
        String one = null;
        String two = null;
        String label1 = html.$("div.dd.J-prom-wrap.p-promotions-wrap > div.p-promotions > ins:nth-child(5) > div.J-prom ").xpath("///allText()").get();
        String label2 = html.$("div.w > div.product-intro.clearfix > div.itemInfo-wrap > div.sku-name > img ").xpath("///alt").get();
        String label3 = html.$("div.contact.fr.clearfix.shieldShopInfo > div.name.goodshop.EDropdown > em").xpath("///allText()").get();
        if (!StringUtils.isEmpty((CharSequence)label1)) {
            one = label1.replaceAll("\\s+", ",");
            label.add(one);
        }
        if (!StringUtils.isEmpty((CharSequence)label2)) {
            two = label2;
            label.add(two);
        }
        if (!StringUtils.isEmpty((CharSequence)label3)) {
            three = label3;
            label.add(three);
        }
        goods.setLabel(((Object)label).toString());
        String supplierName = html.$("div.J-hove-wrap.EDropdown.fr > div.item > div.name ").xpath("///allText()").get();
        String supplierName1 = null;
        if (StringUtils.isNotEmpty((CharSequence)supplierName)) {
            goods.setSupplierName(supplierName);
        } else {
            supplierName1 = html.$("div.sh-brand.sh-hot-wrap > div.shop-name-box > span ").xpath("///allText()").get();
            if (StringUtils.isNotEmpty((CharSequence)supplierName1)) {
                goods.setSupplierName(supplierName1);
            } else {
                goods.setSupplierName("jd");
            }
        }
        String price = null;
        String str = html.$("div.itemover-tip").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            goods.setSkuState("0");
        } else {
            goods.setSkuState("1");
            try {
                price = html.$("span.p-price > span.price.J-p-" + goods.getSkuId()).xpath("///allText()").get();
                for (int num = 1; StringUtils.isEmpty((CharSequence)price) && num <= 3; ++num) {
                    WebDriverWait wait = new WebDriverWait((WebDriver)driver, 20L);
                    WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.className((String)("J-p-" + goods.getSkuId()))));
                    price = element.getText();
                }
            }
            catch (Exception num) {
                // empty catch block
            }
            goods.setSkuState("1");
        }
        if (StringUtils.isNotBlank(price) && !price.equals("\u6682\u65e0\u62a5\u4ef7")) {
            goods.setPrice(new BigDecimal(price));
        } else {
            goods.setPrice(new BigDecimal(0));
        }
        String picUrl = html.$("#spec-img").xpath("///@src").get();
        if (StringUtils.isNotBlank((CharSequence)picUrl)) {
            goods.setPic("https:" + picUrl);
        }
        List nodes = html.$("div#choose-attrs > div.p-choose").nodes();
        String skuSaleAttrNames = "";
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            ArrayList saleAttrList = new ArrayList();
            nodes.forEach(node -> {
                String saleAttr = node.xpath("///@data-type").get();
                if (StringUtils.isNotEmpty((CharSequence)saleAttr)) {
                    saleAttrList.add(saleAttr);
                }
            });
            skuSaleAttrNames = String.join((CharSequence)".", saleAttrList);
        }
        String skuAttrNames = "";
        String skuAttrJson = "";
        List nodes1 = html.$("div.p-parameter ul.parameter2.p-parameter-list > li[title]").nodes();
        if (CollectionUtils.isEmpty((Collection)nodes1) && (html = this.newHtml(driver)) != null) {
            nodes1 = html.$("div.p-parameter ul.parameter2.p-parameter-list > li[title]").nodes();
        }
        if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
            ArrayList attrList = new ArrayList();
            HashMap jsonMap = new HashMap();
            nodes1.forEach(node -> {
                String attr = node.xpath("///allText()").get();
                String attrValue = node.xpath("///@title").get();
                if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{attr, attrValue})) {
                    String[] split = attr.split("\uff1a");
                    attr = split[0];
                    attrList.add(attr);
                    jsonMap.put(attr, attrValue);
                }
            });
            skuAttrNames = String.join((CharSequence)",", attrList);
            skuAttrJson = JSONUtil.toJsonStr(jsonMap);
        }
        String introduce = html.$("div.Ptable").get();
        String extJson = "";
        List nodes2 = html.$("div.Ptable > div.Ptable-item").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes2)) {
            nodes2.forEach(node -> {
                String na = node.$("h3").xpath("///allText()").get();
                List nodes3 = node.$("dl > dl.clearfix").nodes();
                if (CollectionUtils.isNotEmpty((Collection)nodes3)) {
                    nodes3.forEach(node1 -> {
                        String me = node1.$("dt").xpath("///allText()").get();
                        String value = node1.$("dd").xpath("///allText()").get();
                        extJsonMap.put(na + "." + me, value);
                    });
                } else {
                    List dtList = node.$("dl > dt").nodes();
                    List ddList = node.$("dl > dd").nodes();
                    for (int i = 0; i < dtList.size(); ++i) {
                        String me = ((Selectable)dtList.get(i)).xpath("///allText()").get();
                        String value = ((Selectable)ddList.get(i)).xpath("///allText()").get();
                        extJsonMap.put(na + "." + me, value);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(nodesPack = html.$("div.package-list").nodes()))) {
            nodesPack.forEach(node -> {
                String na = node.$("h3").xpath("///allText()").get();
                String value = node.$("p").xpath("///allText()").get();
                extJsonMap.put(na, value);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(nodesback = html.$("div.serve-agree-bd").nodes()))) {
            nodesback.forEach(node -> {
                List dtList = node.$("dl > dt").nodes();
                List ddList = node.$("dl > dd").nodes();
                for (int i = 0; i < dtList.size(); ++i) {
                    String me = ((Selectable)dtList.get(i)).xpath("///allText()").get();
                    String value = ((Selectable)ddList.get(i)).xpath("///allText()").get();
                    extJsonMap.put(me, value);
                }
            });
        }
        if (this.isPiderComment) {
            int num;
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 20L);
            WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"li[data-anchor='#comment']")));
            for (num = 1; element == null && num <= 3; ++num) {
                element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"li[data-anchor='#comment']")));
            }
            if (element != null) {
                element.click();
            }
            try {
                element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"comm-curr-sku")));
                for (num = 1; element == null && num <= 3; ++num) {
                    element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"comm-curr-sku")));
                }
                if (element != null) {
                    element.click();
                }
            }
            catch (Exception e) {
                log.error("\u6ca1\u6709\u5f53\u524d\u5546\u54c1\u8bc4\u4ef7");
            }
            try {
                this.getMent(comment, driver);
            }
            catch (Exception e) {
                log.error("\u8bc4\u4ef7\u5f02\u5e38", (Throwable)e);
            }
        }
        if (isAccurate) {
            String prefix = goods.getPrefix();
            String screenshotUrl = this.ossUploaderUtil.uploadScreenshot((WebDriver)driver, goodsno, prefix);
            goods.setScreenshot(screenshotUrl);
        }
        try {
            if (extJsonMap != null) {
                extJson = JSONUtil.toJsonStr(extJsonMap);
            }
            String commentStr = "";
            if (comment != null && comment.size() > 0) {
                commentStr = JSONUtil.toJsonStr(comment);
            }
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{skuAttrNames, skuAttrJson})) {
                log.info("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)driver.getCurrentUrl());
                throw new DcBusinessException("\u5c5e\u6027\u6570\u636e\u83b7\u53d6\u5931\u8d25");
            }
            goodsDetailsWithBLOBs.setSkuId(goods.getSkuId());
            goodsDetailsWithBLOBs.setSkuSaleAttrNames(skuSaleAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrNames(skuAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrJson(skuAttrJson);
            goodsDetailsWithBLOBs.setIntroduce(introduce);
            goodsDetailsWithBLOBs.setExtJson(extJson);
            goodsDetailsWithBLOBs.setComment(commentStr);
            log.info("\u4eac\u4e1c\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u6210\u529f{}", (Object)goods.getGoodsNo(), (Object)driver.getCurrentUrl());
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7", (Throwable)e);
        }
    }

    private Html newHtml(RemoteWebDriver driver) {
        Html html = null;
        try {
            PageOperateUtil.pageRefresh(driver);
            String rawText = driver.getPageSource();
            html = this.createHtml(rawText);
            if (html == null) {
                log.info("\u672a\u83b7\u53d6\u5230\u9875\u9762\u5143\u7d20{}", (Object)driver.getCurrentUrl());
            }
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u5546\u57ce\u6570\u636e{}\u89e3\u6790\u5931\u8d25{}", (Object)driver.getCurrentUrl(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        return html;
    }

    private void getMent(HashMap<String, String> comment, RemoteWebDriver driver) {
        String goodRateShow = "0";
        String commentCountStr = "0";
        String imageNum = "0";
        String videoCountStr = "0";
        String afterCountStr = "0";
        String goodCountStr = "0";
        String generalCountStr = "0";
        String poorCountStr = "0";
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        try {
            goodRateShow = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div.comment-percent > div")))).getText();
            goodRateShow = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div.comment-percent > div")))).getText();
            commentCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)" ul.filter-list > li.current > a > em")))).getText().replace("(", "").replace(")", "");
            imageNum = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(2) > a > em")))).getText().replace("(", "").replace(")", "");
            videoCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(3) > a > em")))).getText().replace("(", "").replace(")", "");
            afterCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(4) > a > em")))).getText().replace("(", "").replace(")", "");
            goodCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(5) > a > em")))).getText().replace("(", "").replace(")", "");
            generalCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(6) > a > em")))).getText().replace("(", "").replace(")", "");
            poorCountStr = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"ul.filter-list > li:nth-child(7) > a > em")))).getText().replace("(", "").replace(")", "");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bc4\u4ef7\u5931\u8d25");
        }
        comment.put("\u597d\u8bc4\u5ea6", goodRateShow);
        comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
        comment.put("\u6652\u56fe", imageNum);
        comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
        comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
        comment.put("\u597d\u8bc4\u6570", goodCountStr);
        comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
        comment.put("\u5dee\u8bc4\u6570", poorCountStr);
    }

    private int goodsComment(String goodNo, int page, HashMap<String, String> comment) {
        String result;
        String url = "https://api.m.jd.com/?appid=item-v3&functionId=pc_club_skuProductPageComments&client=pc&clientVersion=1.0.0&loginType=3&productId=" + goodNo + "&score=0&sortType=5&page=" + page + "&pageSize=10&isShadowSku=0&fold=1&bbtf=&shield=";
        HttpResponse response = HttpRequest.get((String)url).execute();
        int totalPage = 0;
        if (response.isOk() && StringUtils.isNotBlank((CharSequence)(result = response.body()))) {
            JSONArray list;
            JSONArray jsonObject;
            JSONObject object = JSONObject.parseObject((String)result);
            totalPage = object.getInteger("maxPage");
            int n = totalPage = totalPage > 100 ? 100 : totalPage;
            if (totalPage == 0) {
                return totalPage;
            }
            if (page == 0 && totalPage > 0) {
                String imageNum = object.getString("imageListCount");
                JSONObject commentsummary = object.getJSONObject("productCommentSummary");
                if (commentsummary != null) {
                    String goodRateShow = commentsummary.getString("goodRateShow");
                    String commentCountStr = commentsummary.getString("commentCountStr");
                    String videoCountStr = commentsummary.getString("videoCountStr");
                    String afterCountStr = commentsummary.getString("afterCountStr");
                    String goodCountStr = commentsummary.getString("goodCountStr");
                    String generalCountStr = commentsummary.getString("generalCountStr");
                    String poorCountStr = commentsummary.getString("poorCountStr");
                    comment.put("\u597d\u8bc4\u5ea6", goodRateShow + "%");
                    comment.put("\u603b\u8bc4\u4ef7\u6570", commentCountStr);
                    comment.put("\u6652\u56fe", imageNum);
                    comment.put("\u89c6\u9891\u6652\u5355\u6570", videoCountStr);
                    comment.put("\u8ffd\u8bc4\u6570", afterCountStr);
                    comment.put("\u597d\u8bc4\u6570", goodCountStr);
                    comment.put("\u4e2d\u8bc4\u6570", generalCountStr);
                    comment.put("\u5dee\u8bc4\u6570", poorCountStr);
                }
                Object commentTag = object.get((Object)"hotCommentTagStatistics");
                String statistics = "";
                if (commentTag != null) {
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    JSONArray list2 = JSONObject.parseArray((String)commentTag.toString(), (Feature[])new Feature[0]);
                    for (Map map : list2) {
                        map1.put(map.get("name").toString(), map.get("count").toString());
                    }
                    statistics = JSONUtil.toJsonStr(map1);
                } else {
                    statistics = "\u6682\u65e0\u4e70\u5bb6\u5370\u8c61";
                }
                comment.put("\u4e70\u5bb6\u5370\u8c61", statistics);
            }
            if ((jsonObject = object.getJSONArray("comments")) != null && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0])))) {
                ArrayList<GoodsCommentPO> goodsCommentPOS = new ArrayList<GoodsCommentPO>();
                for (Map map : list) {
                    GoodsCommentPO commentPO = new GoodsCommentPO();
                    commentPO.setPrefix(MallType.JD.getCode());
                    commentPO.setCreatetime(new Date());
                    commentPO.setUpdatetime(new Date());
                    if (map.get("nickname") != null) {
                        commentPO.setUserName(map.get("nickname").toString());
                    }
                    if (map.get("id") != null) {
                        commentPO.setCommentId(map.get("id").toString());
                    }
                    if (map.get("content") != null) {
                        commentPO.setCommentCon(map.get("content").toString());
                    }
                    if (map.get("creationTime") != null) {
                        commentPO.setCommentTime(map.get("creationTime").toString());
                    }
                    if (map.get("productColor") != null && map.get("productSize") != null) {
                        commentPO.setGoodAttr(map.get("productColor") + "  " + map.get("productSize"));
                    }
                    commentPO.setGoodsNo(goodNo);
                    if (map.get("location") != null) {
                        commentPO.setLocation(map.get("location").toString());
                    }
                    if (map.get("plusAvailable") != null) {
                        commentPO.setPlusAvailable(map.get("plusAvailable").toString());
                    }
                    if (map.get("replyCount") != null) {
                        commentPO.setSpriteComment(map.get("replyCount").toString());
                    }
                    if (map.get("topped") != null) {
                        commentPO.setSpritePraise(map.get("topped").toString());
                    }
                    if (map.get("score") != null) {
                        commentPO.setStar(map.get("score").toString());
                    }
                    goodsCommentPOS.add(commentPO);
                }
                this.executorService.submit(() -> this.processDataPipeline.processDataList(goodsCommentPOS));
            }
        }
        return totalPage;
    }
}

