/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.aliyun.AliyunConfig;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class LFutureDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(LFutureDescriptionProcessor.class);
    @Autowired
    private AliyunConfig aliyunConfig;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        LFutureDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(page, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u9886\u5148\u672a\u6765\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u9886\u5148\u672a\u6765\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String url = page.getUrl().toString();
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        try {
            String price;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            Html html = LFutureDescriptionProcessor.createHtml(driver.getPageSource());
            List nodes = html.$(" div.parameter-table > table.ptable > tbody >tr").nodes();
            HashMap hashMap = new HashMap();
            StringBuilder commodityAttribute = new StringBuilder();
            nodes.forEach(selectable -> {
                String goodsAttribute = selectable.$("td:nth-child(1)").xpath("///allText()").get();
                String goodsSaleAttribute = selectable.$("td:nth-child(2)").xpath("///allText()").get();
                commodityAttribute.append(goodsAttribute + ",");
                hashMap.put(goodsAttribute, goodsSaleAttribute);
            });
            String skuAttrJson = JSON.toJSONString(hashMap);
            String skuid = html.$("div.p-number.clearfloat > div > span").xpath("///allText()").get();
            goods.setSkuId(skuid);
            String key = "\u54c1\u724c:";
            Object value = hashMap.get(key);
            String brandName = null;
            if (value != null) {
                brandName = value.toString();
                goods.setBrandName(brandName);
            }
            if (StringUtils.isEmpty((CharSequence)(price = html.$("div.parameter.fl > div.p-price > span.price").xpath("///allText()").get()))) {
                String price1 = html.$("div.ncs-tabbar-buy.up>a>div.p-price>span").xpath("///allText()").get();
                if (price1 != null && price1.contains("\u4e0d\u597d\u610f\u601d\uff0c\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6")) {
                    log.info("\u9886\u5148\u672a\u6765\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                    goods.setPrice(BigDecimal.ZERO);
                }
            } else {
                goods.setPrice(new BigDecimal(price));
            }
            String picUrl = html.$("div.details-header.clearfloat > div.magnifier.fl >div.magnifier-small > img").xpath("///@src").get();
            String title = html.$("div.parameter.fl > div.p-name ").xpath("///allText()").get();
            if (!isAccurate) {
                try {
                    driver.executeScript("document.querySelector('div.dtab.fr.clearfloat > ul > li:nth-child(3)').click();", new Object[0]);
                    Thread.sleep(500L);
                    RemoteWebDriver screenshotTaker = driver;
                    RemoteWebDriver js = driver;
                    js.executeScript("window.scrollTo(0, 80);", new Object[0]);
                    js.executeScript("document.body.style.zoom = '0.8';", new Object[0]);
                    File screenshot = (File)screenshotTaker.getScreenshotAs(OutputType.FILE);
                    try {
                        OSS ossClient = new OSSClientBuilder().build(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
                        String ossObjectName = this.aliyunConfig.getBucketName() + "_lxwl" + skuid + ".png";
                        PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunConfig.getBucketName(), ossObjectName, screenshot);
                        PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
                        String fileUrl = "http://" + this.aliyunConfig.getBucketName() + "." + this.aliyunConfig.getEndpoint() + "/" + ossObjectName;
                        goods.setScreenshot(fileUrl);
                    }
                    catch (Exception e) {
                        log.error("\u9886\u5148\u672a\u6765\u622a\u56fe\u4e0a\u4f20OSS\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.info("\u9886\u5148\u672a\u6765\u5546\u57ce\u622a\u56fe\u65f6\u51fa\u73b0\u95ee\u9898", (Object)goods.getGoodsNo());
                    log.error("\u622a\u56fe\u5f02\u5e38\u8be6\u60c5", (Throwable)e);
                }
            }
            goods.setUrl(url);
            if (StringUtils.isNotEmpty((CharSequence)picUrl)) {
                goods.setPic(picUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPrefix(MallType.Lxwl.getCode());
            goods.setBrandName(brandName);
            goodsDetails.setPrefix(MallType.Lxwl.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(skuid);
            goodsDetails.setSkuAttrNames(commodityAttribute.toString());
            goodsDetails.setSkuAttrJson(skuAttrJson);
            goodsDetails.setCreated(new Date());
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u722c\u53d6\u9886\u5148\u672a\u6765\u5546\u57ce\u9875\u9762\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        return Site.me();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

