/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.minio.MinioHelper;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.OssUploaderUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class MatemroDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(MatemroDescriptionProcessor.class);
    private final OssUploaderUtil ossUploaderUtil;
    @Autowired
    private MinioHelper minioHelper;
    private static boolean isAccurate;

    @Autowired
    public MatemroDescriptionProcessor(OssUploaderUtil ossUploaderUtil) {
        this.ossUploaderUtil = ossUploaderUtil;
    }

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        MatemroDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(page, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) throws InterruptedException {
        String url = page.getUrl().toString();
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        try {
            String categoryId;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            Html html = MatemroDescriptionProcessor.createHtml(driver.getPageSource());
            List nodes = html.$("div.ncs-intro>div>ul>li").nodes();
            HashMap hashMap = new HashMap();
            StringBuilder commodityAttribute = new StringBuilder();
            ArrayList skuId1 = new ArrayList();
            nodes.forEach(selectable -> {
                String goodsAttribute1 = selectable.$("li").xpath("///allText()").get();
                String goodsAttribute = goodsAttribute1.replaceAll(" ", "").split("\uff1a")[0];
                String goodsSaleAttribute1 = selectable.$("li").xpath("///allText()").get();
                String goodsSaleAttribute = goodsSaleAttribute1.replaceAll(" ", "").split("\uff1a")[1];
                if (goodsAttribute.contains("SKU\u7f16\u7801")) {
                    skuId1.add(goodsSaleAttribute);
                }
                commodityAttribute.append(goodsAttribute + ",");
                hashMap.put(goodsAttribute, goodsSaleAttribute);
            });
            String skuAttrJson = JSON.toJSONString(hashMap);
            String goodsNo = url.replaceAll(" ", "").split("goods/")[1];
            goods.setGoodsNo(goodsNo);
            String brandName = html.$("div.ncs-meta.pr>dl:nth-child(4)>dd>span.goods-price-real").xpath("///allText()").get();
            String price1 = html.$("div.ncs-tabbar-buy.up>a>span.price>span:nth-child(2)").xpath("///allText()").get();
            String price2 = html.$("div.ncs-tabbar-buy.up>a>span.price>span:nth-child(4)").xpath("///allText()").get();
            String price = price1 + "." + price2;
            if (StringUtils.isEmpty((CharSequence)price)) {
                log.info("\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            String skuId = (String)skuId1.get(skuId1.size() - 1);
            String picUrl = html.$("div.ncs-goods-picture.image_zoom>a").xpath("///@href").get();
            String title = html.$("div.nch-breadcrumb-layout>div.nch-breadcrumb.wrapper>span:nth-child(10)").xpath("///allText()").get();
            String catName = html.$("div.nch-breadcrumb-layout>div.nch-breadcrumb.wrapper >span:nth-last-child(5) > a").xpath("///allText()").get();
            String catId = html.$("div.nch-breadcrumb-layout>div.nch-breadcrumb.wrapper > span:nth-last-child(5) > a").xpath("///@href").get();
            goods.setSupplierName("\u81ea\u8425");
            String goodsno = goods.getGoodsNo();
            if (!isAccurate) {
                String prefix = goods.getPrefix();
                String screenshotUrl = this.ossUploaderUtil.uploadScreenshot((WebDriver)driver, goodsno, prefix);
                goods.setScreenshot(screenshotUrl);
            }
            goods.setUrl(url);
            if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = catId.replaceAll(" ", "").split("=")[1]))) {
                goods.setCategoryId(categoryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)catName)) {
                goods.setCategoryName(catName);
            }
            if (StringUtils.isNotEmpty((CharSequence)picUrl)) {
                goods.setPic(picUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)skuId)) {
                goods.setSkuId(skuId);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPrefix(MallType.Matemro.getCode());
            goods.setBrandName(brandName);
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                goods.setPrice(new BigDecimal(price));
            } else {
                log.info("\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            goodsDetails.setPrefix(MallType.Matemro.getCode());
            goodsDetails.setGoodsNo(goodsNo);
            goodsDetails.setSkuId(skuId);
            goodsDetails.setSkuAttrNames(commodityAttribute.toString());
            goodsDetails.setSkuAttrJson(skuAttrJson);
            goodsDetails.setCreated(new Date());
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u722c\u53d6\u6b27\u83f2\u65af\u5de5\u4e1a\u5546\u57ce\u9875\u9762\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        return Site.me();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

