/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class OfsDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(OfsDescriptionProcessor.class);
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        OfsDescriptionProcessor.isAccurate = isAccurate;
    }

    public void process(Page page) {
        Selectable url = page.getUrl();
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        try {
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(page, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("ofs\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("ofs\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String url = page.getUrl().toString();
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        try {
            String[] thirdStrings;
            String categoryId;
            Document document;
            Element metaElement;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            Thread.sleep(5000L);
            Html html = OfsDescriptionProcessor.createHtml(driver.getPageSource());
            List divs = html.$("div.detail-content > div > div > table > tbody > tr").nodes();
            HashMap hashMap = new HashMap();
            StringBuilder commodityAttribute = new StringBuilder();
            divs.forEach(selectable -> {
                String goodsAttribute = selectable.$("td:nth-child(1) > span").xpath("///allText()").get();
                String goodsSaleAttribute = selectable.$("td:nth-child(2) > span").xpath("///allText()").get();
                commodityAttribute.append(goodsAttribute + ",");
                hashMap.put(goodsAttribute, goodsSaleAttribute);
            });
            String skuAttrJson = JSON.toJSONString(hashMap);
            String brandName = html.$("div.product-params > table > tbody > tr > td:nth-child(6) > a").xpath("///allText()").get();
            String price = html.$("ins.action-price").xpath("///allText()").get();
            if (StringUtils.isEmpty((CharSequence)price) && (metaElement = (document = html.getDocument()).select("meta[property=og:product:price]").first()) != null) {
                price = metaElement.attr("content");
            }
            String skuId = html.$("div.product-params > table > tbody > tr > td:nth-child(4)").xpath("///allText()").get();
            String title = html.$("div.product-titles>h2").xpath("///allText()").get();
            String pic = html.$("div.page-maincontent > div.product-container.clearfix > form >div.product-side >div.product-album >div.product-album-preview.clearfix >div.product-album-pic > a > img").xpath("///@src").get();
            String catName = html.$("div.bread-crumbs > span:nth-child(7) > a").xpath("///allText()").get();
            String catId = html.$("div.bread-crumbs > span:nth-child(7) > a").xpath("///@href").get();
            if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("-"))[1].replace(".html", "")))) {
                goods.setCategoryId(categoryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)catName)) {
                goods.setCategoryName(catName);
            }
            if (StringUtils.isNotEmpty((CharSequence)skuId)) {
                goods.setSkuId(skuId);
            }
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            }
            goods.setPic(pic);
            goods.setPrefix(MallType.Ofs.getCode());
            goods.setBrandName(brandName);
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                String cleanedPrice = price.replaceAll("\uffe5", "");
                goods.setPrice(new BigDecimal(cleanedPrice));
            } else {
                log.info("ofs\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
                goods.setSkuState("0");
            }
            goodsDetails.setPrefix(MallType.Ofs.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(skuId);
            goodsDetails.setSkuAttrNames(commodityAttribute.toString());
            goodsDetails.setSkuAttrJson(skuAttrJson);
            goodsDetails.setCreated(new Date());
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u722c\u53d6\u6b27\u83f2\u65af\u529e\u516c\u5546\u57ce\u9875\u9762\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        return Site.me();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

